/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.clock;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TETL1LockClockSourceBean
extends TETL1NEExplorerBean {
    private static final String INTERNAL_CLOCKSOURCE = "INTERNAL";

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        if (part.getName().equalsIgnoreCase("AID")) {
            String aid = rowparams.getParam("clockaid").getValue();
            if (aid.equalsIgnoreCase(INTERNAL_CLOCKSOURCE)) {
                return false;
            }
            part.setValue(aid);
            return true;
        }
        if (part.getName().equalsIgnoreCase("SYNCLOCK")) {
            String lockState = rowparams.getParam("lockstate").getValue();
            part.setValue(lockState);
            return true;
        }
        return false;
    }

    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                String tl1Mod2 = TETL1CommonUtil.getTL1CmdMod2((String)subfunc.getQxMapping(i).getContent());
                tl1List.add(tl1Mod2);
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            tl1Operation = rowparams.getParam("mode2").getValue().equalsIgnoreCase("T1") ? tl1Definitions.getTL1Operation((String)tl1List.get(1)) : tl1Definitions.getTL1Operation((String)tl1List.get(0));
            this.changeMod2(tl1Operation, rowparams);
            this.curTL1Operation = tl1Operation;
            if (null == tl1Operation) continue;
            inputMsg = tl1Operation.getInMsg();
            if (null == inputMsg) {
                tl1OperList.add(tl1Operation);
                continue;
            }
            tl1Operation.clearCmdFaultInfo();
            fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock());
            if (fillComplete) {
                fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
            }
            if (!this.msgBlockFlag && !fillComplete) continue;
            tl1OperList.add(tl1Operation);
        }
        return tl1OperList;
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        tl1Operation.setMod1(rowparams.getParam("mode2").getValue());
    }

    protected boolean fillMsgBlock(RowParams rowparams, MsgBlock msgBlock) {
        boolean flag = true;
        DataBlock dataBlock = null;
        Part part = null;
        int num = 0;
        int len = msgBlock.getDataBlockCount();
        for (int i = 0; i < len; ++i) {
            dataBlock = msgBlock.getDataBlock(i);
            int size = dataBlock.getPartCount();
            for (int j = 0; j < size; ++j) {
                part = dataBlock.getPart(j);
                if (!this.convertPartValue(part, rowparams)) continue;
                ++num;
            }
        }
        if (num < 1) {
            flag = false;
        }
        return flag;
    }
}

