/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.clock;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import java.util.ArrayList;
import java.util.Vector;

public class TEGetAllClockSource
extends TETL1NEExplorerBean {
    private ArrayList clockidlist = new ArrayList();
    private int neid;
    private static final int SLOTCONSTATNS = 100;
    private static final int BDTYPE_TN12SC1 = 1275;
    private static final int BDTYPE_TN12SC2 = 1262;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        TENE ne = TENEListUtils.getNEObj((int)neid);
        Vector boardList = null;
        boardList = ne.getBoardList();
        int sccid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        int shelfid = sccid / 100;
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            int type;
            TEBoard board = (TEBoard)boardList.get(i);
            int boardid = board.getSlotID();
            int boardshelf = boardid / 100;
            if (boardshelf != shelfid || (type = board.getBoardType()) != 1275 && type != 1262) continue;
            this.addclockid(board);
        }
        this.filterClock(inputData);
        this.outputData = new Datainterface();
        BussinessParams bussinessParam = new BussinessParams();
        int len2 = this.clockidlist.size();
        for (int i = 0; i < len2; ++i) {
            RowParams rowparam = new RowParams();
            int clockid = (Integer)this.clockidlist.get(i);
            rowparam.addParam("clockid", clockid + "");
            rowparam.addParam("clockname", this.getClockSourceName(neid, clockid));
            bussinessParam.addRowParams(rowparam);
        }
        this.outputData.setBussinessParams(bussinessParam);
        return this.outputData;
    }

    private void filterClock(Datainterface inputData) {
        RowParams[] rowparams = inputData.getBussinessParams().getRowParams();
        int len = rowparams.length;
        block0: for (int i = 0; i < len; ++i) {
            Param param = rowparams[i].getParam("clockid");
            int hasclocid = Integer.parseInt(param.getValue());
            int lens = this.clockidlist.size();
            for (int j = 0; j < lens; ++j) {
                int newclock = (Integer)this.clockidlist.get(j);
                if (newclock != hasclocid) continue;
                this.clockidlist.remove(j);
                continue block0;
            }
        }
    }

    private void addclockid(TEBoard board) {
        int boardtype = board.getBoardType();
        int slotid = board.getSlotID();
        ArrayList portnolist = TEConfigurationDataMgr.getInstance().getBoardPortList(this.neid, boardtype);
        int len = portnolist.size();
        for (int i = 0; i < len; ++i) {
            int portid = (Integer)portnolist.get(i);
            int clockid = (slotid << 8) + portid;
            this.clockidlist.add(new Integer(clockid));
        }
    }

    public String getClockSourceName(int neid, int clockid) {
        int slotid = clockid >> 8 & 0xFF;
        int portid = clockid & 0xFF;
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        int boardtype = board.getBoardType();
        String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, portid);
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
        StringBuffer name = new StringBuffer();
        name.append(slotid).append("-").append(boardname).append("-").append(portname);
        return name.toString();
    }
}

