/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.bps;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.bps.TEBPSData;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;

public class TEBPSQueryBean
extends TETL1NEExplorerBean {
    ArrayList operationList = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        this.outputData = new Datainterface();
        try {
            this.operationList = this.getTL1Operation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = super.sendMessage(neid, this.operationList);
            if (result != 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                return this.outputData;
            }
            this.handleMessage(neid, this.operationList, subFunc, this.getFilterErrorCodeList());
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(new Integer(38662));
        return errorCodeList;
    }

    protected Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList tl1OperList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        int tl1OperSize = tl1OperList.size();
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        ArrayList errorData = this.joinTL1Operation(neid, subfunc, tl1OperList, filterErrorCodeList);
        TL1Operation tl1Operation = null;
        RowParams rowparams = null;
        if (0 == tl1OperList.size()) {
            if (null == errorData || 0 == errorData.size()) {
                TEBPSData.getInstance().clear();
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else if (errorData.size() >= tl1OperSize) {
                rowparams = new RowParams();
                int sizei = errorData.size();
                for (int ii = 0; ii < sizei; ++ii) {
                    rowparams.addRowErrors((RowErrors)errorData.get(ii));
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            } else {
                rowparams = new RowParams();
                int sizei = errorData.size();
                for (int ii = 0; ii < sizei; ++ii) {
                    rowparams.addRowErrors((RowErrors)errorData.get(ii));
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            }
            return outputData;
        }
        TEBPSData.getInstance().clear();
        InMsg input = null;
        OutMsg output = null;
        int len = tl1OperList.size();
        for (int i = 0; i < len; ++i) {
            tl1Operation = (TL1Operation)tl1OperList.get(i);
            input = tl1Operation.getInMsg();
            int size = tl1Operation.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                RowErrors[] rowErrors;
                rowparams = new RowParams();
                output = tl1Operation.getOutMsg(row);
                if (!this.handleRowData(neid, subfunc, rowparams, input, output)) continue;
                if (null != errorData && 0 != errorData.size()) {
                    rowparams = new RowParams();
                    int sizei = errorData.size();
                    for (int ii = 0; ii < sizei; ++ii) {
                        rowparams.addRowErrors((RowErrors)errorData.get(ii));
                    }
                }
                if ((rowErrors = rowparams.getRowErrors()).length == 0) {
                    String wSlotID = rowparams.getParam("wsslot").getValue();
                    String pSlotID = rowparams.getParam("psslot").getValue();
                    TEBPSData.getInstance().addSlotID(wSlotID, wSlotID);
                    TEBPSData.getInstance().addSlotID(pSlotID, pSlotID);
                }
                outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (null == errorData || 0 == errorData.size()) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (errorData.size() >= tl1OperSize) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return outputData;
    }

    protected boolean isFilterRowData(HashMap partmap) {
        Part pstype = (Part)partmap.get("PSTYPE");
        return !pstype.getValue().equals("1+1");
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        if (oldParam.getName().equals("wslotid")) {
            Part workPart = (Part)partmap.get("WORK");
            String workvar = this.getSoltID(workPart.getValue());
            String showSlot = TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)Integer.parseInt(workvar));
            oldParam.setValue(showSlot);
            return oldParam;
        }
        if (oldParam.getName().equals("wsslot")) {
            Part workPart = (Part)partmap.get("WORK");
            String workvar = this.getSoltID(workPart.getValue());
            oldParam.setValue(workvar);
            return oldParam;
        }
        if (oldParam.getName().equals("wboardname")) {
            Part workNamw = (Part)partmap.get("WORK");
            String worknamevar = this.getSoltID(workNamw.getValue());
            String wboardname = this.getBoardName(this.neid, worknamevar);
            oldParam.setValue(wboardname);
            return oldParam;
        }
        if (oldParam.getName().equals("pslotid")) {
            Part workPart = (Part)partmap.get("AID");
            String workvar = this.getSoltID(workPart.getValue());
            String showSlot = TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)Integer.parseInt(workvar));
            oldParam.setValue(showSlot);
            return oldParam;
        }
        if (oldParam.getName().equals("psslot")) {
            Part workPart = (Part)partmap.get("AID");
            String workvar = this.getSoltID(workPart.getValue());
            oldParam.setValue(workvar);
            return oldParam;
        }
        if (oldParam.getName().equals("pboardname")) {
            Part workName = (Part)partmap.get("AID");
            String worknamevar = this.getSoltID(workName.getValue());
            String wboardname = this.getBoardName(this.neid, worknamevar);
            oldParam.setValue(wboardname);
            return oldParam;
        }
        if (oldParam.getName().equals("currwboard")) {
            Part currboardpart = (Part)partmap.get("SWSTATE");
            int currboard = 0;
            currboard = currboardpart.getValue().equals("IDLE") ? 1 : 2;
            oldParam.setValue(String.valueOf(currboard));
            return oldParam;
        }
        if (oldParam.getName().equals("switchstate")) {
            Part swstate = (Part)partmap.get("SWSTATE");
            oldParam.setValue(swstate.getValue());
            return oldParam;
        }
        if (oldParam.getName().equals("excontrolunit")) {
            Part exconunit = (Part)partmap.get("CTRL");
            oldParam.setValue(exconunit.getValue());
            return oldParam;
        }
        if (oldParam.getName().equals("groupstate")) {
            Part pgstate = (Part)partmap.get("PGSTATE");
            oldParam.setValue(pgstate.getValue());
            return oldParam;
        }
        if (oldParam.getName().equals("aidslot")) {
            Part aidPart = (Part)partmap.get("AID");
            oldParam.setValue(aidPart.getValue());
            return oldParam;
        }
        oldParam = super.convertParamValue(oldParam, partmap);
        return oldParam;
    }

    private String getSoltID(String soltaid) {
        int slot = TETL1CommonUtil.getNMSlotStr((String)soltaid, (int)this.neid);
        return slot + "";
    }

    private String getBoardName(int neid, String slotID) {
        int boradType = TEConfigurationDataMgr.getInstance().getBoardType(neid, Integer.parseInt(slotID));
        return TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boradType);
    }
}

