/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.bps;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TEBPSOperSwitchBean
extends TETL1NEExplorerBean {
    private static final String FRCDTYPE = "FRCD";
    private static final int FORCEWORK = 0;
    private static final int FORCEPROTECT = 1;
    private static final int CLEARSWITCH = 16;

    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                String tl1Mod2 = TETL1CommonUtil.getTL1CmdMod2((String)subfunc.getQxMapping(i).getContent());
                tl1List.add(tl1Mod2);
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = tl1List.size();
            for (int i = 0; i < size; ++i) {
                tl1Operation = tl1Definitions.getTL1Operation((String)tl1List.get(i));
                int switchtype = Integer.parseInt(rowparams.getParam("switchtype").getValue());
                if (16 == switchtype && tl1Operation.getName().equals("OPR-PROTNSW-EQPT")) {
                    tl1Operation = null;
                } else if ((0 == switchtype || 1 == switchtype) && tl1Operation.getName().equals("RLS-PROTNSW-EQPT")) {
                    tl1Operation = null;
                }
                if (null == tl1Operation) continue;
                this.curTL1Operation = tl1Operation;
                inputMsg = tl1Operation.getInMsg();
                if (null == inputMsg) {
                    tl1OperList.add(tl1Operation);
                    continue;
                }
                tl1Operation.clearCmdFaultInfo();
                fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock());
                if (fillComplete) {
                    fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                }
                if (!this.msgBlockFlag && !fillComplete) continue;
                tl1OperList.add(tl1Operation);
            }
        }
        return tl1OperList;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        int switchtype = Integer.parseInt(rowparams.getParam("switchtype").getValue());
        if (part.getName().equalsIgnoreCase("AID")) {
            if (switchtype == 0) {
                String pslot = rowparams.getParam("pslot").getValue();
                String slelfandslot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(pslot));
                part.setValue("SLOT-" + slelfandslot);
                return true;
            }
            if (switchtype == 1) {
                String pslot = rowparams.getParam("wslot").getValue();
                String slelfandslot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(pslot));
                part.setValue("SLOT-" + slelfandslot);
                return true;
            }
            if (switchtype == 16) {
                String pslot = rowparams.getParam("pslot").getValue();
                String slelfandslot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(pslot));
                part.setValue("SLOT-" + slelfandslot);
                return true;
            }
        } else if (part.getName().equalsIgnoreCase("SC")) {
            part.setValue(FRCDTYPE);
            return true;
        }
        boolean flag = super.convertPartValue(part, rowparams);
        return flag;
    }
}

