/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.config.board1p1protection;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.config.board1p1protection.Board1p1Data;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TEBoard1p1QueryBean
extends TETL1NEExplorerBean {
    private static String SCC_PROTECT = "scc-protect";
    private static String AUX_PROTECT = "aux-protect";
    private static String XCS_PROTECT = "xcs-protect";
    private static String STG_PROTECT = "stg-protect";
    private static final String OLDNEVERSION = "5.51.05.19";
    private static final int OLDNEVERSION_3800A = 70;
    private static final int OLDNEVERSION_6800A = 71;
    private boolean hasFail = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.tl1OperList = this.getTL1Operation(neid, subFunc, inputData, memeryData);
        if (null != this.tl1OperList && this.tl1OperList.size() > 0) {
            int result = this.sendMessage(neid, this.tl1OperList);
            if (result == 0 || result == 1) {
                this.outputData.setBussinessParams(new BussinessParams());
                this.handleMessage(neid, this.tl1OperList);
                this.cloneTL1OperationList.clear();
                this.cloneTL1OperationList.addAll(this.tl1OperList);
                if (!this.hasFail) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
            }
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        }
        return this.outputData;
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList operationList = TETL1CommonUtil.createQueryBoardOperList((int)neid, (String)"SLOT-ALL");
        return operationList;
    }

    private String getBackupInfo() {
        ArrayList<TL1Operation> queryDetailOperList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation tl1Operation = definitions.getTL1Operation("RTRV-BACKUP-INFO");
            queryDetailOperList.add(tl1Operation);
            int result = this.sendMessage(this.neid, queryDetailOperList);
            if (result == 0) {
                tl1Operation = (TL1Operation)queryDetailOperList.get(0);
                this.cloneTL1OperationList.add(tl1Operation);
                for (OutMsg out : tl1Operation.getOutMsg()) {
                    HashMap operMap = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
                    Part part = (Part)operMap.get("BACKUPINFO");
                    if (part == null) continue;
                    return part.getValue();
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getNECurrAsonStatus fail!", (Throwable)e);
            return null;
        }
        return null;
    }

    private List createProtectDataList(int neid, ArrayList tl1OperList) {
        ArrayList<Board1p1Data> boardList = new ArrayList<Board1p1Data>();
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        String neversion = ne.getShowNEVersion();
        boolean isnNewVersion = TEBoard1p1QueryBean.isNewNeVersion(ne.getNEType(), neversion);
        if (null != tl1OperList && tl1OperList.size() > 0) {
            TL1Operation operation = (TL1Operation)tl1OperList.get(0);
            int size = operation.getOutMsgCount();
            block0: for (int row = 0; row < size; ++row) {
                OutMsg output = operation.getOutMsg(row);
                if (output.getFault().getCompletionCode() != 0) {
                    this.handleErrorData(output);
                    continue;
                }
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
                int shelfID = this.getShelfIDFromOutputData(hm);
                String boardName = this.getBoardNameFromOutputData(hm);
                int slotID = this.getSlotIDFromOutputData(hm);
                if (boardName == null) continue;
                String protectBaordType = this.getProtectBoard(boardName);
                boolean isAct = this.isActPortectState(hm);
                boolean isBak = this.isBakPortectState(hm);
                if (!isAct && !isBak) continue;
                int size1 = operation.getOutMsgCount();
                for (int row1 = 0; row1 < size1; ++row1) {
                    String protectType;
                    OutMsg output1 = operation.getOutMsg(row1);
                    HashMap hm1 = TETL1CommonUtil.getOutMsgPart((OutMsg)output1);
                    int shelfID1 = this.getShelfIDFromOutputData(hm1);
                    String boardName1 = this.getBoardNameFromOutputData(hm1);
                    if (boardName1 == null) continue;
                    int slotID1 = this.getSlotIDFromOutputData(hm1);
                    String protectBoardType1 = this.getProtectBoard(boardName1);
                    if (!this.isShelfEqual(shelfID, slotID, shelfID1, slotID1) || !protectBaordType.equals(protectBoardType1)) continue;
                    boolean isBak1 = this.isBakPortectState(hm1);
                    Board1p1Data board1p1 = new Board1p1Data();
                    if (!isAct || !isBak1 || (protectType = this.getProtectType(boardName1)) == null) continue;
                    board1p1.setProtectType(protectType);
                    board1p1.setMainSlotID(slotID);
                    board1p1.setMainBoardName(boardName);
                    board1p1.setBackupSlotID(slotID1);
                    board1p1.setBackupBoardName(boardName1);
                    if (isnNewVersion && this.isMainShelf(neid, slotID) && board1p1.getProtectType().contains(SCC_PROTECT)) {
                        board1p1.setBackupInfo(this.getBackupInfo());
                    }
                    boardList.add(board1p1);
                    continue block0;
                }
            }
        }
        return boardList;
    }

    private boolean isShelfEqual(int shelfID, int slotID, int shelfID1, int slotID1) {
        if (shelfID == shelfID1) {
            int realSlotID = TEBoardUtil.getSlotIDFromSlot((int)-1, (int)slotID);
            int realSlotID1 = TEBoardUtil.getSlotIDFromSlot((int)-1, (int)slotID1);
            return (!this.isFrontSlot(realSlotID) || !this.isRearSlot(realSlotID1)) && (!this.isFrontSlot(realSlotID1) || !this.isRearSlot(realSlotID));
        }
        return false;
    }

    private boolean isFrontSlot(int realSlotID1) {
        return realSlotID1 == 72 || realSlotID1 == 73;
    }

    private boolean isRearSlot(int realSlotID) {
        return realSlotID == 83 || realSlotID == 84;
    }

    private int getSlotIDFromOutputData(HashMap hm) {
        int slotid = TETL1CommonUtil.getNMSlotStr((String)((Part)hm.get("slotID")).getValue(), (int)this.neid);
        return slotid;
    }

    private String getProtectType(String boardName1) {
        String flag = "";
        if (boardName1.indexOf("SCC") != -1 || boardName1.indexOf("16XCH") != -1 || boardName1.indexOf("16UXCM") != -1) {
            flag = SCC_PROTECT;
        } else if (boardName1.indexOf("AUX") != -1) {
            flag = AUX_PROTECT;
        } else if (boardName1.indexOf("K2XCT") != -1 || boardName1.indexOf("K2SXM") != -1 || boardName1.indexOf("K2UXCT") != -1 || boardName1.indexOf("K2USXH") != -1 || boardName1.indexOf("K2SXH") != -1 || boardName1.indexOf("XCS") != -1 || boardName1.indexOf("XCH") != -1 && boardName1.indexOf("52UXCM") == -1 || boardName1.indexOf("K4XCT") != -1 || boardName1.indexOf("K4SXM") != -1 || boardName1.indexOf("K4SXH") != -1) {
            flag = XCS_PROTECT;
        } else if (boardName1.indexOf("STG") != -1) {
            flag = STG_PROTECT;
        }
        return flag;
    }

    private String getProtectBoard(String boardName) {
        String flag = "";
        if (boardName.indexOf("SCC") != -1) {
            flag = "SCC";
        } else if (boardName.indexOf("XCS") != -1) {
            flag = "XCS";
        } else if (boardName.indexOf("XCH") != -1) {
            flag = "XCH";
        } else if (boardName.indexOf("AUX") != -1) {
            flag = "AUX";
        } else if (boardName.indexOf("XCT") != -1) {
            flag = "XCT";
        } else if (boardName.indexOf("SXM") != -1) {
            flag = "SXM";
        } else if (boardName.indexOf("STG") != -1) {
            flag = "STG";
        } else if (boardName.indexOf("SXH") != -1) {
            flag = "SXH";
        }
        return flag;
    }

    private boolean isBakPortectState(HashMap hm) {
        String sst = "";
        if ((Part)hm.get("SST") != null && ((Part)hm.get("SST")).getValue() != null) {
            sst = ((Part)hm.get("SST")).getValue();
        }
        if (sst != null) {
            return sst.indexOf("STBYH") != -1;
        }
        return false;
    }

    private boolean isActPortectState(HashMap hm) {
        String sst = "";
        if ((Part)hm.get("SST") != null && ((Part)hm.get("SST")).getValue() != null) {
            sst = ((Part)hm.get("SST")).getValue();
        }
        if (sst != null) {
            return sst.indexOf("ACT") != -1;
        }
        return false;
    }

    private String getBoardNameFromOutputData(HashMap hm) {
        String slotName = ((Part)hm.get("PROVTYPE")).getValue();
        if (slotName == null) {
            slotName = ((Part)hm.get("ACTTYPE")).getValue();
        }
        return slotName;
    }

    private int getShelfIDFromOutputData(HashMap hm) {
        String[] str = TETL1CommonUtil.parseAID((String)((Part)hm.get("slotID")).getValue(), (int)this.neid);
        return Integer.parseInt(str[1]);
    }

    public boolean isMainShelf(int neid, int slotid) {
        if (TETL1CommonUtil.hasShelfNE((int)neid)) {
            int shelfID = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)slotid);
            return shelfID == 1;
        }
        return true;
    }

    private void handleErrorData(OutMsg output) {
        String errorCode = output.getFault().getErrCode();
        String errorinfo = output.getFault().getErrDesc();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        RowErrors errorRowparams = new RowErrors();
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        errorRowparams.setErrorMessage(errorMessage);
        errorparam = new Param("nename", TEConfigurationDataMgr.getInstance().getNEName(this.neid));
        errorRowparams.addParam(errorparam);
        RowParams rowparams = new RowParams();
        rowparams.addRowErrors(errorRowparams);
        this.outputData.getBussinessParams().addRowParams(rowparams);
        this.hasFail = true;
    }

    private void createOutputData(List boardList) {
        Iterator it = boardList.iterator();
        while (it.hasNext()) {
            RowParams comRowParams = new RowParams();
            Param comParam = null;
            Board1p1Data temp = (Board1p1Data)it.next();
            if (temp.getMainBoardName() != null && temp.getBackupBoardName() != null) {
                comParam = new Param("mainSlotNo", String.valueOf(temp.getMainSlotID()));
                comRowParams.addParam(comParam);
                comParam = new Param("mainShowSlotNo", TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)temp.getMainSlotID()) + "-" + temp.getMainBoardName());
                comRowParams.addParam(comParam);
                comParam = new Param("backupSlotNo", String.valueOf(temp.getBackupSlotID()));
                comRowParams.addParam(comParam);
                comParam = new Param("backupShowSlotNo", TETL1CommonUtil.getShelfSlotName((int)this.neid, (int)temp.getBackupSlotID()) + "-" + temp.getBackupBoardName());
                comRowParams.addParam(comParam);
                String portectType = temp.getProtectType();
                if (portectType == null) {
                    portectType = "";
                }
                comParam = new Param("protectType", portectType);
                comRowParams.addParam(comParam);
                String backupInfo = temp.getBackupInfo();
                if (backupInfo == null) {
                    backupInfo = "-";
                }
                comParam = new Param("backupInfo", backupInfo);
                comRowParams.addParam(comParam);
            }
            this.outputData.getBussinessParams().addRowParams(comRowParams);
        }
    }

    private void handleMessage(int neid, ArrayList tl1OperList) {
        List protectDataList = this.createProtectDataList(neid, tl1OperList);
        this.createOutputData(protectDataList);
    }

    private static boolean isNewNeVersion(int neType, String version) {
        String[] ver = version.split("\\.");
        int criticalver = Integer.parseInt(ver[1]);
        if (neType == 70) {
            if (criticalver == 70) {
                return false;
            }
            return version.compareTo(OLDNEVERSION) > 0;
        }
        if (neType == 71) {
            if (criticalver == 71) {
                return false;
            }
            return version.compareTo(OLDNEVERSION) > 0;
        }
        if (neType == 73) {
            return version.compareTo(OLDNEVERSION) > 0;
        }
        if (neType == 75) {
            return version.compareTo(OLDNEVERSION) > 0;
        }
        return true;
    }
}

