/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.channel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TETL1AIDKey;
import com.huawei.nglct.nemgr.tl1ngwdm.channel.TEPathViewTreeOBJ;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TEState;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TETL1QueryChannelState {
    public static void queryExistLogicPortState(int neID, int slotID, List mod2List) {
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neID);
            ArrayList tl1OperList = new ArrayList();
            TETL1QueryChannelState.fillTL1OperationList(definitions, tl1OperList, mod2List, neID);
            if (tl1OperList == null || tl1OperList.size() == 0) {
                return;
            }
            int result = TETL1NECommMgr.getInstance().sendCommand((int)neID, tl1OperList, (int)30).retCode;
            if (result != 0) {
                TELogFactory.getNormalLogger().info("query logic port fail,the errorCode is " + result);
                return;
            }
            int m = tl1OperList.size();
            for (int k = 0; k < m; ++k) {
                TL1Operation tempTL1Operation = (TL1Operation)tl1OperList.get(k);
                String mod2 = tempTL1Operation.getMod1();
                int n = tempTL1Operation.getOutMsgCount();
                for (int l = 0; l < n; ++l) {
                    OutMsg output = tempTL1Operation.getOutMsg(l);
                    if (0 != output.getFault().getCompletionCode()) continue;
                    HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
                    Part PST = (Part)hm.get("PST");
                    Part SST = (Part)hm.get("SST");
                    if (PST == null && SST == null) continue;
                    Part AID2 = null;
                    AID2 = tempTL1Operation.getMod1().equals("EQPT") ? (Part)hm.get("slotID") : (Part)hm.get("AID");
                    if (AID2 == null) continue;
                    TEState state = new TEState();
                    state.setPST(PST.getValue());
                    state.setSST(SST.getValue());
                    TETL1AIDKey key = new TETL1AIDKey(neID, AID2.getValue(), mod2);
                    TEConfigurationDataMgr.getInstance().addPortState(key, state);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1QueryChannelState.queryExistLogicPortState() fail!", (Throwable)e);
        }
    }

    private static void fillTL1OperationList(TL1Definitions definitions, ArrayList tl1OperList, List mod2List, int neID) {
        int m = mod2List.size();
        for (int j = 0; j < m; ++j) {
            TEPathViewTreeOBJ mod2 = (TEPathViewTreeOBJ)mod2List.get(j);
            if (mod2.getMod2() == null || !mod2.getMod2().equalsIgnoreCase("OMS") && !mod2.getSetState()) continue;
            TETL1QueryChannelState.setTL1Operation(definitions, tl1OperList, mod2, neID);
        }
    }

    private static void setTL1Operation(TL1Definitions definitions, ArrayList tl1OperList, TEPathViewTreeOBJ mod2, int neID) {
        String mod2Name = mod2.getMod2();
        String aid = mod2.getAid();
        String[] aids = TETL1CommonUtil.parseAID((String)aid, (int)neID);
        int channel = Integer.parseInt(aids[4]);
        if (TETL1QueryChannelState.isNotQueryState(mod2.getSlotID(), channel, neID)) {
            return;
        }
        if (mod2Name.equals("UNEQ") || mod2Name.equals("")) {
            return;
        }
        TL1Operation queryOper = mod2Name.indexOf("SFP") != -1 ? definitions.getTL1Operation("RTRV-EQPT") : definitions.getTL1Operation("RTRV-FETH");
        if (mod2Name.indexOf("-") != -1 && mod2Name.indexOf("TCM") != -1 && channel == -1) {
            return;
        }
        if (mod2Name.equals("SFP")) {
            mod2Name = "EQPT";
        } else if (mod2Name.indexOf("-") != -1) {
            mod2Name = mod2Name.substring(0, mod2Name.indexOf("-"));
        }
        InMsg input = queryOper.getInMsg();
        input.getPart("AID").setValue(aid);
        queryOper.setCmdCode("RTRV");
        queryOper.setMod1(mod2Name);
        queryOper.setName("RTRV-" + mod2Name);
        tl1OperList.add(queryOper);
    }

    private static boolean isNotQueryState(int slotID, int pathID, int neID) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        return boardType == 2214 && pathID > 0;
    }
}

