/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.channel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TETL1AIDKey;
import com.huawei.nglct.tl1.TEBoardState;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TEState;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;

public class TERestoreMaintenanceBean
extends TETL1NEExplorerBean {
    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        Param param = rowparams.getParam("mod2");
        if (param != null) {
            tl1Operation.setMod1(param.getValue());
            tl1Operation.setName("RST-" + param.getValue());
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TL1Operation oOperMT = (TL1Operation)operationList.get(0);
        String mod1 = oOperMT.getMod1();
        OutMsg[] out = oOperMT.getOutMsg();
        boolean flagMT = false;
        if (out == null || out.length == 0) {
            flagMT = true;
        } else if (out[0].getFault().getCompletionCode() == 0) {
            flagMT = true;
        }
        InMsg inPutMsg = oOperMT.getInMsg();
        Part AID2 = inPutMsg.getPart("AID");
        if (flagMT) {
            this.queryState(neid, AID2.getValue(), mod1);
        }
        super.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
    }

    private void queryState(int neid, String AID2, String mod1) {
        int slotID;
        ArrayList<TL1Operation> operationListMT = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            TL1Operation queryOperMT = null;
            queryOperMT = mod1.equals("EQPT") ? definitions.getTL1Operation("RTRV-EQPT") : definitions.getTL1Operation("RTRV-FETH");
            InMsg input = queryOperMT.getInMsg();
            input.getPart("AID").setValue(AID2);
            queryOperMT.setCmdCode("RTRV");
            queryOperMT.setMod1(mod1);
            queryOperMT.setName("RTRV-" + mod1);
            operationListMT.add(queryOperMT);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, operationListMT, 20);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().info("query board fail,the errorCode is " + result.retCode);
            return;
        }
        OutMsg[] outMsgsMT = ((TL1Operation)operationListMT.get(0)).getOutMsg();
        TENE ne = TENEListUtils.getNEObj((int)neid);
        TEBoard board = ne.getBoard(slotID = TETL1CommonUtil.getNMSlotStr((String)AID2, (int)neid));
        if (board != null && outMsgsMT != null && outMsgsMT.length != 0) {
            int n = outMsgsMT.length;
            for (int i = 0; i < n; ++i) {
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsgsMT[i]);
                String tmpPST = ((Part)hm.get("PST")).getValue();
                String tmpSST = ((Part)hm.get("SST")).getValue();
                int state = TEBoardState.setStateInPSTANDSST((String)tmpPST, (String)tmpSST);
                TEState st = new TEState();
                st.setPST(tmpPST);
                st.setSST(tmpSST);
                TETL1AIDKey key = new TETL1AIDKey(neid, AID2, mod1);
                TEConfigurationDataMgr.getInstance().addPortState(key, st);
                if (!mod1.equals("EQPT")) continue;
                board.setState(state);
            }
        }
    }
}

