/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.channel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.tl1ngwdm.channel.TEDynamicPortData;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TEGetAddablePortBean
extends TETL1NEExplorerBean {
    private String slotId = "";
    private HashSet dynPortSet = new HashSet();
    private int boardtype = 0;
    private static final String CHANNEL_ATTR_SUPPORTECPORT = "DWDMCHANNEL_ATTR_SUPPORTECPORT";
    private static final String CHANNEL_ATTR_SUPPORTFETH = "DWDMCHANNEL_ATTR_SUPPORTFETH";
    private static final String CHANNEL_ATTR_SUPPORTGETH = "DWDMCHANNEL_ATTR_SUPPORTGETH";
    private static final String CHANNEL_ATTR_SUPPORTOCHPORT = "DWDMCHANNEL_ATTR_SUPPORTOCHPORT";
    private static final String CHANNEL_ATTR_SUPPORTOCPORT = "DWDMCHANNEL_ATTR_SUPPORTOCPORT";
    private static final String CHANNEL_ATTR_SUPPORTLINEOCHPORT = "DWDMCHANNEL_ATTR_SUPPORTLINEOCHPORT";
    private static final String CHANNEL_ATTR_SUPPORTLINEOCPORT = "DWDMCHANNEL_ATTR_SUPPORTLINEOCPORT";
    private static final String CHANNEL_ATTR_SUPPORTVOAPORT = "DWDMCHANNEL_ATTR_SUPPORTVOAPORT";
    private static final String CHANNEL_ATTR_SUPPORTOSCPORT = "DWDMCHANNEL_ATTR_SUPPORTOSCPORT";
    private static final String CHANNEL_ATTR_SUPPORTWDM4PORT = "DWDMCHANNEL_ATTR_SUPPORTWDM4PORT";
    private static final String CHANNEL_ATTR_SUPPORTWDM10PORT = "DWDMCHANNEL_ATTR_SUPPORTWDM10PORT";
    private static final String CHANNEL_ATTR_SUPPORTCFP410GPORT = "DWDMCHANNEL_ATTR_SUPPORTCFP410GPORT";
    private static final String CHANNEL_ATTR_SUPPORTCFP425GPORT = "DWDMCHANNEL_ATTR_SUPPORTCFP425GPORT";
    private static final String CHANNEL_ATTR_SUPPORTCFP1010GPORT = "DWDMCHANNEL_ATTR_SUPPORTCFP1010GPORT";
    private String workMode;
    private static final Set<Integer> needQueryWorkModeBoards = new HashSet<Integer>();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        RowParams rParams = inputData.getBussinessParams().getRowParams()[0];
        this.slotId = rParams.getParam("slotID").getValue();
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.parseInt(this.slotId));
        this.boardtype = board.getBoardType();
        String portID = rParams.getParam("portID").getValue();
        String queryType = rParams.getParam("querytype").getValue();
        if (queryType.equals("0")) {
            TEGenCfgModel genCfgMode = TEGenCfgDataMgr.getGenCfgMode((int)this.boardtype);
            ArrayList<String> typeList = new ArrayList<String>();
            if (genCfgMode == null) {
                typeList.add("OC");
                typeList.add("OCH");
            } else {
                TEGenCfgAttribute attEC = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTECPORT);
                TEGenCfgAttribute attOCH = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTOCHPORT);
                TEGenCfgAttribute attOC = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTOCPORT);
                TEGenCfgAttribute attLineOCH = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTLINEOCHPORT);
                TEGenCfgAttribute attLineOC = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTLINEOCPORT);
                TEGenCfgAttribute attVOA = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTVOAPORT);
                TEGenCfgAttribute attOSC = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTOSCPORT);
                TEGenCfgAttribute attWDM4 = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTWDM4PORT);
                TEGenCfgAttribute attWDM10 = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTWDM10PORT);
                TEGenCfgAttribute attCFP410G = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTCFP410GPORT);
                TEGenCfgAttribute attCFP425G = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTCFP425GPORT);
                TEGenCfgAttribute attCFP1010G = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTCFP1010GPORT);
                if (needQueryWorkModeBoards.contains(this.boardtype)) {
                    this.queryWorkMode();
                }
                if (this.boardtype == 60034 || this.boardtype == 1541) {
                    this.addTypeList(board, portID, typeList);
                } else if (this.boardtype == 2272 && (portID.equals("3") || portID.equals("4"))) {
                    this.addLEM18TypeList(board, portID, typeList);
                } else if (this.boardtype == 2415 && (portID.equals("9") || portID.equals("10"))) {
                    typeList.add("EVOA");
                } else {
                    boolean flag = false;
                    if (this.isInAtt(attOC, portID)) {
                        typeList.add("OC");
                        flag = true;
                    }
                    if (this.isInAtt(attOCH, portID)) {
                        typeList.add("OCH");
                        flag = true;
                    }
                    if (this.isInAtt(attLineOC, portID)) {
                        typeList.add("Line OC");
                        flag = true;
                    }
                    if (this.isInAtt(attLineOCH, portID)) {
                        typeList.add("Line OCH");
                        flag = true;
                    }
                    if (this.isInAtt(attEC, portID)) {
                        typeList.add("EC");
                    }
                    if (this.isInAtt(attVOA, portID)) {
                        typeList.add("VOA");
                        flag = true;
                    }
                    if (this.isInAtt(attOSC, portID)) {
                        typeList.add("OSC");
                        flag = true;
                    }
                    if (this.isInAtt(attWDM4, portID)) {
                        typeList.add("WDM4");
                        flag = true;
                    }
                    if (this.isInAtt(attWDM10, portID)) {
                        typeList.add("WDM10");
                        flag = true;
                    }
                    if (this.isInAtt(attCFP410G, portID)) {
                        typeList.add("CFP4*10G");
                        flag = true;
                    }
                    if (this.isInAtt(attCFP425G, portID)) {
                        typeList.add("CFP4*25G");
                        flag = true;
                    }
                    if (this.isInAtt(attCFP1010G, portID)) {
                        typeList.add("CFP10*10G");
                        flag = true;
                    }
                    if (!flag) {
                        typeList.add("OC");
                        typeList.add("OCH");
                    }
                }
            }
            int n = typeList.size();
            for (int i = 0; i < n; ++i) {
                String type = (String)typeList.get(i);
                RowParams rowParam = new RowParams();
                rowParam.addParam("portType", type);
                this.outputData.getBussinessParams().addRowParams(rowParam);
            }
            return this.outputData;
        }
        if (queryType.equals("2")) {
            HashSet<String> speedSet = new HashSet<String>();
            String mod2 = rParams.getParam("portType").getValue();
            String port = rParams.getParam("portID").getValue();
            String portType = mod2;
            portType = !mod2.equals("undefined") ? this.getPortType(mod2, port) : mod2;
            TEGenCfgModel genCfgMode = TEGenCfgDataMgr.getGenCfgMode((int)this.boardtype);
            TEGenCfgAttribute FETHAtt = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTFETH);
            TEGenCfgAttribute GETHAtt = genCfgMode.getAttrFromId(CHANNEL_ATTR_SUPPORTGETH);
            if (FETHAtt != null && this.isLevelAtt(FETHAtt, portID)) {
                speedSet.add("FETH");
            }
            if (GETHAtt != null && this.isLevelAtt(GETHAtt, portID)) {
                speedSet.add("GETH");
            }
            if (GETHAtt == null && FETHAtt == null) {
                speedSet.add("-");
            }
            if (speedSet != null) {
                ArrayList speedList = this.getSortArrayFromSet(speedSet);
                int size = speedList.size();
                for (int i = 0; i < size; ++i) {
                    RowParams rowParam = new RowParams();
                    rowParam.addParam("speedLevel", (String)speedList.get(i));
                    rowParam.addParam("mod2", portType);
                    this.outputData.getBussinessParams().addRowParams(rowParam);
                }
            }
            return this.outputData;
        }
        TEConfigurationDataMgr.getInstance().getSupportedDynPortList(neid, this.boardtype);
        HashMap portSignalTypeMap = new HashMap();
        HashMap portSpeedMap = new HashMap();
        String[] portList = rParams.getParam("canAddList").getValue().split(",");
        int size = portList.length;
        for (int i = 0; i < size; ++i) {
            String[] aids = TETL1CommonUtil.parseAID((String)portList[i], (int)neid);
            this.dynPortSet.add(aids[3]);
        }
        TEDynamicPortData.getInstance().setPortSignalTypeMap(portSignalTypeMap);
        TEDynamicPortData.getInstance().setPortSpeedMap(portSpeedMap);
        ArrayList dynPortList = this.getSortArrayFromSet(this.dynPortSet);
        int size2 = dynPortList.size();
        for (int i = 0; i < size2; ++i) {
            RowParams rowParam = new RowParams();
            rowParam.addParam("portID", String.valueOf((String)dynPortList.get(i)));
            this.outputData.getBussinessParams().addRowParams(rowParam);
        }
        return this.outputData;
    }

    private void addLEM18TypeList(TEBoard board, String portID, List typeList) {
        if (this.workMode.equalsIgnoreCase("OTNMODE") || this.workMode.equalsIgnoreCase("OTNEXMODE")) {
            typeList.add("Line OCH");
            typeList.add("Line OC");
        } else if (this.workMode.equalsIgnoreCase("ETHMODE")) {
            typeList.add("OCH");
            typeList.add("OC");
        }
    }

    private String getPortType(String mod2, String port) {
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation oper1 = definitions.getTL1Operation("RTRV-" + mod2);
            InMsg input = oper1.getInMsg();
            String shelfSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(this.slotId));
            input.getPart("AID").setValue("FAC-" + shelfSlot + "-" + port);
            operationList.add(oper1.clone());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
            return mod2;
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, operationList, 20);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().info("query board fail,the errorCode is " + result.retCode);
            return mod2;
        }
        OutMsg[] outMsgs = ((TL1Operation)operationList.get(0)).getOutMsg();
        int size = outMsgs.length;
        for (int i = 0; i < size; ++i) {
            if (0 != outMsgs[i].getFault().getCompletionCode()) {
                return mod2;
            }
            HashMap dataBlock = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsgs[i]);
            Part mod2Part = (Part)dataBlock.get("TYPE");
            if (mod2Part == null || mod2Part.getValue() != null && !mod2Part.getValue().equals("LINE") || mod2.equals("EC")) continue;
            return "Line " + mod2;
        }
        return mod2;
    }

    private void queryWorkMode() {
        ArrayList<Object> operationList = new ArrayList<Object>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation oper1 = definitions.getTL1Operation("RTRV-EQPT");
            InMsg input = oper1.getInMsg();
            String shelfSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(this.slotId));
            input.getPart("AID").setValue("SLOT-" + shelfSlot);
            operationList.add(oper1.clone());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, operationList, 20);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().info("query board fail,the errorCode is " + result.retCode);
            return;
        }
        OutMsg[] outMsgs = ((TL1Operation)operationList.get(0)).getOutMsg();
        int size = outMsgs.length;
        for (int i = 0; i < size; ++i) {
            if (0 != outMsgs[i].getFault().getCompletionCode()) {
                return;
            }
            HashMap dataBlock = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsgs[i]);
            Part workModePart = (Part)dataBlock.get("WORKMODE");
            if (workModePart == null) continue;
            this.workMode = workModePart.getValue();
        }
    }

    private void addTypeList(TEBoard board, String portID, List typeList) {
        typeList.add("OCH");
        typeList.add("OC");
        if (this.workMode.equals("CASCADING")) {
            if (Integer.parseInt(portID) == 9 || Integer.parseInt(portID) == 10) {
                typeList.add("Line OCH");
            }
        } else if (this.workMode.equals("NON-CASCADING")) {
            typeList.add("Line OCH");
        }
    }

    private boolean isLevelAtt(TEGenCfgAttribute att, String portID) {
        boolean flag = false;
        ArrayList portList = att.getPortList();
        if (portList != null) {
            int n = portList.size();
            for (int i = 0; i < n; ++i) {
                TEGenCfgPortAttribute portAtt = (TEGenCfgPortAttribute)portList.get(i);
                if (portAtt.getPort() != Integer.parseInt(portID)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private boolean isInAtt(TEGenCfgAttribute att, String portID) {
        boolean flag = false;
        if (att == null) {
            return false;
        }
        if (this.boardtype == 1541 && (this.workMode.equalsIgnoreCase("REG") || this.workMode.equalsIgnoreCase("OREG")) && att.getAttrId().equalsIgnoreCase(CHANNEL_ATTR_SUPPORTLINEOCPORT)) {
            return false;
        }
        ArrayList portList = att.getPortList();
        if (portList != null) {
            List tl1boardModeList = null;
            int n = portList.size();
            for (int i = 0; i < n; ++i) {
                TEGenCfgPortAttribute portAtt = (TEGenCfgPortAttribute)portList.get(i);
                tl1boardModeList = portAtt.getTl1BoardModeList();
                if (tl1boardModeList != null && !tl1boardModeList.isEmpty()) {
                    if (portAtt.getPort() != Integer.parseInt(portID) || !tl1boardModeList.contains(this.workMode)) continue;
                    flag = true;
                    break;
                }
                if (portAtt.getPort() != Integer.parseInt(portID)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    private ArrayList getSortArrayFromSet(HashSet set) {
        ArrayList returnList = new ArrayList(set.size());
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            returnList.add(iter.next());
        }
        Collections.sort(returnList, new PortSortComparaotr());
        return returnList;
    }

    static {
        needQueryWorkModeBoards.add(60034);
        needQueryWorkModeBoards.add(1541);
        needQueryWorkModeBoards.add(2272);
        needQueryWorkModeBoards.add(1309);
        needQueryWorkModeBoards.add(2445);
        needQueryWorkModeBoards.add(2447);
        needQueryWorkModeBoards.add(2415);
    }

    class PortSortComparaotr
    implements Comparator {
        PortSortComparaotr() {
        }

        public int compare(Object o1, Object o2) {
            try {
                int port1 = Integer.parseInt((String)o1);
                int port2 = Integer.parseInt((String)o2);
                return port1 - port2;
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

