/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.channel;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TEDynamicLogicPortAddBean
extends TETL1NEExplorerBean {
    private String workMode;

    public TEDynamicLogicPortAddBean() {
        this.msgBlockFlag = false;
    }

    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                String tl1Mod2 = TETL1CommonUtil.getTL1CmdMod2((String)subfunc.getQxMapping(i).getContent());
                tl1List.add(tl1Mod2);
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = tl1List.size();
            for (int i = 0; i < size; ++i) {
                tl1Operation = tl1Definitions.getTL1Operation((String)tl1List.get(i));
                if (!this.changesSubMod2(tl1Operation, rowparams)) continue;
                this.curTL1Operation = tl1Operation;
                if (null == tl1Operation) continue;
                inputMsg = tl1Operation.getInMsg();
                if (null == inputMsg) {
                    tl1OperList.add(tl1Operation);
                    continue;
                }
                tl1Operation.clearCmdFaultInfo();
                fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock());
                if (fillComplete) {
                    fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                }
                if (!this.msgBlockFlag && !fillComplete) continue;
                tl1OperList.add(tl1Operation);
            }
        }
        return tl1OperList;
    }

    protected boolean changesSubMod2(TL1Operation tl1Operation, RowParams rowparams) {
        String mod2 = rowparams.getParam("cmdmode2").getValue();
        boolean isSecond = rowparams.getParam("Flag").getValue().equals("2");
        if (isSecond && tl1Operation.getMod1().equals("EQPT")) {
            return false;
        }
        String neid = rowparams.getParam("neID").getValue();
        String slotid = rowparams.getParam("slotId").getValue();
        TEConfigurationDataMgr confData = TEConfigurationDataMgr.getInstance();
        int boardType = confData.getBoardType(Integer.parseInt(neid), Integer.parseInt(slotid));
        if (tl1Operation.getName().equals("ED-DYNPORT") && mod2 != null) {
            if (this.neType == 66 && mod2.equals("Line OCH")) {
                return true;
            }
            if (mod2.equals("Line OCH")) {
                this.workMode = "LINE";
                mod2 = "OCH";
            } else if (mod2.equals("Line OC")) {
                if (this.isSupFilterTypeVersion()) {
                    this.workMode = "LINE";
                }
                mod2 = "OC";
            } else if ((mod2.equalsIgnoreCase("OC") || mod2.equalsIgnoreCase("OCH")) && this.isSupFilterTypeVersion()) {
                this.workMode = "CLIENT";
            }
            if (boardType == 2272) {
                mod2 = "CLIENT";
            }
            if (isSecond) {
                this.workMode = null;
            }
            tl1Operation.setMod1(mod2);
            tl1Operation.setName("ED-" + mod2);
        }
        return true;
    }

    private boolean isSupFilterTypeVersion() {
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)this.neid);
        String version = ne.getHostVersion();
        String[] ver = version.split("\\.");
        if (this.neType == 66) {
            return false;
        }
        if (this.neType == 70 ? ver[1].equals("70") : (this.neType == 71 || this.neType == 73 || this.neType == 75) && ver[1].equals("71")) {
            return false;
        }
        return version.compareTo("5.51.06.10") >= 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean convertPartValue(Part part, RowParams rowparams) {
        String shelfSlotID;
        StringBuffer sb;
        boolean flag = false;
        Param slotIDParam = null;
        Param portIDaram = null;
        if (part.getName().equalsIgnoreCase("AID")) {
            sb = new StringBuffer();
            sb.append("SLOT-");
            slotIDParam = rowparams.getParam("slotid");
            portIDaram = rowparams.getParam("portId");
            if (slotIDParam == null) return false;
            if (portIDaram == null) {
                return false;
            }
            shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotIDParam.getValue()));
            sb.append(shelfSlotID);
            sb.append("-").append(portIDaram.getValue());
            part.setValue(sb.toString());
            flag = true;
        }
        if (part.getName().equalsIgnoreCase("OCAID")) {
            sb = new StringBuffer();
            sb.append("FAC-");
            slotIDParam = rowparams.getParam("slotid");
            portIDaram = rowparams.getParam("portId");
            if (slotIDParam == null) return false;
            if (portIDaram == null) {
                return false;
            }
            shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(slotIDParam.getValue()));
            sb.append(shelfSlotID);
            sb.append("-").append(portIDaram.getValue());
            part.setValue(sb.toString());
            return true;
        }
        if (part.getName().equalsIgnoreCase("TYPE")) {
            if (this.workMode == null) return false;
            if (this.workMode.equals("")) return false;
            part.setValue(this.workMode);
            return true;
        }
        if (part.getName().equalsIgnoreCase("PROVTYPE")) {
            Param portTypeParam = rowparams.getParam("portType");
            if (portTypeParam == null) return false;
            if (portTypeParam.getValue() == null) {
                return false;
            }
            if (portTypeParam.getValue().equals("Line OCH")) {
                part.setValue("OCH");
                return true;
            } else if (portTypeParam.getValue().equals("Line OC")) {
                part.setValue("OC");
                return true;
            } else {
                part.setValue(portTypeParam.getValue());
            }
            return true;
        }
        if (!part.getName().equalsIgnoreCase("PLDTYPE")) return flag;
        Param pldTypeParam = rowparams.getParam("speedLevel");
        if (pldTypeParam == null) return false;
        if (pldTypeParam.getValue() == null) return false;
        if (pldTypeParam.getValue().equals("-")) {
            return false;
        }
        part.setValue(pldTypeParam.getValue());
        return true;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TL1Operation portOperation = (TL1Operation)tl1OperList.get(0);
        int code = portOperation.getOutMsgCount() == 0 ? 0 : portOperation.getOutMsg(0).getFault().getCompletionCode();
        if (code == 0) {
            String aid = portOperation.getInMsg().getStagBlock().getAID().getPart(0).getValue();
            String[] aids = TETL1CommonUtil.parseAID((String)aid, (int)neid);
            int slotid = TETL1CommonUtil.getNMSlotStr((String)aid, (int)neid);
            int portid = Integer.parseInt(aids[3]);
            TEConfigurationDataMgr.getInstance().addLogicPort(neid, slotid, portid);
        }
        super.handleMessage(neid, tl1OperList, subfunc, filterErrorCodeList);
    }
}

