/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.channel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TETL1AIDKey;
import com.huawei.nglct.tl1.TEBoardState;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TEState;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TEChannelSetStateBean
extends TETL1NEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            int result;
            this.neid = neid;
            this.curUser = user;
            this.curIpAddress = ipAddress;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            if (this.bQueryAidAndType) {
                this.slotIDList = this.getSlotIDFromInputDdata(inputData);
                if (this.slotIDList.size() > 0) {
                    this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                    if (this.aidAndTypeList == null) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                        return this.outputData;
                    }
                    if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                        return this.outputData;
                    }
                }
            }
            this.tl1OperList = this.getTL1Operation(neid, subFunc, inputData, memeryData);
            if (null == this.tl1OperList || this.tl1OperList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            TL1Operation tl1Operation = (TL1Operation)this.tl1OperList.get(0);
            Part sstPart = tl1Operation.getInMsg().getPart("SST");
            if (sstPart.getValue() == null) {
                tl1Operation.getInMsg().getMsgBlock().getDataBlock(2).removePart(sstPart);
            }
            if ((result = this.sendMessage(neid, this.tl1OperList)) == 0) {
                this.handleMessage(neid, this.tl1OperList, subFunc, this.getFilterErrorCodeList());
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            this.printLog();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        String mod2 = rowparams.getParam("mod2").getValue();
        if (mod2.equals("SFP")) {
            mod2 = "EQPT";
        }
        tl1Operation.setMod1(mod2);
        tl1Operation.setName("ED");
        tl1Operation.setName("ED-" + mod2);
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        Param aidParam;
        boolean flag = true;
        if (part.getName().equalsIgnoreCase("AID")) {
            aidParam = rowparams.getParam("AID");
            if (aidParam == null) {
                return false;
            }
            part.setValue(aidParam.getValue());
        }
        if (part.getName().equalsIgnoreCase("PST")) {
            Param pstParam = rowparams.getParam("PST");
            if (pstParam == null) {
                return false;
            }
            part.setValue(pstParam.getValue());
        }
        if (part.getName().equalsIgnoreCase("SST")) {
            aidParam = rowparams.getParam("SST");
            if (aidParam == null) {
                return false;
            }
            part.setValue(aidParam.getValue());
        } else {
            super.convertPartValue(part, rowparams);
        }
        return flag;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TL1Operation oOper1 = (TL1Operation)operationList.get(0);
        String mod1 = oOper1.getMod1();
        OutMsg[] out1 = oOper1.getOutMsg();
        boolean flag = false;
        if (out1 == null || out1.length == 0) {
            flag = true;
        } else if (out1[0].getFault().getCompletionCode() == 0) {
            flag = true;
        }
        InMsg inPut = oOper1.getInMsg();
        Part AID2 = inPut.getPart("AID");
        if (flag) {
            this.queryState(neid, AID2.getValue(), mod1);
        }
        super.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
    }

    private void queryState(int neid, String AID2, String mod1) {
        int slotID;
        ArrayList<TL1Operation> operationList1 = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions1 = TECreateObjectFactory.parseTL1DesFile((int)neid);
            TL1Operation queryOper = null;
            queryOper = mod1.equals("EQPT") ? definitions1.getTL1Operation("RTRV-EQPT") : definitions1.getTL1Operation("RTRV-FETH");
            InMsg input = queryOper.getInMsg();
            input.getPart("AID").setValue(AID2);
            queryOper.setCmdCode("RTRV");
            queryOper.setMod1(mod1);
            queryOper.setName("RTRV-" + mod1);
            operationList1.add(queryOper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse file fail", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, operationList1, 20);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().info("query board fail,the errorCode is " + result.retCode);
            return;
        }
        OutMsg[] outMsgs1 = ((TL1Operation)operationList1.get(0)).getOutMsg();
        TENE ne = TENEListUtils.getNEObj((int)neid);
        TEBoard board = ne.getBoard(slotID = TETL1CommonUtil.getNMSlotStr((String)AID2, (int)neid));
        if (board != null && outMsgs1 != null && outMsgs1.length != 0) {
            int n = outMsgs1.length;
            for (int i = 0; i < n; ++i) {
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outMsgs1[i]);
                String PST = ((Part)hm.get("PST")).getValue();
                String SST = ((Part)hm.get("SST")).getValue();
                int state = TEBoardState.setStateInPSTANDSST((String)PST, (String)SST);
                TEState st = new TEState();
                st.setPST(PST);
                st.setSST(SST);
                TETL1AIDKey key = new TETL1AIDKey(neid, AID2, mod1);
                TEConfigurationDataMgr.getInstance().addPortState(key, st);
                if (!mod1.equals("EQPT") || this.isSFP(neid, AID2)) continue;
                board.setState(state);
            }
        }
    }

    private boolean isSFP(int neid, String aid) {
        String[] slotAid = aid.split("-");
        int len = slotAid.length;
        if (TETL1CommonUtil.hasShelfNE((int)neid)) {
            return len == 4;
        }
        return len == 3;
    }
}

