/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.board;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nemgr.tl1ngwdm.board.TEAddBoardAction;
import com.huawei.nglct.tl1.TEBoardState;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TETL1QueryLogicPort;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Vector;

public class TETL1AddSubBoardAction
extends TEAddBoardAction {
    @Override
    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param tempParam = null;
        if (part.getName().equalsIgnoreCase("AID")) {
            tempParam = rowparams.getParam("slotID");
            if (tempParam == null) {
                return false;
            }
            int slotID = Integer.parseInt(tempParam.getValue());
            String nmslot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotID);
            int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID);
            int port = 0;
            port = bdtype == 2428 ? 2 : 5;
            String aid = "SLOT-" + nmslot + "-" + port;
            part.setValue(aid);
        } else if (part.getName().equalsIgnoreCase("PROVTYPE")) {
            tempParam = rowparams.getParam("subcardname");
            if (tempParam == null) {
                return false;
            }
            String boardName = tempParam.getValue();
            TENE ne = TENEListUtils.getNEObj((int)this.neid);
            boardName = this.getBoardName(tempParam, boardName, ne);
            part.setValue(boardName);
        } else if (part.getName().equalsIgnoreCase("PST")) {
            part.setValue("OOS");
        } else {
            super.convertPartValue(part, rowparams);
        }
        return flag;
    }

    @Override
    protected void addBoard(ArrayList tl1OperList) {
        try {
            TENE ne = TENEListUtils.getNEObj((int)this.neid);
            Vector boardList = ne.getBoardList();
            TL1Operation operation = (TL1Operation)tl1OperList.get(0);
            Part part = operation.getInMsg().getPart("AID");
            this.slotid = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)this.neid);
            TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
            TEBoard board = neObj.getBoard(this.slotid);
            int subslotid = Integer.parseInt(operation.getInMsg().getPart("subcardid").getValue());
            int subtype = Integer.parseInt(operation.getInMsg().getPart("subcardtype").getValue());
            if (board != null) {
                TESubBoard subboard = null;
                if (!board.getSubBoardList().isEmpty()) {
                    int len = board.getSubBoardList().size();
                    for (int i = 0; i < len; ++i) {
                        subboard = (TESubBoard)board.getSubBoardList().get(i);
                        if (subboard.getSubSlotID() != subslotid) continue;
                        board.getSubBoardList().remove(i);
                        break;
                    }
                }
                subboard = new TESubBoard(board, this.neid, subslotid, subtype);
                board.getSubBoardList().add(subboard);
                board.setState(TEBoardState.setStateInPSTANDSST((String)"IS", (String)""));
                boardList.add(board);
                if (TEConfigurationDataMgr.getInstance().isDynPortBoardType(this.neid, board.getBoardType())) {
                    TETL1QueryLogicPort.queryExistLogicPort((int)this.neid, (int)board.getSlotID(), (int)board.getBoardType());
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Add memery Board Fault!", (Throwable)e);
            return;
        }
    }
}

