/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.board;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEServiceConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1ngwdm.channel.TEChannelStaticeData;
import com.huawei.nglct.nemgr.tl1ngwdm.channel.TEChannelThreadMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Timer;
import java.util.Vector;

public class TEDelBoardAction
extends TETL1NEExplorerBean {
    private static final String SLOT_ID_PARAM = "AID";
    private static final int BOARD_NO_EXIST_ERROR = 38666;
    private int slotid;

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TL1Operation delBoardOperation = (TL1Operation)tl1OperList.get(0);
        Part part = delBoardOperation.getInMsg().getPart(SLOT_ID_PARAM);
        this.slotid = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)neid);
        ArrayList tl1OperListClone = (ArrayList)tl1OperList.clone();
        this.outputData = super.convertToDatainterface(neid, subfunc, tl1OperList, null);
        if (this.outputData.getErrorMessage().getErrorcode().equals(String.valueOf(0))) {
            this.removeBoard(tl1OperListClone);
            TEChannelStaticeData.getInstance().delTempTEAIDAndTypeList(neid, this.slotid);
            this.removeQueryChannelStateTimerTask(neid, this.slotid);
            TEConfigurationDataMgr.getInstance().deletePortState(neid, this.slotid);
            TEServiceConfigurationDataMgr.getInstance().removeTL1AIDTypeList(neid, this.slotid);
        } else {
            RowParams rowparams = null;
            if (null != this.outputData.getBussinessParams() && this.outputData.getBussinessParams().getRowParamsCount() > 0 && (rowparams = this.outputData.getBussinessParams().getRowParams(0)).getRowErrorsCount() > 0 && rowparams.getRowErrors(0).getErrorMessage().getErrorcode().equals(String.valueOf(38666))) {
                this.removeBoard(tl1OperListClone);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
        }
    }

    private void removeQueryChannelStateTimerTask(int neid, int slotid) {
        TEChannelThreadMgr instance = TEChannelThreadMgr.getInstance();
        Timer task = instance.getTaskInstanceByNeId(neid, slotid);
        if (task != null) {
            task.cancel();
            instance.removeInstanceByNeId(neid, slotid);
        }
    }

    protected void removeBoard(ArrayList tl1OperList) {
        try {
            TENE neObj = TENEListUtils.getNEObj((int)this.neid);
            Vector boardList = neObj.getClonedBoardList();
            TL1Operation operation = null;
            TEBoard board = null;
            int boradType = -1;
            int size = tl1OperList.size();
            for (int i = 0; i < size; ++i) {
                operation = (TL1Operation)tl1OperList.get(i);
                Part part = operation.getInMsg().getPart(SLOT_ID_PARAM);
                this.slotid = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)this.neid);
                board = neObj.getBoard(this.slotid);
                TEBoard phyBoard = neObj.getPhyBoard(this.slotid);
                if (null == board) continue;
                boradType = board.getBoardType();
                boardList.remove(board);
                if (phyBoard == null || board.getBoardType() != phyBoard.getBoardType() || board.getState() != 16) continue;
                neObj.getPhyBoardList().remove(board);
            }
            neObj.removeAlarm(this.slotid, 0);
            neObj.removeLogicPortBySlot(this.neid, this.slotid, boradType);
            neObj.setLastBoardModifyTime();
            neObj.setBoardList(boardList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Delete memery Board Fault!", (Throwable)e);
            return;
        }
    }
}

