/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm.board;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TEBoardNameConvertUtil;
import com.huawei.nglct.tl1.TEBoardState;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1QueryLogicPort;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;

public class TEAddBoardAction
extends TETL1NEExplorerBean {
    private static final int BOARD_EXIST_ERROR = 38665;
    public int slotid;
    private int boardType = -1;

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param tempParam = null;
        if (part.getName().equalsIgnoreCase("PROVTYPE")) {
            tempParam = rowparams.getParam("TYPE");
            if (tempParam == null) {
                return false;
            }
            String boardName = tempParam.getValue();
            TENE ne = TENEListUtils.getNEObj((int)this.neid);
            boardName = this.getBoardName(tempParam, boardName, ne);
            this.boardType = Integer.parseInt(rowparams.getParam("BDTYPE").getValue());
            part.setValue(boardName);
        } else {
            super.convertPartValue(part, rowparams);
        }
        return flag;
    }

    protected String getBoardName(Param tempParam, String boardName, TENE ne) {
        TEBoardNameConvertUtil boardNameConvertUtil = TEBoardNameConvertUtil.getInstance();
        boardNameConvertUtil.setNeType(ne.getNEType());
        boardNameConvertUtil.setHostVersion(ne.getHostVersion());
        if (ne.getNEType() == 66) {
            boardName = tempParam.getValue();
        } else if ((boardName = boardNameConvertUtil.nameToDev(boardName)).equals("")) {
            boardName = tempParam.getValue();
        }
        return boardName;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        ArrayList tempList = (ArrayList)tl1OperList.clone();
        TL1Operation tl1Oper = (TL1Operation)tl1OperList.get(0);
        this.outputData = super.convertToDatainterface(neid, subfunc, tl1OperList, filterErrorCodeList);
        if (this.outputData.getErrorMessage().getErrorcode().equals(String.valueOf(0))) {
            this.addBoard(tempList);
        } else {
            String boardName = tl1Oper.getInMsg().getMsgBlock().getPart("PROVTYPE").getValue();
            String aid = tl1Oper.getInMsg().getStagBlock().getAID().getPart(0).getValue();
            int slotID = TETL1CommonUtil.getNMSlotStr((String)aid, (int)neid);
            TEBoardNameConvertUtil boardNameConvertUtil = TEBoardNameConvertUtil.getInstance();
            TENE ne = TENEListUtils.getNEObj((int)neid);
            boardNameConvertUtil.setNeType(ne.getNEType());
            boardNameConvertUtil.setHostVersion(ne.getHostVersion());
            boardName = boardNameConvertUtil.nameToNM(boardName);
            RowParams[] rowParams = this.outputData.getBussinessParams().getRowParams();
            RowErrors[] rowErrors = rowParams[0].getRowErrors();
            RowErrors rowError = rowErrors[0];
            Param param = rowError.getParam("PROVTYPE");
            String errorBoardName = param.getValue().replaceAll("UNKNOWN", boardName);
            param.setValue(errorBoardName);
            String showSlot = TETL1CommonUtil.getShelfSlotName((int)neid, (int)slotID);
            rowError.addParam(new Param("slotID", showSlot));
            rowError.addParam(new Param("boardname", errorBoardName));
        }
        RowParams rowparams = null;
        if (null != this.outputData.getBussinessParams() && this.outputData.getBussinessParams().getRowParamsCount() > 0 && (rowparams = this.outputData.getBussinessParams().getRowParams(0)).getRowErrorsCount() > 0 && rowparams.getRowErrors(0).getErrorMessage().getErrorcode().equals(String.valueOf(38665))) {
            TETL1NE subNEObj = (TETL1NE)TENEListUtils.getNEObj((int)neid);
            subNEObj.queryBoard();
        }
    }

    protected void addBoard(ArrayList tl1OperList) {
        try {
            TENE ne = TENEListUtils.getNEObj((int)this.neid);
            Vector boardList = ne.getBoardList();
            TL1Operation operation = (TL1Operation)tl1OperList.get(0);
            Part part = operation.getInMsg().getPart("AID");
            this.slotid = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)this.neid);
            String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, this.boardType);
            TEBoard board = new TEBoard(this.neid, this.slotid, this.boardType, boardName);
            board.setState(TEBoardState.setStateInPSTANDSST((String)"IS", (String)""));
            boardList.add(board);
            if (TEConfigurationDataMgr.getInstance().isDynPortBoardType(this.neid, board.getBoardType())) {
                TETL1QueryLogicPort.queryExistLogicPort((int)this.neid, (int)board.getSlotID(), (int)board.getBoardType());
            }
            if (this.boardType == 1573) {
                HashSet<Integer> slotIDSet = new HashSet<Integer>();
                slotIDSet.add(this.slotid);
                TEAIDAndTypeList typeListAID = TETL1CommonUtil.queryPortType((int)this.neid, slotIDSet);
                TEConfigurationDataMgr.getInstance().addTL1PayloadTypeList(this.neid, this.slotid, typeListAID);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Add memery Board Fault!", (Throwable)e);
            return;
        }
    }

    public boolean isNeedOperationlog(String ipAddress) {
        try {
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(this.subfunc.getCode());
            int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
            loginfo.setResult(errorCode);
            if (errorCode == 2) {
                errorCode = Integer.parseInt(this.outputData.getBussinessParams().getRowParams(0).getRowErrors(0).getErrorMessage().getErrorcode());
            }
            loginfo.setErrCode(errorCode);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            loginfo.setLocation(ipAddress);
            String boardName = TENEListMgr.getInstance().getNE(this.neid).getBoard(this.slotid).getBoardName();
            String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)this.slotid);
            if (!"".equals(subrackName)) {
                subrackName = subrackName + "-";
            }
            loginfo.setOperateDesc(subrackName + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)this.slotid) + "-" + boardName);
            loginfo.setOperateName(this.subfunc.getDes());
            loginfo.setOperateObject(String.valueOf(this.neid));
            loginfo.setResult(Integer.parseInt(this.outputData.getErrorMessage().getErrorcode()));
            loginfo.setUserID(0);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            TELogMgr.writeLog((TELogInfo)loginfo);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Write Log Fail!", (Throwable)e);
            return false;
        }
        return false;
    }
}

