/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nemgr.tl1ngwdm.TETL1NE_TL1NGWDM;
import com.huawei.nglct.po.TESubrackTypes;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TENEImplInterface_TL1NE;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class TETL1NE_6800A
extends TETL1NE_TL1NGWDM {
    public void querySubrack() {
        ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
        try {
            TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
            String qxFilePath = neImpl.getTL1_DES_PATH();
            qxFilePath = qxFilePath == null ? TETL1CommonUtil.TL1_DES_PATH : qxFilePath;
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.tl1ngwdm", (String)qxFilePath);
            TL1Operation queryOper = definitions.getTL1Operation("RTRV-EQPT");
            InMsg input = queryOper.getInMsg();
            input.getPart("AID").setValue("SHELF-ALL");
            operList.add(queryOper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1NE_6800A.querySubrack() fail!", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operList, 20);
        if (result.retCode != 0) {
            this.setLoginCode(result.retCode);
            TELogFactory.getNormalLogger().error("Query subrack fail, the errorCode is" + result.retCode);
            return;
        }
        TL1Operation operation = (TL1Operation)operList.get(0);
        if (operation.getOutMsgCount() == 0) {
            return;
        }
        OutMsg outMsg = operation.getOutMsg(0);
        if (outMsg.getFault().getCompletionCode() != 0) {
            this.setLoginCode(outMsg.getFault().getCompletionCode());
            this.setErrorCode(outMsg.getFault().getErrCode());
            this.setErrorDes(outMsg.getFault().getErrDesc());
        } else {
            this.setLoginCode(0);
        }
        HashMap tempMap = new HashMap();
        int size = operList.size();
        for (int i = 0; i < size; ++i) {
            OutMsg[] outputArr = ((TL1Operation)operList.get(i)).getOutMsg();
            this.putRackToMap(tempMap, outputArr);
        }
        Vector tempVec = new Vector();
        Iterator iter = tempMap.values().iterator();
        while (iter.hasNext()) {
            tempVec.add(iter.next());
        }
        Collections.sort(tempVec);
        this.setSubrackList(tempVec);
    }

    protected void queryCurSubrack(String aid) {
        String[] aids = TETL1CommonUtil.parseAID((String)aid, (int)this.neID);
        if (!this.isExistSubrack(aids[1])) {
            this.delCurSubrack(aid);
        }
        TENE ne = TENEListUtils.getNEObj((int)this.neID);
        ne.queryBoard();
    }

    private TESubrack querySubrackData(String aid) {
        ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
        try {
            TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.tl1ngwdm", (String)neImpl.getTL1_DES_PATH());
            if (definitions == null) {
                TELogFactory.getNormalLogger().info("TETL1NE_6800A.parseTL1DesFile fail!");
                return null;
            }
            TL1Operation queryOper = definitions.getTL1Operation("RTRV-EQPT");
            InMsg input = queryOper.getInMsg();
            input.getPart("AID").setValue(aid);
            operList.add(queryOper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1NE_6800A.querySubrackData() fail!", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operList, 20);
        if (result.retCode != 0) {
            this.setLoginCode(result.retCode);
            TELogFactory.getNormalLogger().error("Query subrack fail, the errorCode is" + result.retCode);
            return null;
        }
        TL1Operation operation = (TL1Operation)operList.get(0);
        OutMsg outMsg = operation.getOutMsg(0);
        if (outMsg.getFault().getCompletionCode() != 0) {
            this.setLoginCode(outMsg.getFault().getCompletionCode());
            this.setErrorCode(outMsg.getFault().getErrCode());
            this.setErrorDes(outMsg.getFault().getErrDesc());
        } else {
            this.setLoginCode(0);
        }
        HashMap tempMap = new HashMap();
        int size = operList.size();
        for (int i = 0; i < size; ++i) {
            OutMsg[] outputArr = ((TL1Operation)operList.get(i)).getOutMsg();
            this.putRackToMap(tempMap, outputArr);
        }
        Iterator iter = tempMap.values().iterator();
        TESubrack tempSubrack = null;
        while (iter.hasNext()) {
            tempSubrack = (TESubrack)iter.next();
        }
        return tempSubrack;
    }

    protected void queryCurBoardsFromSubrack(String aid) {
        String[] aids = TETL1CommonUtil.parseAID((String)aid, (int)this.neID);
        ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
        try {
            TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.tl1ngwdm", (String)neImpl.getTL1_DES_PATH());
            TL1Operation queryOper = definitions.getTL1Operation("RTRV-EQPT");
            InMsg input = queryOper.getInMsg();
            input.getPart("AID").setValue("SLOT-" + aids[1] + "-ALL");
            operList.add(queryOper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1NE_6800A.queryCurBoardsFromSubrack() fail!", (Throwable)e);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operList, 20);
        if (result.retCode != 0) {
            this.setLoginCode(result.retCode);
            TELogFactory.getNormalLogger().error("Query board fail, the errorCode is" + result.retCode);
            return;
        }
        this.setBoardToMemory(operList);
    }

    protected void delCurSubrack(String aid) {
        String[] aids = TETL1CommonUtil.parseAID((String)aid, (int)this.neID);
        TENE ne = TENEListUtils.getNEObj((int)this.neID);
        Vector subrackList = ne.getClonedSubrackList();
        for (int i = subrackList.size() - 1; i >= 0; --i) {
            TESubrack sigleSubrack = (TESubrack)subrackList.get(i);
            if (!sigleSubrack.getSubrackID().equals(aids[1])) continue;
            subrackList.remove(i);
        }
        ne.setSubrackList(subrackList);
    }

    protected void modifyCurSubrack(String aid) {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        Vector subrackList = neImpl.getSubrackList();
        TESubrack subrack = this.querySubrackData(aid);
        if (subrack != null) {
            int n = subrackList.size();
            for (int i = 0; i < n; ++i) {
                TESubrack oldSubrack = (TESubrack)subrackList.get(i);
                if (!oldSubrack.getSubrackID().equals(subrack.getSubrackID())) continue;
                oldSubrack.setFicInfo(subrack.getFicInfo());
            }
        }
    }

    private void putRackToMap(Map tempMap, OutMsg[] outputArr) {
        for (int j = 0; j < outputArr.length; ++j) {
            OutMsg out = outputArr[j];
            if (!"".equals(out.getFault().getErrCode())) continue;
            HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
            Iterator it = partmap.entrySet().iterator();
            String subrackID = null;
            String logType = null;
            String phyType = null;
            String ficInfo = null;
            String subrackName = null;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                Part value = (Part)entry.getValue();
                if (name.equals("slotID")) {
                    String[] str = value.getValue().split("SHELF-");
                    if (2 != str.length) continue;
                    subrackID = str[1];
                    continue;
                }
                if (name.equals("PROVTYPE")) {
                    logType = TETL1CommonUtil.isNull((String)value.getValue());
                    continue;
                }
                if (name.equals("ACTTYPE")) {
                    phyType = TETL1CommonUtil.isNull((String)value.getValue());
                    continue;
                }
                if (name.equals("USERLBL")) {
                    ficInfo = TETL1CommonUtil.isNull((String)value.getValue());
                    continue;
                }
                if (!name.equals("SHELFLBL")) continue;
                subrackName = TETL1CommonUtil.isNull((String)value.getValue());
            }
            if (subrackID == null || logType == null) continue;
            TESubrack tempSubrack = new TESubrack(subrackID, logType, "");
            tempSubrack.setFicInfo(ficInfo);
            tempSubrack.setSubrackName(subrackName);
            if (phyType != null && phyType.equals(logType)) {
                tempSubrack.setSubrackState("1");
            }
            tempSubrack.setShelfType(this.getTL1DevType(logType));
            tempMap.put(subrackID, tempSubrack);
        }
    }

    private int getTL1DevType(String subrackType) {
        if (subrackType.equalsIgnoreCase("SHELF8800T16")) {
            return 1985;
        }
        if (subrackType.equalsIgnoreCase("SHELF6800A")) {
            return 136;
        }
        if (subrackType.equalsIgnoreCase("SHELF8800T32") || subrackType.equalsIgnoreCase("SHELF8800I")) {
            return 2043;
        }
        if (subrackType.equalsIgnoreCase("SHELF8800T64") || subrackType.equalsIgnoreCase("SHELF8800II")) {
            return 1975;
        }
        if (subrackType.equalsIgnoreCase("SHELF8800T32E")) {
            return 2044;
        }
        if (subrackType.equalsIgnoreCase("SHELF8800T64E")) {
            return 101;
        }
        return TESubrackTypes.getInstance().getTL1SubrackType(subrackType);
    }

    protected int getTL1DevType() {
        return 136;
    }
}

