/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1ngwdm;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nemgr.tl1ngwdm.TETL1NE_TL1NGWDM;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TENEImplInterface_TL1NE;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class TETL1NE_1800A
extends TETL1NE_TL1NGWDM {
    public void initNEData() {
        this.registerEvent();
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        neImpl.setTL1_DES_PATH(TEGetFilePath.getFilePath((int)neImpl.getNeType(), (String)neImpl.getHostVersion(), (String)("conf" + File.separator + "tl1describ.xml")));
        this.queryNEInfo();
        this.setTimeTask();
        this.startNESysTimeTask();
    }

    public void querySubrack() {
        TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
        if (neImpl.getHostVersion().compareTo("5.66.02.10") < 0) {
            this.queryNoSubrack();
        } else {
            this.queryHasSubrack();
        }
    }

    public void queryNoSubrack() {
        Vector<TESubrack> srList = new Vector<TESubrack>();
        TESubrack sr = new TESubrack("1", "", "");
        String subrackType = this.querySubrackType();
        sr.setSubrackState("1");
        sr.setLogicSubrackType(subrackType);
        sr.setShelfType(this.getSubrackType(subrackType));
        srList.add(sr);
        this.setSubrackList(srList);
    }

    public void queryHasSubrack() {
        ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions;
            TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
            if (neImpl.getTL1_DES_PATH() == null) {
                neImpl.setTL1_DES_PATH(TEGetFilePath.getFilePath((int)neImpl.getNeType(), (String)neImpl.getHostVersion(), (String)("conf" + File.separator + "tl1describ.xml")));
            }
            if ((definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.tl1ngwdm", (String)neImpl.getTL1_DES_PATH())) != null) {
                TL1Operation queryOper = definitions.getTL1Operation("RTRV-EQPT");
                InMsg input = queryOper.getInMsg();
                input.getPart("AID").setValue("SHELF-ALL");
                operList.add(queryOper);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1NE_1800A.queryHasSubrack() fail!", (Throwable)e);
        }
        if (operList.isEmpty()) {
            return;
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operList, 20);
        if (result.retCode != 0) {
            this.setLoginCode(result.retCode);
            TELogFactory.getNormalLogger().error("Query subrack fail, the errorCode is" + result.retCode);
            return;
        }
        TL1Operation operation = (TL1Operation)operList.get(0);
        OutMsg outMsg = operation.getOutMsg(0);
        if (outMsg.getFault().getCompletionCode() != 0) {
            this.setLoginCode(outMsg.getFault().getCompletionCode());
            this.setErrorCode(outMsg.getFault().getErrCode());
            this.setErrorDes(outMsg.getFault().getErrDesc());
        } else {
            this.setLoginCode(0);
        }
        HashMap tempMap = new HashMap();
        int size = operList.size();
        for (int i = 0; i < size; ++i) {
            OutMsg[] outputArr = ((TL1Operation)operList.get(i)).getOutMsg();
            this.putRackToMap(tempMap, outputArr);
        }
        Vector tempVec = new Vector();
        Iterator iter = tempMap.values().iterator();
        while (iter.hasNext()) {
            tempVec.add(iter.next());
        }
        Collections.sort(tempVec);
        this.setSubrackList(tempVec);
    }

    public String querySubrackType() {
        ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
        try {
            TENEImplInterface_TL1NE neImpl = (TENEImplInterface_TL1NE)this.getNeImplInterface();
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.tl1ngwdm", (String)neImpl.getTL1_DES_PATH());
            TL1Operation queryOper = definitions.getTL1Operation("RTRV-SYS");
            operList.add(queryOper);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neID, operList, 20);
            if (result.retCode != 0) {
                this.setLoginCode(result.retCode);
                TELogFactory.getNormalLogger().error("Query subrackType fail, the errorCode is" + result.retCode);
                return "";
            }
            TL1Operation operation = (TL1Operation)operList.get(0);
            OutMsg outMsg = operation.getOutMsg(0);
            if (outMsg.getFault().getCompletionCode() != 0) {
                this.setLoginCode(outMsg.getFault().getCompletionCode());
                this.setErrorCode(outMsg.getFault().getErrCode());
                this.setErrorDes(outMsg.getFault().getErrDesc());
            } else {
                this.setLoginCode(0);
            }
            int size = operList.size();
            for (int i = 0; i < size; ++i) {
                OutMsg[] outputArr = ((TL1Operation)operList.get(i)).getOutMsg();
                HashMap hm = TETL1CommonUtil.getOutMsgPart((OutMsg)outputArr[i]);
                Part part = (Part)hm.get("SHELFTYPE");
                if (part == null) continue;
                this.setShelfType(this.getSubrackType(part.getValue()));
                return part.getValue();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1NE_1800A.querySubrackType() fail!", (Throwable)e);
        }
        return null;
    }

    private void putRackToMap(Map tempMap, OutMsg[] outputArr) {
        for (int j = 0; j < outputArr.length; ++j) {
            OutMsg out = outputArr[j];
            if (!"".equals(out.getFault().getErrCode())) continue;
            HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)out);
            Iterator it = partmap.entrySet().iterator();
            String subrackID = null;
            String logType = null;
            String phyType = null;
            String ficInfo = null;
            String subrackName = null;
            String barCode = null;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                Part value = (Part)entry.getValue();
                if (name.equals("slotID")) {
                    String[] str = value.getValue().split("-");
                    subrackID = str[1];
                    continue;
                }
                if (name.equals("PROVTYPE")) {
                    logType = TETL1CommonUtil.isNull((String)value.getValue());
                    continue;
                }
                if (name.equals("ACTTYPE")) {
                    phyType = TETL1CommonUtil.isNull((String)value.getValue());
                    continue;
                }
                if (name.equals("USERLBL")) {
                    ficInfo = TETL1CommonUtil.isNull((String)value.getValue());
                    continue;
                }
                if (name.equals("SHELFLBL")) {
                    subrackName = TETL1CommonUtil.isNull((String)value.getValue());
                    continue;
                }
                if (!name.equals("BARCODE")) continue;
                barCode = TETL1CommonUtil.isNull((String)value.getValue());
            }
            if (subrackID == null || logType == null || logType.isEmpty()) continue;
            TESubrack tempSubrack = new TESubrack(subrackID, logType, "");
            this.querySubrackType();
            tempSubrack.setShelfType(this.getSubrackType(logType));
            tempSubrack.setFicInfo(ficInfo);
            tempSubrack.setSubrackName(subrackName);
            tempSubrack.setPhySubrackType(logType);
            if (phyType != null && phyType.equals(logType)) {
                tempSubrack.setSubrackState("1");
            }
            if (null != barCode && tempSubrack.getSubrackState().equals("1")) {
                tempSubrack.setBarCode(barCode);
            }
            tempMap.put(subrackID, tempSubrack);
        }
    }

    private int getSubrackType(String subrackType) {
        int value = -1;
        if (subrackType.equals("1U")) {
            value = 140;
        } else if (subrackType.equals("2U")) {
            value = 141;
        } else if (subrackType.equals("1U_AUTO_COOL")) {
            value = 142;
        }
        return value;
    }

    protected void queryCurSubrack(String aid) {
        String[] aids = TETL1CommonUtil.parseAID((String)aid, (int)this.neID);
        if (!this.isExistSubrack(aids[1])) {
            this.delCurSubrack(aid);
        }
        TENE ne = TENEListUtils.getNEObj((int)this.neID);
        ne.queryBoard();
    }

    protected void delCurSubrack(String aid) {
        String[] aids = TETL1CommonUtil.parseAID((String)aid, (int)this.neID);
        TENE ne = TENEListUtils.getNEObj((int)this.neID);
        Vector subrackList = ne.getClonedSubrackList();
        for (int i = subrackList.size() - 1; i >= 0; --i) {
            TESubrack sigleSubrack = (TESubrack)subrackList.get(i);
            if (!sigleSubrack.getSubrackID().equals(aids[1])) continue;
            subrackList.remove(i);
        }
        ne.setSubrackList(subrackList);
    }
}

