var st;
var winobj = getNeProperty(self);

var encType = [];
encType["MD5"]= "MD5";
encType["SHA256"]= "SHA256";
encType["PBKDF2"]= "PBKDF2";


function tabSelectHandler()
{
    query();
}

function init()
{
	$("querybtn").value=RESOURCE["query"];
    $("applybtn").value=RESOURCE["applybtn"];

    st = new SortTable();
    st.setImage("../../../../../images/"); 
    createTableHead(st, window.tableconf[0]);
    document.getElementById("tablediv").appendChild(st.getTable());
    st.setBodyHeight(getTableHeight($("tablediv"),st)+"px");
    $("tablediv").oncontextmenu= popupMenuHandler;  
    st.setOnCellEditHandler(cellEditHandler);
    
    $("applybtn").disabled = true;

    
}

function query()
{
    $("querybtn").disabled = true;
	xmlstr = createQueryXML();
	urlreq ="../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_GET_PASSWORD_ENCRYPT_TYPE+"&timeStamp="+new Date().getTime()+"&nmUser="+winobj["nmUser"];
	loadXMLdoc(urlreq, "POST",true, handleBackQuery,null,"inputdata="+xmlstr);
}

function handleBackQuery(doc)
{
	$("querybtn").disabled = false;
    st.clearTableData();
    var data = EncapsulateData(doc);
    
    if(0 != data.getSErrorCode())
    { 
    	showErrorDialog(data);
    	return;
    } 	
	createTableBody(st, window.tableconf[0], data, RESOURCE);
	addListener();
}

function createQueryXML()
{
    di = new inputxml("datainterface");
    bussiness = new tagElement("bussiness-params");
    row = new tagElement("row-params");
    param = new tagElement("param");
 
    param.setAttribute("name","neid");
    param.setAttribute("value",winobj.neid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();	
}

function cellEditHandler(param)
{
	$("applybtn").disabled = false;
}

function apply()
{
    xmlstr =  createSetXML();
    urlreq ="../../../../../tl1NEExlorerServlet?sfid="+TECMDCODE_SET_PASSWORD_ENCRYPT_TYPE+"&timeStamp="+new Date().getTime()+"&nmUser="+winobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, handleBackModify, null, "inputdata="+xmlstr); 	
}

function createSetXML()
{
	di = new inputxml("datainterface");
    bussiness = new tagElement("bussiness-params");
    row = new tagElement("row-params");
    param = new tagElement("param");
    
    param.setAttribute("name", "neid");
    param.setAttribute("value", winobj.neid);
    row.appendChild(param);
    
    var encTypeValue = st.getCellCurrentValue(0, "ENCRYPTTYPE", "ENCRYPTTYPE");
    param = new tagElement("param");
    param.setAttribute("name", "ENCRYPTTYPE");
    param.setAttribute("value", encTypeValue);
    row.appendChild(param);
    
    var logString =  RESOURCE["encType"] + ":" + encTypeValue;
    param = new tagElement("param");
    param.setAttribute("name", "opDesc");
    param.setAttribute("value", logString);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();	
}


function handleBackModify(doc)
{
    var data = EncapsulateData(doc);
    
    if(0 != data.getSErrorCode()) 
    {
        showErrorDialog(data);
        return ;
    }
     refreshTableState(st, window.tableconf[0], data);
    $("applybtn").disabled = true;
}


function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[1] = "UID";
    openErrPage("../../../../../page/", data.getError(), errArr);
}


function addListener()
{ 
	var isSupportPBKDF2 = SpecialAttrMgr.isNESupport(neID, "TE_FUNC_NE_PASSWORD_ENCRYPT_TYPE", "TE_ATTR_NEPASSWORD_ENCRYPTTYPE_SUPPORT_PBKDF2");
	var isnotSupportMD5 = SpecialAttrMgr.isNESupport(neID, "TE_FUNC_NE_PASSWORD_ENCRYPT_TYPE", "TE_ATTR_NEPASSWORD_ENCRYPTTYPE_NOTSUPPORT_MD5");
	
	for(var i = 0,len = st.getDataRowLength(); i < len; i++)
	{	
		/**
		 * Encryption Type
		 * 1 MD5
		 * 2 SHA256
		 * 3 PBKDF2
		 */
		var encTypeCell = st.getCellEdit(i,"ENCRYPTTYPE");		 
		if(encTypeCell)
		{
			encTypeCell.clearOptions(); 
			 if(!isnotSupportMD5)
			 {
				encTypeCell.addOption("MD5","MD5");
			  }
			  encTypeCell.addOption("SHA256","SHA256");	
			  if(isSupportPBKDF2)
			  {
				  encTypeCell.addOption("PBKDF2","PBKDF2");
			  }
			 	
		}
	}
}

