document.title = RESOURCE["createsnmptrap"];
var winurlobj = getParentWindow();
var neid = winurlobj.winobj["neid"];

var OPRSUCC = 0;

var okFlag = false;

var ct;

var trapver =new Object();
trapver[0] = "snmpv1_str";
trapver[1] = "snmpv2c_str";

var logString = "";

function initpage()
{  
    initTable();   
    initButtonText();
}


function initTable()
{
    var atom;
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
    
    var atom = new Atom("text");   
    atom.element.setAttribute("id", "htmlText_snmp_nmip"); 
    atom.element["onfocus"] = function()
    {
	     changeVale(this);
    }
    atom.setValue("0.0.0.0");
    validateIp(atom.element);
    controlInput(atom.element);
    ct.addAttrRow("nmip", RESOURCE["nmip_str"], atom);
    
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_snmp_readwrite");
    atom.addOption(RESOURCE["r"],"R");    
    atom.addOption(RESOURCE["rw"],"RW");
    atom.element["onchange"] = function()
    {
        changeVale(this);
    }
    ct.addAttrRow("rwctrl",RESOURCE["rwctrl"],atom);  
 
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_snmp_port");
    atom.element.text = "162";
    checkText(atom.element, 1, 0xFFFF);
    atom.setValue("162");
    ct.addAttrRow("trapport", RESOURCE["port_str"], atom); 
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_snmp_trapcommunity");
    atom.element.maxLength = 16;
    checkInputData(atom.element, 16);
    ct.addAttrRow("trapcommunity", RESOURCE["trapcommunity_str"], atom);  
    atom.element.style.imeMode = "disabled";
    atom.element["onkeypress"] = function()
    {	     
        changeVale(this);
    }	
        
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_snmp_trapver");
    atom.addOption(RESOURCE["snmpv1_str"],"V1");
    atom.addOption(RESOURCE["snmpv2c_str"],"V2");
    atom.element["onchange"] = function()
    {
        changeVale(this);
    }
    ct.addAttrRow("trapver",RESOURCE["trapver_str"],atom); 
    
    
    $("tablecomponent").appendChild(ct.getTable());
}

/*
 *   
 */
function changeVale(atom)
{
    if ($("applybtn").disabled)
    {
        $("applybtn").disabled=false;
    }
}

function initButtonText()
{     
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"]; 
    $("applybtn").value = RESOURCE["applybtn"]; 
    $("applybtn").disabled = true;
}

function doCreate(buttonFlag)
{
    okFlag = buttonFlag;
    
    if (!checkDataValid())
    {
        return;
    }
    
    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    $("cancelbtn").disabled = true;
  
    var xmlstr = createXML();
    
    var urlreq ="../../../../../tl1NEExlorerServlet?sfid="+PTN_CMD_ADD_SNMPTRAP+""+"&nmUser="+winurlobj.winobj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackCreate,null,"inputdata="+xmlstr);
}

function checkDataValid()
{
    /**var ip = ct.getAttrValue("nmip");
    if(ip == "0.0.0.0")
    {
        alert(RESOURCE["inputip"]);
        return false;
    }**/
	
    if (!check_IPaddr(ct.getAttrValue("nmip")))
    {
        return false;
    }
    
    var inputcommunity = ct.getAttrValue("trapcommunity");
    if (inputcommunity == null || (inputcommunity.length < 6 || inputcommunity.length>16))
    {
		alert(RESOURCE["checktrapcommunity"]);
		return false;
    }
   
    return true;
}

function createXML()
{
	
	logString = "";
	
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",winurlobj.winobj.neid);
    row.appendChild(param);

    param = new tagElement("param");    
    param.setAttribute("name","nmip");
    param.setAttribute("value",ct.getAttrValue("nmip"));
    row.appendChild(param);
    
    stuffLog(RESOURCE["nmip_str"], ct.getAttrValue("nmip"));
    
    param = new tagElement("param");
    param.setAttribute("name", "rwctrl");
    param.setAttribute("value", ct.getAttrValue("rwctrl"));
    row.appendChild(param);
        
    param = new tagElement("param");    
    param.setAttribute("name","trapport");
    param.setAttribute("value",ct.getAttrValue("trapport"));
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","trapcommunity");
    param.setAttribute("value",ct.getAttrValue("trapcommunity"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "trapver");
    param.setAttribute("value", ct.getAttrValue("trapver"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "opDesc");
    param.setAttribute("value", logString);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackCreate(doc)
{
    $("okbtn").disabled=false;
    $("applybtn").disabled=false;
    $("cancelbtn").disabled=false;
    
    var data = EncapsulateData(doc);    
    if(OPRSUCC == data.getSErrorCode()) 
    {       
        winurlobj.querySnmpTrap();        
        if (okFlag)
	    {
	        xcloseDialog();
	    }
    } 
    else
    {   
        var errArr = [];
        errArr[0] = "createsnmptrap";
        openErrPage("../../../../../page/", data.getError(), errArr);
    }   
}

function checkInputData(obj, maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);
    }
   
}


function stuffLog(key, value)
{
	if(logString != "")	 
	{
		logString += "," ;
	}
	logString += key + ":" + value;
}

function controlInput(nmipObj)
{
    nmipObj.onkeyup = function()
    {
        var event=EventUtil.getEvent();
		var objIp = event.srcElement;
		var aryIp = objIp.value.split(splitchar);
		var errFlg = false;
		var i = 0;
		for (i = 0; i < aryIp.length; ++ i)
		{
		    if (aryIp[i] != "")
		    {
			aryIp[i] = parseInt(aryIp[i], 10);
		    }
		    if (aryIp[i] > maxvalue)
		    {
		    	aryIp[i] = maxvalue;
		    	errFlg = true;
		    }
		}
		if (errFlg)
		{
		    objIp.value = aryIp[0];
		    for (i = 1; i < aryIp.length; ++ i)
		    {
		    	objIp.value += (splitchar + aryIp[i]);
		    }
   	     } 
    }
}
