 
var winurlobj = getNeProperty(self);

var btnRightArr = new Object();
btnRightArr["querybtn"] = new BtnRightObj("querybtn",TECMDCODE_COMMU_QUERY_DCCPARAM);
btnRightArr["applybtn"] = new BtnRightObj("applybtn",TECMDCODE_COMMU_SET_DCCPARAM);

window.onload = function()
{
	initButtonText();
	initButtonHandler();
	initTable();	
	getRightInfo(winurlobj,btnRightArr);
	
	initrightbtn(btnRightArr);
	
	if(btnRightArr["querybtn"].right)
	{
		query();
	}
}

function getNeID()
{	
	return winurlobj["neid"];
}

function initButtonText()
{
	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];
  	$("applybtn").disabled = true;
}

function initButtonHandler()
{
	$("querybtn").onclick = queryBefore;
	$("applybtn").onclick = apply;
}

function queryBefore()
{
	query(true);
}

function initTable()
{
	var  atom;
    ct = new CTable();
    ct.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["ID_ENABLE"], 1);
    atom.addOption(RESOURCE["ID_DISABLE2"], 0);
    ct.addAttrRow("ID_NEFIBPORT_VACANTSLOT", RESOURCE["ID_NEFIBPORT_VACANTSLOT"], atom);
    
    ct.attrArray["ID_NEFIBPORT_VACANTSLOT"].element.onchange = setButtonStatus;
    
	document.body.insertBefore(ct.getTable(), document.body.firstChild);
}

function setButtonStatus()
{
	$("applybtn").disabled = !btnRightArr["applybtn"].right;
}

function createRequestData(operation)
{
	var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    var neid=getNeID();    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    if (operation == "apply")
    {
    	var eccstate = ct.getAttrValue("ID_NEFIBPORT_VACANTSLOT");
    	param = new tagElement("param");
    	param.setAttribute("name", "eccstate");
    	param.setAttribute("value", eccstate);
    	row.appendChild(param);
    }
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

function callbackQuery(doc)
{
    $("querybtn").disabled = false;
    
    var dinterface = EncapsulateData(doc);
    var globalError = dinterface.getSErrorCode();
	var detailError = 0;
	if (dinterface.errObj.rowErrors.length > 0)
	{
		detailError = dinterface.getBErrorCode(0);
	}
	
    if(globalError != 0)
    {
		var errArr = [];
	    errArr[0] = "nename";
	    openErrPage("../../../../../page/", dinterface.getError(), errArr)
	    return;
	}
 	
	var	eccstate = dinterface.getDataRowParam(0, "eccstate");
    ct.setAttrValue("ID_NEFIBPORT_VACANTSLOT", eccstate);
}

function callbackApply(doc)
{
    $("applybtn").disabled = false;
    
    var dinterface = EncapsulateData(doc);
    
    if (dinterface.getSErrorCode() != 0)
    {
    	var errArr = [];
	    errArr[0] = "nename";
	    openErrPage("../../../../../page/", dinterface.getError(), errArr)
	    return;
    }
    else
    {
    	query(true);
    }
}

function query(param)
{
	var xml = createRequestData("query");
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	loadXMLdoc("../../../../../neExlorerServlet?sfid="+TECMDCODE_COMMU_QUERY_DCCPARAM+"&flag=1&nmUser="+winurlobj["nmUser"],"POST", true, callbackQuery, null, "inputdata="+xml);
}

function apply()
{
	var xml = createRequestData("apply");
	if (xml == "" || xml == null)
	{
		return;
	}
	$("applybtn").disabled = true;
	loadXMLdoc("../../../../../neExlorerServlet?sfid="+TECMDCODE_COMMU_SET_DCCPARAM+"&flag=1&nmUser="+winurlobj["nmUser"], "POST", true, callbackApply, null, "inputdata="+xml);
}
