/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.staticdata;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TL1MapDesMgr {
    private Map<String, Map<Integer, String>> intToStrValueMap = new Hashtable<String, Map<Integer, String>>();
    private Map<String, Map<String, String>> strToStrValueMap = new Hashtable<String, Map<String, String>>();
    private Map<String, Map<String, Integer>> strToIntValueMap = new Hashtable<String, Map<String, Integer>>();
    private static final String QXATTRIBID_TO_TL1ATTRIBID = "QXATTRIBID_TO_TL1ATTRIBID";
    static final String mapDesFilePath = "nemgr" + File.separator + "tl1necommon" + File.separator + "conf" + File.separator + "tl1map" + File.separator + "map_decription.xml";
    private static TL1MapDesMgr instance;
    private static Document doc;

    public static synchronized TL1MapDesMgr getInstance() {
        if (instance == null) {
            instance = new TL1MapDesMgr();
        }
        return instance;
    }

    public static void setXMLDocumnet(String fileName) {
        doc = TEParseXMLFile.parseFile((File)new File(fileName));
    }

    private TL1MapDesMgr() {
        this.initMap();
    }

    public void initMap() {
        TL1MapDesMgr.initDoc();
        if (null == doc || !doc.hasChildNodes()) {
            return;
        }
        NodeList nodeList = doc.getElementsByTagName("para");
        Node childTag = null;
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            childTag = nodeList.item(i);
            if (!childTag.hasChildNodes()) continue;
            String mapName = this.getNodeAttributeValue(childTag, "name");
            String type = this.getNodeAttributeValue(childTag, "type");
            this.addNewInt2StrMapToWholeMap(mapName, type, childTag.getChildNodes());
        }
    }

    private static void initDoc() {
        if (doc == null) {
            doc = TEParseXMLFile.parseFile((File)TEResourceManager.getFileByName((String)"com.huawei.weblct.tl1necommon", (String)mapDesFilePath));
        }
    }

    private void addStr2IntToMap(Map<String, Integer> Str2IntMapTemp, NodeList nodeList) {
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childElm;
            Node childTag = nodeList.item(i);
            if (!(childTag instanceof Element) || !(childElm = (Element)childTag).getNodeName().equalsIgnoreCase("item")) continue;
            String itemKey = this.getNodeAttributeValue(childElm, "key");
            int strValue = SDXMLInterpreterMgr.getInstance().parseInt(this.getNodeAttributeValue(childElm, "value"));
            Str2IntMapTemp.put(itemKey, strValue);
        }
    }

    private void addNewInt2StrMapToWholeMap(String name, String type, NodeList itemList) {
        if (type.equalsIgnoreCase("int2str")) {
            HashMap<Integer, String> int2StrMapTemp = new HashMap<Integer, String>();
            this.addInt2StrToMap(int2StrMapTemp, itemList);
            this.intToStrValueMap.put(name, int2StrMapTemp);
        } else if (type.equalsIgnoreCase("str2str")) {
            HashMap<String, String> str2StrMapTemp = new HashMap<String, String>();
            this.addStr2StrToMap(str2StrMapTemp, itemList);
            this.strToStrValueMap.put(name, str2StrMapTemp);
        } else if (type.equalsIgnoreCase("str2int")) {
            HashMap<String, Integer> str2IntegerMapTemp = new HashMap<String, Integer>();
            this.addStr2IntToMap(str2IntegerMapTemp, itemList);
            this.strToIntValueMap.put(name, str2IntegerMapTemp);
        } else {
            TELogFactory.getNormalLogger().debug("Unkown map type for " + type);
        }
    }

    private void addInt2StrToMap(Map<Integer, String> int2StrMapTemp, NodeList nodeList) {
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childElm;
            Node childTag = nodeList.item(i);
            if (!(childTag instanceof Element) || !(childElm = (Element)childTag).getNodeName().equalsIgnoreCase("item")) continue;
            int itemKey = SDXMLInterpreterMgr.getInstance().parseInt(this.getNodeAttributeValue(childElm, "key"));
            String strValue = this.getNodeAttributeValue(childElm, "value");
            int2StrMapTemp.put(itemKey, strValue);
        }
    }

    private void addStr2StrToMap(Map<String, String> str2StrMapTemp, NodeList nodeList) {
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childElm;
            Node childTag = nodeList.item(i);
            if (!(childTag instanceof Element) || !(childElm = (Element)childTag).getNodeName().equalsIgnoreCase("item")) continue;
            String itemKey = this.getNodeAttributeValue(childElm, "key");
            String strValue = this.getNodeAttributeValue(childElm, "value");
            str2StrMapTemp.put(itemKey, strValue);
        }
    }

    private String getNodeAttributeValue(Node childTag, String itemName) {
        NamedNodeMap nodeMap = childTag.getAttributes();
        Node idNode = nodeMap.getNamedItem(itemName);
        if (idNode == null) {
            return null;
        }
        return idNode.getNodeValue();
    }

    public String getStringValueByInt(int intValue, String mapName) {
        Map<Integer, String> valueMap;
        if (this.intToStrValueMap.containsKey(mapName) && (valueMap = this.intToStrValueMap.get(mapName)) != null && valueMap.containsKey(intValue)) {
            return valueMap.get(intValue);
        }
        return null;
    }

    public Integer getIntValueByStr(String StrValue, String mapName) {
        Map<String, Integer> valueMap;
        if (this.strToIntValueMap.containsKey(mapName) && (valueMap = this.strToIntValueMap.get(mapName)) != null && valueMap.containsKey(StrValue)) {
            return valueMap.get(StrValue);
        }
        return null;
    }

    public String getTL1AttributeNameFromQx(String qxAttrName) {
        Map<String, String> tl1Map;
        if (this.strToStrValueMap.containsKey(QXATTRIBID_TO_TL1ATTRIBID) && (tl1Map = this.strToStrValueMap.get(QXATTRIBID_TO_TL1ATTRIBID)) != null) {
            return tl1Map.get(qxAttrName);
        }
        return null;
    }
}

