/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.performance.rmon;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.tl1necommon.performance.rmon.TERMONPfmEvent;
import com.huawei.nglct.nemgr.tl1necommon.performance.rmon.TERMONPfmEventKey;
import com.huawei.nglct.nemgr.tl1necommon.performance.rmon.TERMONPfmObjSelect;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TERmonConstant {
    private StringBuffer path = null;
    private static HashMap hm_events = new HashMap();
    private static HashMap hm_almPfm = new HashMap();
    private HashMap<Integer, List> objSelectData = new HashMap();
    private static TERmonConstant instance = null;
    private Document doc = null;
    private NodeList list = null;
    private Element element = null;
    private Logger log = TELogFactory.getNormalLogger();
    private TEAIDAndTypeList aidAndTypeList = null;

    private TERmonConstant() {
    }

    public List parseObjSelectData(int neid, int boardType) {
        if (0 == this.objSelectData.size()) {
            this.initObjSelectData(neid);
        }
        ArrayList result = new ArrayList();
        List list = this.objSelectData.get(boardType);
        if (list != null) {
            int m = list.size();
            for (int i = 0; i < m; ++i) {
                result.add(list.get(i));
            }
        }
        return result;
    }

    public HashMap parseAlmPfmData(int neid) {
        if (0 == hm_almPfm.size()) {
            this.initAlmPfmData(neid);
        }
        return hm_almPfm;
    }

    public TERMONPfmEvent getRmonEvent(int neid, TERMONPfmEventKey key) {
        if (hm_events.isEmpty()) {
            this.initEventData(neid);
        }
        return (TERMONPfmEvent)hm_events.get(key);
    }

    public TERMONPfmEvent getRmonEventByEventID(int neid, int eventID) {
        if (hm_events.isEmpty()) {
            this.initEventData(neid);
        }
        for (Map.Entry entry : hm_events.entrySet()) {
            TERMONPfmEvent event = (TERMONPfmEvent)entry.getValue();
            if (eventID != event.getEventID()) continue;
            return event;
        }
        return null;
    }

    private void initEventData(int neid) {
        this.path = new StringBuffer("nemgr").append(File.separator).append("tl1necommon").append(File.separator).append("conf").append(File.separator).append("performance").append(File.separator).append("boardattribute").append(File.separator).append("rmon").append(File.separator).append("rmonpfmevent").append("_").append(TESysManagerBean.getInstance().getlanguage()).append(".xml");
        this.doc = this.getPfmXMLDoc(neid, this.path.toString());
        this.list = this.doc.getElementsByTagName("param");
        int len = this.list.getLength();
        for (int i = 0; i < len; ++i) {
            this.element = (Element)this.list.item(i);
            int eventID = new Integer(this.element.getAttribute("EventID"));
            String eventShortName = this.element.getAttribute("EventShortName");
            String eventName = this.element.getAttribute("EventName");
            int historicalEvent = new Integer(this.element.getAttribute("HistoricalEvent"));
            int statisticEvent = new Integer(this.element.getAttribute("StatisticEvent"));
            int pMLocation = new Integer(this.element.getAttribute("PMLocation"));
            int groupID = new Integer(this.element.getAttribute("GroupID"));
            String unitName = this.element.getAttribute("UnitName");
            String pMParameterName = this.element.getAttribute("PMParameterName");
            TERMONPfmEvent event = new TERMONPfmEvent(eventID, eventShortName, eventName, historicalEvent, statisticEvent, groupID, unitName, pMParameterName, pMLocation);
            TERMONPfmEventKey eventKey = new TERMONPfmEventKey(eventShortName);
            hm_events.put(eventKey, event);
        }
    }

    private void initObjSelectData(int neid) {
        this.path = new StringBuffer("nemgr").append(File.separator).append("tl1necommon").append(File.separator).append("conf").append(File.separator).append("performance").append(File.separator).append("boardattribute").append(File.separator).append("rmon").append(File.separator).append("rmonpfmobjselect").append("_").append(TESysManagerBean.getInstance().getlanguage()).append(".xml");
        this.log.info("TERmonConstant ------ initObjSelectData(), TEResourceManager.getPath() = " + TEResourceManager.getPath());
        this.log.info("TERmonConstant ------ initObjSelectData(), path = " + this.path);
        this.doc = this.getPfmXMLDoc(neid, this.path.toString());
        this.list = this.doc.getElementsByTagName("param");
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        String neVersion = ne.getHostVersion();
        long neVer = this.getNEVerLong(neVersion);
        List<Integer> portList = null;
        List<Integer> portTEList = null;
        List<Integer> pathList = null;
        int len = this.list.getLength();
        for (int i = 0; i < len; ++i) {
            this.element = (Element)this.list.item(i);
            int brdType = new Integer(this.element.getAttribute("BrdType"));
            long nEVerBegin = new Long(this.element.getAttribute("NEVerBegin"));
            long nEVerEnd = new Long(this.element.getAttribute("NEVerEnd"));
            int type = new Integer(this.element.getAttribute("Type"));
            if (neVer < nEVerBegin || neVer > nEVerEnd) continue;
            portList = this.getListFromStr(this.element.getAttribute("PortId"));
            portTEList = this.getListFromStr(this.element.getAttribute("PortIdTE"));
            pathList = this.getListFromStr(this.element.getAttribute("PathId"));
            this.expendPortPath(brdType, portList, portTEList, pathList, type, nEVerBegin, nEVerEnd);
        }
    }

    private void expendPortPath(int boardType, List<Integer> portList, List<Integer> portTEList, List<Integer> pathList, int type, long nEVerBegin, long nEVerEnd) {
        int port = 0;
        int portTE = 0;
        int path = 0;
        List<TERMONPfmObjSelect> objList = null;
        int m = portList.size();
        for (int i = 0; i < m; ++i) {
            port = portList.get(i);
            portTE = portTEList.get(i);
            int n = pathList.size();
            for (int j = 0; j < n; ++j) {
                path = pathList.get(j);
                TERMONPfmObjSelect objSelect = new TERMONPfmObjSelect(boardType, nEVerBegin, nEVerEnd, type, port, path, portTE);
                if (this.objSelectData.containsKey(boardType)) {
                    objList = this.objSelectData.get(boardType);
                    objList.add(objSelect);
                    continue;
                }
                objList = new ArrayList<TERMONPfmObjSelect>();
                objList.add(objSelect);
                this.objSelectData.put(boardType, objList);
            }
        }
    }

    private List<Integer> getListFromStr(String value) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (null == value || "".equals(value.trim())) {
            return list;
        }
        String[] portlistStr = value.split(",");
        String portStr = null;
        int minportno = -1;
        int maxportno = -1;
        for (int i = portlistStr.length - 1; i >= 0; --i) {
            portStr = portlistStr[i];
            if (portStr == null || portStr.equals("")) continue;
            if ((portStr = portStr.trim()).indexOf("-") > 0) {
                minportno = Integer.parseInt(portStr.split("-")[0]);
                maxportno = Integer.parseInt(portStr.split("-")[1]);
                for (int portno = minportno; portno <= maxportno; ++portno) {
                    list.add(portno);
                }
                continue;
            }
            list.add(Integer.valueOf(portStr));
        }
        return list;
    }

    private void initAlmPfmData(int neid) {
        this.path = new StringBuffer("nemgr").append(File.separator).append("tl1necommon").append(File.separator).append("conf").append(File.separator).append("performance").append(File.separator).append("boardattribute").append(File.separator).append("rmon").append(File.separator).append("rmonalmpfmevent").append("_").append(TESysManagerBean.getInstance().getlanguage()).append(".xml");
        this.doc = this.getPfmXMLDoc(neid, this.path.toString());
        this.list = this.doc.getElementsByTagName("param");
        int len = this.list.getLength();
        for (int i = 0; i < len; ++i) {
            this.element = (Element)this.list.item(i);
            int eventID = new Integer(this.element.getAttribute("EventID"));
            String eventName = this.element.getAttribute("EventName");
            hm_almPfm.put(new Integer(eventID), eventName);
        }
    }

    private Document getPfmXMLDoc(int neid, String path) {
        String filepath = TEResourceManager.getPath() + path;
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile((String)"com.huawei.weblct.tl1necommon", (String)filepath);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TERmonConstant.getPfmXMLDoc() fail!", (Throwable)e);
        }
        return doc;
    }

    public static synchronized TERmonConstant getInstance() {
        if (instance == null) {
            instance = new TERmonConstant();
        }
        return instance;
    }

    public TEAIDAndTypeList getAidAndTypeList() {
        return this.aidAndTypeList;
    }

    public void setAidAndTypeList(TEAIDAndTypeList aidAndTypeList) {
        this.aidAndTypeList = aidAndTypeList;
    }

    private long getNEVerLong(String strVer) {
        String ver = strVer.replace(".", "");
        Long lon = Long.decode("0x" + ver);
        long lonvalue = lon;
        return lonvalue;
    }
}

