/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.performance.rmon;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.performance.rmon.TERMONPfmEvent;
import com.huawei.nglct.nemgr.tl1necommon.performance.rmon.TERMONPfmEventKey;
import com.huawei.nglct.nemgr.tl1necommon.performance.rmon.TERmonConstant;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEQueryRMONEventBean
extends TETL1NEExplorerBean {
    private int TIME_OUT_RMON = 40;
    private int slotID = -1;
    private int portID = -1;
    private int pathID = -1;
    private String mod2 = "";
    private String curPldType = "";
    private static int SUPPORTRMON = 0;
    private static int PLDTYPENOSET = 2;
    private static int PLDTYPEERROR = 1;
    private HashMap boardSupportRmonMod2 = null;
    private static final int STATISTICSGROUP = 1;
    private static final int HISTORYGROUP = 2;
    private int selectFun = 1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        String tabID = inputData.getBussinessParams().getRowParams(0).getParam("SELECTTAB").getValue();
        this.selectFun = Integer.valueOf(tabID);
        Datainterface datainterface = super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        RowParams rowparams = new RowParams();
        this.boardSupportRmonMod2 = this.parseXML();
        int brdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
        int rmonSupCode = this.isSupportRMON(this.mod2, brdType);
        rowparams.addParam("isSupportRMON", String.valueOf(rmonSupCode));
        if (datainterface.getBussinessParams() == null) {
            datainterface.setBussinessParams(new BussinessParams());
        }
        datainterface.getBussinessParams().addRowParams(rowparams);
        return datainterface;
    }

    public TEQueryRMONEventBean() {
        this.bQueryAidAndType = true;
    }

    public int getTimeOut() {
        return this.TIME_OUT_RMON;
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            ArrayList tl1OperList = null;
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            tl1OperList = this.convertToTL1Operation(subFunc, inputData, tl1definitions, null);
            if (tl1OperList.size() != 0) {
                for (int j = tl1OperList.size() - 1; j >= 0; --j) {
                    this.mod2 = ((TL1Operation)tl1OperList.get(j)).getMod2();
                    if (this.mod2.equals("FETH") || this.mod2.equals("GETH") || this.mod2.equals("XGETH") || this.mod2.equals("FC100") || this.mod2.equals("FC400") || this.mod2.equals("FC200") || this.mod2.equals("EPON")) continue;
                    tl1OperList.remove(j);
                }
            }
            return tl1OperList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        String mod1 = "";
        String mod2 = "";
        String cmdCode = "";
        Param slotIdParam = rowparams.getParam("slotid");
        Param portIdParam = rowparams.getParam("portid");
        Param subPortIdParam = rowparams.getParam("subPortID");
        this.slotID = Integer.parseInt(slotIdParam.getValue());
        this.portID = Integer.parseInt(portIdParam.getValue());
        this.pathID = Integer.parseInt(subPortIdParam.getValue());
        mod2 = this.pathID != 0 ? this.aidAndTypeList.getPayLoadMod2(this.neid, this.slotID, this.portID, this.pathID) : this.aidAndTypeList.getPayLoadMod2(this.neid, this.slotID, this.portID);
        if (!mod2.equals("")) {
            StringTokenizer st = new StringTokenizer(mod2, "|");
            while (st.hasMoreTokens()) {
                String strMod2 = st.nextToken();
                if (-1 != strMod2.indexOf("FC100") || -1 != strMod2.indexOf("FC200") || -1 != strMod2.indexOf("FC400") || -1 != strMod2.indexOf("XGETH") || -1 != strMod2.indexOf("GETH") || -1 != strMod2.indexOf("FETH")) {
                    mod2 = strMod2;
                    this.curPldType = strMod2;
                    break;
                }
                if (!strMod2.equals("UNEQ") && !strMod2.equals("NA")) continue;
                this.curPldType = strMod2;
            }
            cmdCode = tl1Operation.getCmdCode();
            mod1 = tl1Operation.getMod1();
            tl1Operation.setName(cmdCode + "-" + mod1 + "-" + mod2);
            tl1Operation.setMod2(mod2);
        }
    }

    protected boolean isFilterRowData(HashMap partmap) {
        Part eventNamePart = null;
        Part locationPart = null;
        Part directionPart = null;
        String eventName = "";
        String location = "";
        String direction = "";
        eventNamePart = (Part)partmap.get("MONTYPE");
        locationPart = (Part)partmap.get("LOCN");
        directionPart = (Part)partmap.get("DIRN");
        if (null != eventNamePart && null != directionPart) {
            eventName = eventNamePart.getValue();
            direction = directionPart.getValue();
            if (null != locationPart) {
                location = locationPart.getValue();
            }
            TERMONPfmEventKey eventKey = new TERMONPfmEventKey(eventName, location, direction);
            TERMONPfmEvent event = TERmonConstant.getInstance().getRmonEvent(this.neid, eventKey);
            if (null == event) {
                return true;
            }
            if (1 == this.selectFun && event.getStatisticEvent() != 1) {
                return true;
            }
            if (2 == this.selectFun && event.getHistoricalEvent() != 1) {
                return true;
            }
        }
        return false;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        Param slotIdParam = null;
        Param portIdParam = null;
        Param subPortIdParam = null;
        int subPortId = 0;
        String prefix = null;
        String shelfSlotStr = null;
        String tempStr = null;
        int nmSlotId = 0;
        int nmPortId = -1;
        int nePortId = -1;
        if (part.getName().equalsIgnoreCase("AID")) {
            slotIdParam = rowparams.getParam("slotid");
            portIdParam = rowparams.getParam("portid");
            subPortIdParam = rowparams.getParam("subPortID");
            if (slotIdParam == null || slotIdParam.getValue() == null || portIdParam == null || portIdParam.getValue() == null) {
                return false;
            }
            nmSlotId = Integer.parseInt(slotIdParam.getValue());
            nmPortId = Integer.parseInt(portIdParam.getValue());
            prefix = TETL1CommonUtil.getAIDFrefix((int)this.neid, (int)nmSlotId, (int)nmPortId);
            nePortId = TETL1CommonUtil.getAIDPortNo((int)this.neid, (int)nmSlotId, (int)nmPortId);
            shelfSlotStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)nmSlotId);
            if (null != subPortIdParam) {
                subPortId = Integer.parseInt(subPortIdParam.getValue());
            }
            tempStr = 0 != subPortId ? prefix + "-" + shelfSlotStr + "-" + nePortId + "-" + subPortId : prefix + "-" + shelfSlotStr + "-" + nePortId;
            part.setValue(tempStr);
            return true;
        }
        if (part.getName().equalsIgnoreCase("MONTYPE")) {
            part.setValue("ALL");
            return true;
        }
        if (part.getName().equalsIgnoreCase("LOCN")) {
            part.setValue("ALL");
            return true;
        }
        if (part.getName().equalsIgnoreCase("DIRN")) {
            part.setValue("BTH");
            return true;
        }
        return super.convertPartValue(part, rowparams);
    }

    public Param convertParamValue(Param oldParam, HashMap partmap) {
        Part eventNamePart = null;
        Part locationPart = null;
        Part directionPart = null;
        int eventID = -1;
        String eventName = "";
        String location = "";
        String direction = "";
        if (oldParam.getName().equals("eventID")) {
            eventNamePart = (Part)partmap.get("MONTYPE");
            locationPart = (Part)partmap.get("LOCN");
            directionPart = (Part)partmap.get("DIRN");
            if (null == eventNamePart || null == directionPart) {
                eventID = -1;
            } else {
                eventName = eventNamePart.getValue();
                direction = directionPart.getValue();
                if (null != locationPart) {
                    location = locationPart.getValue();
                }
                TERMONPfmEventKey eventKey = new TERMONPfmEventKey(eventName, location, direction);
                TERMONPfmEvent event = TERmonConstant.getInstance().getRmonEvent(this.neid, eventKey);
                if (null != event) {
                    eventID = event.getEventID();
                }
            }
            oldParam.setValue(String.valueOf(eventID));
            return oldParam;
        }
        return super.convertParamValue(oldParam, partmap);
    }

    private int isSupportRMON(String mod2, int boardType) {
        if (this.curPldType.equals("UNEQ") || this.curPldType.equals("NA")) {
            return PLDTYPENOSET;
        }
        ArrayList supportList = (ArrayList)this.boardSupportRmonMod2.get(boardType);
        if (null == supportList) {
            return -1;
        }
        if (supportList.contains(mod2)) {
            return SUPPORTRMON;
        }
        return PLDTYPEERROR;
    }

    private HashMap<Integer, ArrayList> parseXML() {
        HashMap<Integer, ArrayList> supportMap = new HashMap<Integer, ArrayList>();
        StringBuffer path = new StringBuffer("nemgr").append(File.separator).append("tl1necommon").append(File.separator).append("conf").append(File.separator).append("performance").append(File.separator).append("boardattribute").append(File.separator).append("rmon").append(File.separator).append("supportrmonmod").append(".xml");
        Element element = null;
        String filepath = TEResourceManager.getPath() + path.toString();
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile((String)"com.huawei.weblct.tl1necommon", (String)filepath);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryRMONEventBean.parseXML() fail!", (Throwable)e);
        }
        if (doc == null) {
            return supportMap;
        }
        NodeList list = doc.getElementsByTagName("board");
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            element = (Element)list.item(i);
            Integer boardType = new Integer(element.getAttribute("boardtype"));
            ArrayList<String> mod2List = new ArrayList<String>();
            String mod2Str = element.getAttribute("supportmod2");
            String[] supMod2 = mod2Str.split(",");
            int size = supMod2.length;
            for (int j = 0; j < size; ++j) {
                mod2List.add(supMod2[j]);
            }
            supportMap.put(boardType, mod2List);
        }
        return supportMap;
    }
}

