/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.performance.rmon;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.performance.rmon.TERMONPfmEvent;
import com.huawei.nglct.nemgr.tl1necommon.performance.rmon.TERMONPfmEventKey;
import com.huawei.nglct.nemgr.tl1necommon.performance.rmon.TERmonConstant;
import com.huawei.nglct.nemgr.tl1necommon.performance.rmon.TERmonStatisticHistoryData;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class TEPfmStatisticsBean
extends TETL1NEExplorerBean {
    private static final String UNKNOWN = "UNKNOWN";
    protected int TIME_OUT_PFM = 40;
    private TERmonStatisticHistoryData staticDataInstance = TERmonStatisticHistoryData.getInstance();
    private String currentMod2 = "";
    private String currentAID = "";
    private boolean isFirstQueryFlag = false;
    private Set<String> needQueryEventSet = new HashSet<String>();

    public TEPfmStatisticsBean() {
        this.bQueryAidAndType = true;
    }

    public int getTimeOut() {
        return this.TIME_OUT_PFM;
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            String mod2_temp = null;
            int eventID = -1;
            Object param = null;
            Object tempRow = null;
            Object event = null;
            ArrayList tl1OperList1 = new ArrayList();
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            BussinessParams bussiness = inputData.getBussinessParams();
            if (bussiness.getRowParamsCount() == 0) {
                return tl1OperList1;
            }
            RowParams rowparams = bussiness.getRowParams(0);
            this.currentMod2 = this.getMod2FromInputData(rowparams);
            this.currentAID = this.getAIDFromInputData(rowparams);
            String isClearData = rowparams.getParam("isSaveData").getValue();
            if (isClearData.equalsIgnoreCase("true")) {
                this.isFirstQueryFlag = true;
                this.staticDataInstance.clearStatisticData();
            }
            String eventIDStr = rowparams.getParam("eventIDStr").getValue();
            String[] eventIDSplit = eventIDStr.split("-");
            int size = eventIDSplit.length;
            for (int i = 0; i < size; ++i) {
                this.needQueryEventSet.add(eventIDSplit[i]);
            }
            tl1OperList1 = this.convertToTL1Operation(subFunc, inputData, tl1definitions, null);
            if (tl1OperList1.size() != 0) {
                for (int j = tl1OperList1.size() - 1; j >= 0; --j) {
                    mod2_temp = ((TL1Operation)tl1OperList1.get(j)).getMod2();
                    if (mod2_temp.equals("FETH") || mod2_temp.equals("GETH") || mod2_temp.equals("XGETH") || mod2_temp.equals("FC100") || mod2_temp.equals("FC400") || mod2_temp.equals("FC200")) continue;
                    tl1OperList1.remove(j);
                }
            }
            return tl1OperList1;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    private String getMod2FromInputData(RowParams rowparams1) {
        int portId = -1;
        int slotId = -1;
        int subPortId = -1;
        String mod2_temp = "";
        Param slotIdParam = rowparams1.getParam("slotid");
        Param portIdParam = rowparams1.getParam("portid");
        Param subPortIdParam = rowparams1.getParam("subPortID");
        slotId = Integer.parseInt(slotIdParam.getValue());
        portId = Integer.parseInt(portIdParam.getValue());
        subPortId = Integer.parseInt(subPortIdParam.getValue());
        mod2_temp = subPortId != 0 ? this.aidAndTypeList.getPayLoadMod2(this.neid, slotId, portId, subPortId) : this.aidAndTypeList.getPayLoadMod2(this.neid, slotId, portId);
        if (!mod2_temp.equals("")) {
            StringTokenizer st = new StringTokenizer(mod2_temp, "|");
            while (st.hasMoreTokens()) {
                String strMod2 = st.nextToken();
                if (-1 == strMod2.indexOf("FC100") && -1 == strMod2.indexOf("FC200") && -1 == strMod2.indexOf("FC400") && -1 == strMod2.indexOf("XGETH") && -1 == strMod2.indexOf("GETH") && -1 == strMod2.indexOf("FETH")) continue;
                mod2_temp = strMod2;
                break;
            }
        }
        return mod2_temp;
    }

    private String getAIDFromInputData(RowParams rowparams) {
        int subPortId = 0;
        String tempStr = "";
        Param slotIdParam = rowparams.getParam("slotid");
        Param portIdParam = rowparams.getParam("portid");
        Param subPortIdParam = rowparams.getParam("subPortID");
        if (slotIdParam == null || slotIdParam.getValue() == null || portIdParam == null || portIdParam.getValue() == null) {
            return "";
        }
        int nmSlotId = Integer.parseInt(slotIdParam.getValue());
        int nmPortId = Integer.parseInt(portIdParam.getValue());
        String prefix = TETL1CommonUtil.getAIDFrefix((int)this.neid, (int)nmSlotId, (int)nmPortId);
        int nePortId = TETL1CommonUtil.getAIDPortNo((int)this.neid, (int)nmSlotId, (int)nmPortId);
        String shelfSlotStr = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)nmSlotId);
        if (null != subPortIdParam) {
            subPortId = Integer.parseInt(subPortIdParam.getValue());
        }
        tempStr = 0 != subPortId ? prefix + "-" + shelfSlotStr + "-" + nePortId + "-" + subPortId : prefix + "-" + shelfSlotStr + "-" + nePortId;
        return tempStr;
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        String mod1 = "";
        String cmdCode = "";
        if (!this.currentMod2.equals("")) {
            cmdCode = tl1Operation.getCmdCode();
            mod1 = tl1Operation.getMod1();
            tl1Operation.setName(cmdCode + "-" + mod1 + "-" + this.currentMod2);
            tl1Operation.setMod2(this.currentMod2);
        }
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        if (part.getName().equalsIgnoreCase("AID")) {
            if (this.currentAID.isEmpty()) {
                return false;
            }
            part.setValue(this.currentAID);
            return true;
        }
        if (part.getName().equalsIgnoreCase("MONTYPE")) {
            part.setValue("ALL");
            return true;
        }
        if (part.getName().equalsIgnoreCase("LOCN")) {
            part.setValue("ALL");
            return true;
        }
        if (part.getName().equalsIgnoreCase("DIRN")) {
            part.setValue("BTH");
            return true;
        }
        return super.convertPartValue(part, rowparams);
    }

    public Param convertParamValue(Param oldParam, HashMap partmap) {
        Part part = null;
        String tempStr = "";
        String boardName = "";
        int nmSlotId = -1;
        String portName = "";
        int nePortId = -1;
        int nmPortId = -1;
        String prefix = null;
        Part date = null;
        Part location = null;
        Part direction = null;
        TENE ne = null;
        TEBoard board = null;
        if (oldParam.getName().equals("neName")) {
            ne = TENEListUtils.getNEObj((int)this.neid);
            tempStr = ne.getNEName();
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("slotid")) {
            tempStr = "";
            part = (Part)partmap.get("AID");
            if (part != null && part.getValue() != null) {
                nmSlotId = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)this.neid);
                tempStr = String.valueOf(nmSlotId);
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("boardTypeName")) {
            boardName = UNKNOWN;
            part = (Part)partmap.get("AID");
            if (part != null && part.getValue() != null) {
                nmSlotId = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)this.neid);
                board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, nmSlotId);
                if (board != null) {
                    boardName = board.getBoardName();
                }
            }
            oldParam.setValue(boardName);
            return oldParam;
        }
        if (oldParam.getName().equals("portid")) {
            tempStr = "";
            part = (Part)partmap.get("AID");
            if (part != null && part.getValue() != null) {
                String[] aidSplit = TETL1CommonUtil.parseAID((String)part.getValue(), (int)this.neid);
                prefix = aidSplit[0];
                nmSlotId = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)this.neid);
                nePortId = Integer.parseInt(aidSplit[3]);
                nmPortId = TETL1CommonUtil.getNMPortNOFromNEPort((String)prefix, (int)nmSlotId, (int)nePortId, (int)this.neid);
                tempStr = String.valueOf(nmPortId);
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("portName")) {
            portName = UNKNOWN;
            part = (Part)partmap.get("AID");
            if (null != part && null != part.getValue()) {
                String[] aidSplit = TETL1CommonUtil.parseAID((String)part.getValue(), (int)this.neid);
                prefix = aidSplit[0];
                nmSlotId = TETL1CommonUtil.getNMSlotStr((String)part.getValue(), (int)this.neid);
                nePortId = Integer.parseInt(aidSplit[3]);
                portName = TETL1CommonUtil.getPortNameFromNEPort((String)prefix, (int)nmSlotId, (int)nePortId, (int)this.neid);
            }
            oldParam.setValue(portName);
            return oldParam;
        }
        if (oldParam.getName().equals("eventID")) {
            part = (Part)partmap.get("MONTYPE");
            location = (Part)partmap.get("LOCN");
            direction = (Part)partmap.get("DIRN");
            tempStr = "";
            if (null != part && null != part.getValue() && null != location && null != location.getValue() && null != direction && null != direction.getValue()) {
                String eventName = part.getValue();
                String eventLocation = location.getValue();
                String eventDirection = direction.getValue();
                TERMONPfmEventKey eventKey = new TERMONPfmEventKey(eventName, eventLocation, eventDirection);
                TERMONPfmEvent event = TERmonConstant.getInstance().getRmonEvent(this.neid, eventKey);
                int eventID = 0;
                if (event != null) {
                    eventID = event.getEventID();
                    tempStr = String.valueOf(eventID);
                }
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("eventValue")) {
            tempStr = "-";
            part = (Part)partmap.get("VALUE");
            if (null != part && null != part.getValue()) {
                tempStr = part.getValue();
            }
            oldParam.setValue(tempStr);
            return oldParam;
        }
        if (oldParam.getName().equals("time")) {
            tempStr = "";
            date = (Part)partmap.get("OCRDAT");
            part = (Part)partmap.get("OCRTM");
            if (null != part && null != part.getValue() && null != date && null != date.getValue()) {
                tempStr = part.getValue();
                tempStr = date.getValue() + " " + tempStr.replaceAll("-", ":");
            }
            ne = TENEListUtils.getNEObj((int)this.neid);
            Calendar cal = TEDateUtils.strToCalendar((String)tempStr, (String)"yyyy-MM-dd HH:mm:ss");
            cal = TEDateUtils.getTL1NMTimeFromNETime((int)this.neid, (long)cal.getTimeInMillis());
            oldParam.setValue(String.valueOf(cal.getTimeInMillis()));
            return oldParam;
        }
        return super.convertParamValue(oldParam, partmap);
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, tl1OperList, filterErrorCodeList);
        RowParams rowparams = null;
        RowParams tempRow = null;
        Param param = null;
        RowErrors rowerrors = null;
        String errorCode = "";
        boolean rowHasError = false;
        BussinessParams bussiness = new BussinessParams();
        tempRow = new RowParams();
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            int size = rowparams.getRowErrorsCount();
            for (int j = 0; j < size; ++j) {
                rowerrors = rowparams.getRowErrors(j);
                errorCode = rowerrors.getErrorMessage().getErrorcode();
                if (errorCode.equals("")) continue;
                rowHasError = true;
                break;
            }
            if (rowHasError) {
                bussiness.addRowParams(rowparams);
                continue;
            }
            if (tempRow.getParam("time") == null) {
                param = rowparams.getParam("time");
                tempRow.addParam(new Param(param.getName(), param.getValue()));
            }
            param = rowparams.getParam("eventID");
            String eventID = param.getValue();
            String newEventID = "event" + eventID;
            if (!this.needQueryEventSet.contains(newEventID)) continue;
            param = rowparams.getParam("eventValue");
            String eventValue = param.getValue();
            tempRow.addParam(new Param(newEventID, eventValue));
        }
        bussiness.addRowParams(tempRow);
        this.outputData.setBussinessParams(bussiness);
        this.staticDataInstance.addStatisticData(tempRow);
    }

    public boolean isNeedOperationlog() {
        return this.isFirstQueryFlag;
    }
}

