/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.performance.pfmconfig;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmconfig.TEPfmThrshRecord;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1PfmBsEvent;
import com.huawei.nglct.tl1.nemanager.TETL1PfmEventsDataLoader;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Hashtable;

public class TEPfmThrshSetBean
extends TETL1NEExplorerBean {
    private long thrsValue = -1L;
    private String errorMonObj = "";
    private String mod2Name = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Datainterface outputData = null;
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        this.errorMonObj = ne.getNEName();
        outputData = super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        this.updatePfmThrsDataMap(ne, inputData, outputData);
        return outputData;
    }

    private void updatePfmThrsDataMap(TETL1NE neObj, Datainterface inputData, Datainterface outData) {
        int slotID = -1;
        int cpType = -1;
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        if (rParams == null || rParams.length == 0 || rParams[0] == null) {
            return;
        }
        if (!outData.getErrorMessage().getErrorcode().equals("0")) {
            return;
        }
        slotID = Integer.parseInt(rParams[0].getParam("slotid").getValue());
        cpType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID);
        Hashtable dataMap = neObj.getPfmThrsDataMap();
        ArrayList list = (ArrayList)dataMap.get(cpType);
        int len = rParams.length;
        for (int j = 0; j < len; ++j) {
            int peid = Integer.parseInt(rParams[j].getParam("peid").getValue());
            int is15mor24h = Integer.parseInt(rParams[j].getParam("period").getValue());
            long thrValue = Long.parseLong(rParams[j].getParam("curValue").getValue());
            this.updatePfmThrsDataList(list, peid, is15mor24h, thrValue);
        }
    }

    private void updatePfmThrsDataList(ArrayList list, int peid, int is15mor24h, long thrValue) {
        if (list == null) {
            return;
        }
        TEPfmThrshRecord record = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            record = (TEPfmThrshRecord)list.get(i);
            if (record.getPeID() != peid || record.getIs15mor24h() != is15mor24h) continue;
            record.setThrValue(thrValue);
            break;
        }
    }

    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                tl1List.add(subfunc.getQxMapping(i).getContent());
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            for (String aid : rowparams.getParam("currentAID").getValue().split(",")) {
                int size = tl1List.size();
                for (int i = 0; i < size; ++i) {
                    tl1Operation = tl1Definitions.getTL1Operation((String)tl1List.get(i));
                    this.changeMod2(tl1Operation, rowparams);
                    if (null == tl1Operation) continue;
                    inputMsg = tl1Operation.getInMsg();
                    if (null == inputMsg) {
                        tl1OperList.add(tl1Operation);
                        continue;
                    }
                    tl1Operation.clearCmdFaultInfo();
                    fillComplete = this.fillStagBlock(aid, inputMsg.getStagBlock());
                    if (fillComplete) {
                        fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                    }
                    if (!this.msgBlockFlag && !fillComplete) continue;
                    tl1OperList.add(tl1Operation);
                }
            }
        }
        return tl1OperList;
    }

    protected boolean fillStagBlock(String aids, StagBlock stagBlock) {
        boolean flag = true;
        AID aidObj = stagBlock.getAID();
        Part part = null;
        int len = aidObj.getPartCount();
        for (int i = 0; i < len; ++i) {
            part = aidObj.getPart(i);
            if (!part.getName().equalsIgnoreCase("AID")) continue;
            part.setValue(aids);
            break;
        }
        return flag;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        int peid = Integer.parseInt(rowparams.getParam("peid").getValue());
        TETL1PfmBsEvent event = TETL1PfmEventsDataLoader.getInstance().getTL1PfmBsEvent(this.neid, peid);
        if (part.getName().equalsIgnoreCase("MONTYPE")) {
            part.setValue(event.getEventName());
        } else if (part.getName().equalsIgnoreCase("THLEV")) {
            this.thrsValue = Long.parseLong(rowparams.getParam("curValue").getValue());
            part.setValue(String.valueOf(this.thrsValue));
        } else if (part.getName().equalsIgnoreCase("LOCN")) {
            part.setValue(TETL1FaultUtil.getTL1ArarmLocationStr((int)event.getLocation()));
        } else if (part.getName().equalsIgnoreCase("DIRN")) {
            part.setValue(TETL1FaultUtil.getTL1ArarmDirectionStr((int)event.getDirection()));
        } else if (part.getName().equalsIgnoreCase("TMPER")) {
            String period = rowparams.getParam("period").getValue();
            if (null == period) {
                return false;
            }
            int intPeriod = new Integer(period);
            if (intPeriod == 1) {
                part.setValue("15-MIN");
            } else if (intPeriod == 2) {
                part.setValue("1-DAY");
            }
        }
        return true;
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        this.mod2Name = rowparams.getParam("aidType").getValue();
        TETL1CommonUtil.modifyMOD2((TL1Operation)tl1Operation, (String)this.mod2Name);
    }

    public RowErrors handleErrorData(int neid, SubFunc subfunc, TL1Operation oper, OutMsg output) {
        String errorCode = output.getFault().getErrCode();
        String errorinfo = output.getFault().getErrDesc();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("monObj", this.errorMonObj);
        rowError.addParam(errorparam);
        errorparam = new Param("thrshValue", String.valueOf(this.thrsValue));
        rowError.addParam(errorparam);
        return rowError;
    }

    public String getBoardStructFromAID(String fac, int neid) {
        String[] aid = TETL1CommonUtil.parseAID((String)fac, (int)neid);
        int slotNMID = TETL1CommonUtil.getNMSlotStr((String)fac, (int)neid);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotNMID);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardType);
        int portID = Integer.parseInt(aid[3]);
        int pathID = Integer.parseInt(aid[4]);
        StringBuffer sb = new StringBuffer();
        sb.append(slotNMID);
        sb.append("-");
        sb.append(boardName);
        if (portID != -1) {
            String portName = TETL1CommonUtil.getPortNameFromNEPort((String)aid[0], (int)slotNMID, (int)portID, (int)neid);
            sb.append("-");
            sb.append(portName);
            sb.append("-");
            sb.append(this.mod2Name);
        }
        if (pathID != -1) {
            sb.append(":");
            sb.append(pathID);
        }
        return sb.toString();
    }
}

