/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.performance.pfmconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nemgr.tl1necommon.performance.TEPfmUtility;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMonObjID;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmconfig.TEPfmThrshComparator;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmconfig.TEPfmThrshRecord;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1PfmBsEvent;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;

public class TEPfmThrshQueryBean
extends TETL1NEExplorerBean {
    private int slotID = -1;
    private TETL1PfmMonObjID pfmmonobj = null;
    private Datainterface output = null;
    private boolean isFalse = false;
    private boolean isTrue = false;
    private static final String SORT_BY_COL = "sortParam";
    private static final String SORT_BY_PARAM = "sortby";
    private static final String SORT_BY_ASC = "asc";
    private static final String SORT_BY_DES = "des";
    private String sortby = "asc";
    private int sortCol = 1;
    private String monObjStruct = "";
    private boolean bQuery = true;
    private TETL1NE neObj = null;
    private int cpType = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        String mod2;
        this.neid = neid;
        this.cloneTL1OperationList = new ArrayList();
        this.output = new Datainterface();
        this.pfmmonobj = new TETL1PfmMonObjID();
        this.neObj = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        this.subfunc = subFunc;
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        PageParams pageParams = inputData.getPageParams();
        int size = pageParams.getParamCount();
        for (int i = 0; i < size; ++i) {
            if (pageParams.getParam(i).getName().equals(SORT_BY_PARAM)) {
                this.sortby = pageParams.getParam(i).getValue();
                continue;
            }
            if (!pageParams.getParam(i).getName().equals(SORT_BY_COL)) continue;
            this.sortCol = Integer.valueOf(pageParams.getParam(i).getValue());
        }
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        int len = rParams[0].getParam().length;
        for (int j = 0; j < len; ++j) {
            Param[] params = rParams[0].getParam();
            Param param = params[j];
            String value = param.getValue();
            if (TEPfmUtility.validateParam(param, "neID")) {
                this.pfmmonobj.m_ulNEID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "slotID")) {
                this.pfmmonobj.m_usSlotID = this.slotID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "fbType")) {
                this.pfmmonobj.m_usFBType = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "portID")) {
                this.pfmmonobj.m_usPortID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "pathID")) {
                this.pfmmonobj.m_usPathID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "ObjListStr")) {
                this.monObjStruct = value;
                continue;
            }
            if (!TEPfmUtility.validateParam(param, "ISSort")) continue;
            this.bQuery = value.equals("true");
        }
        this.pfmmonobj.mod2Name = mod2 = fbDesc.getMOD2(this.pfmmonobj.m_usFBType);
        this.cpType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
        this.output = this.querypfmThrData(neid, this.pfmmonobj);
        this.output.setErrorMessage(new ErrorMessage());
        if (this.isTrue && !this.isFalse) {
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (this.isTrue && this.isFalse) {
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        } else {
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        }
        if (this.isNeedOperationlog()) {
            super.writeLog(neid, subFunc, user, ipAddress, this.cloneTL1OperationList);
        }
        return this.output;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Datainterface querypfmThrData(int neid2, TETL1PfmMonObjID pfmmonobj) {
        ArrayList list;
        Datainterface outputData;
        block14: {
            int size;
            ArrayList pfmMonObjID;
            block13: {
                block11: {
                    int result;
                    block12: {
                        outputData = new Datainterface();
                        outputData.setBussinessParams(new BussinessParams());
                        Hashtable dataMap = this.neObj.getPfmThrsDataMap();
                        list = (ArrayList)dataMap.get(this.cpType);
                        if (list == null) {
                            list = new ArrayList();
                            dataMap.put(this.cpType, list);
                        }
                        if (!this.bQuery) break block11;
                        list.clear();
                        pfmMonObjID = TEPfmUtility.constructPfmMonObj(this.monObjStruct);
                        if (pfmMonObjID.size() == 0) {
                            this.isTrue = true;
                            return outputData;
                        }
                        if (pfmmonobj.m_usPortID != -2) break block12;
                        size = pfmMonObjID.size();
                        break block13;
                    }
                    ArrayList operationList = this.createQueryCurPfmDataRequest(pfmmonobj, false);
                    if (operationList == null || operationList.size() == 0) {
                        this.isTrue = true;
                    }
                    if ((result = this.sendMessage(this.neid, operationList)) != 0) {
                        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                        return this.output;
                    }
                    this.processPfmTHOperationReturn(this.neid, outputData, operationList, pfmmonobj, list);
                    break block14;
                }
                this.isTrue = true;
                break block14;
            }
            for (int i = 0; i < size; ++i) {
                int result;
                TETL1PfmMonObjID pfmMonObj = (TETL1PfmMonObjID)pfmMonObjID.get(i);
                if (pfmMonObj.m_usPortID == 0 && pfmMonObj.m_usPathID == 0) continue;
                ArrayList operationList = this.createQueryCurPfmDataRequest(pfmMonObj, true);
                if (operationList == null || operationList.size() == 0) {
                    this.isTrue = true;
                }
                if ((result = this.sendMessage(this.neid, operationList)) != 0) {
                    this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                    return this.output;
                }
                this.processPfmTHOperationReturn(this.neid, outputData, operationList, pfmMonObj, list);
            }
        }
        TEPfmThrshComparator pfmComparator = new TEPfmThrshComparator();
        if (this.sortby.equalsIgnoreCase(SORT_BY_DES)) {
            pfmComparator.setSortBy(1);
            pfmComparator.setcolSort(this.sortCol);
        } else {
            pfmComparator.setSortBy(0);
            pfmComparator.setcolSort(this.sortCol);
        }
        Collections.sort(list, pfmComparator);
        RowParams[] rowparams = this.convertPfmDataToRowData(list);
        int k = 0;
        while (k < rowparams.length) {
            outputData.getBussinessParams().addRowParams(rowparams[k]);
            ++k;
        }
        return outputData;
    }

    private RowParams[] convertPfmDataToRowData(ArrayList pfmThrshList2) {
        RowParams[] rowparams = new RowParams[pfmThrshList2.size()];
        int size = pfmThrshList2.size();
        for (int i = 0; i < size; ++i) {
            TEPfmThrshRecord record = (TEPfmThrshRecord)pfmThrshList2.get(i);
            rowparams[i] = new RowParams();
            rowparams[i].addParam("peid", String.valueOf(record.getPeID()));
            rowparams[i].addParam("peName", record.getPeName());
            rowparams[i].addParam("AIDType", record.getMod2Name());
            rowparams[i].addParam("location", record.getLocation());
            rowparams[i].addParam("directions", record.getDirection());
            rowparams[i].addParam("thrshType", record.getThrType());
            rowparams[i].addParam("thrshValue", String.valueOf(record.getThrValue()));
            rowparams[i].addParam("is15Mor24H", String.valueOf(record.getIs15mor24h()));
            rowparams[i].addParam("defaultValue", String.valueOf(record.getDefaultValue()));
            rowparams[i].addParam("currentAID", String.valueOf(record.getStrAID()));
        }
        return rowparams;
    }

    private void processPfmTHOperationReturn(int neid, Datainterface outputData, ArrayList operationList, TETL1PfmMonObjID pfmMonObj, ArrayList list) {
        TL1Operation operation = null;
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            operation = (TL1Operation)operationList.get(i);
            int outsize = operation.getOutMsgCount();
            if (outsize == 0) {
                this.isTrue = true;
            }
            for (int j = 0; j < outsize; ++j) {
                OutMsg output = operation.getOutMsg(j);
                if (output.getFault().getCompletionCode() != 0) {
                    this.isFalse = true;
                    operation.addCmdFault(output.getFault());
                    RowErrors rowerror = this.handleErrorData(neid, operation, output);
                    RowParams errrowparams = new RowParams();
                    errrowparams.addRowErrors(rowerror);
                    outputData.getBussinessParams().addRowParams(errrowparams);
                    break;
                }
                this.isTrue = true;
                TEPfmThrshRecord eventRecord = this.convertPfmThrshDataFromNE(neid, output, pfmMonObj);
                if (eventRecord == null || eventRecord.getPeID() == -1) continue;
                if (list.contains(eventRecord)) {
                    String nextAid;
                    String srcAid;
                    TEPfmThrshRecord curRecord = this.getCurrectRecord(list, eventRecord);
                    if (curRecord.getThrValue() != eventRecord.getThrValue()) {
                        curRecord.setThrValue(0L);
                    }
                    if ((srcAid = curRecord.getStrAID()).indexOf(nextAid = eventRecord.getStrAID()) != -1) continue;
                    String newAid = srcAid + "," + nextAid;
                    curRecord.setStrAID(newAid);
                    continue;
                }
                list.add(eventRecord);
            }
            this.cloneTL1OperationList.add(operation.clone());
        }
    }

    private TEPfmThrshRecord convertPfmThrshDataFromNE(int neid, OutMsg output2, TETL1PfmMonObjID pfmMonObj) {
        TEPfmThrshRecord record = new TEPfmThrshRecord();
        HashMap partMap = TETL1CommonUtil.getOutMsgPart((OutMsg)output2);
        String pename = "";
        String location = "";
        String direction = "";
        String mod2Name = pfmMonObj.mod2Name;
        String aidStr = "";
        Part part = null;
        part = (Part)partMap.get("AIDTYPE");
        if (part == null || !part.getValue().equals(pfmMonObj.mod2Name)) {
            return null;
        }
        part = (Part)partMap.get("AID");
        aidStr = part.getValue();
        part = (Part)partMap.get("MONTYPE");
        pename = part.getValue();
        part = (Part)partMap.get("LOCN");
        location = part.getValue();
        part = (Part)partMap.get("DIRN");
        direction = part.getValue();
        TETL1PfmBsEvent event = TEPfmUtility.getPfmDataFromStatic(mod2Name, TETL1FaultUtil.getTL1AlarmLocation((String)location), TETL1FaultUtil.getTL1AlarmDirection((String)direction), pename);
        if (event == null) {
            return record;
        }
        if (event.getDftThr15m() == 0 && event.getDftThr24h() == 0) {
            return null;
        }
        record.setMod2Name(mod2Name);
        record.setPeName(pename + "(" + event.getUnitName() + ")");
        record.setPeID(event.getEventID());
        record.setLocation(location);
        record.setDirection(direction);
        record.setStrAID(aidStr);
        part = (Part)partMap.get("TMPER");
        String thrshType = this.getThrshType(part.getValue(), event);
        record.setThrType(thrshType);
        if (part.getValue().equals("15-MIN")) {
            record.setIs15mor24h(1);
            record.setDefaultValue(event.getDftThr15m());
        }
        if (part.getValue().equals("1-DAY")) {
            record.setIs15mor24h(2);
            record.setDefaultValue(event.getDftThr24h());
        }
        part = (Part)partMap.get("THLEV");
        record.setThrValue(Long.decode(part.getValue()));
        return record;
    }

    private String getThrshType(String value, TETL1PfmBsEvent event) {
        StringBuffer sb = new StringBuffer();
        if (value.equals("15-MIN")) {
            sb.append("15-Minute Threshold");
            sb.append("[");
            sb.append(event.getMinThr15m());
            sb.append("-");
            sb.append(event.getMaxThr15m());
            sb.append("]");
        }
        if (value.equals("1-DAY")) {
            sb.append("24-Hour Threshold");
            sb.append("[");
            sb.append(event.getMinThr24h());
            sb.append("-");
            sb.append(event.getMaxThr24h());
            sb.append("]");
        }
        return sb.toString();
    }

    private ArrayList createQueryCurPfmDataRequest(TETL1PfmMonObjID pfmMonObj, boolean isBoardLevel) {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation opertemp = definitions.getTL1Operation("RTRV-TH");
            TL1Operation oper15 = this.createOperation(opertemp, "15-MIN", isBoardLevel, pfmMonObj);
            TL1Operation oper24 = this.createOperation(opertemp, "1-DAY", isBoardLevel, pfmMonObj);
            operationList.add(oper15);
            operationList.add(oper24);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEPfmThrshQueryBean.createQueryCurPfmDataRequest() fail!", (Throwable)e);
        }
        return operationList;
    }

    private TL1Operation createOperation(TL1Operation opertemp, String tmper, boolean isBoard, TETL1PfmMonObjID pfmMonObj) {
        TL1Operation oper = (TL1Operation)opertemp.clone();
        if (isBoard) {
            oper.setMod2(pfmMonObj.mod2Name);
        } else {
            oper.setMod2(this.pfmmonobj.mod2Name);
        }
        String name = oper.getCmdCode() + "-" + oper.getMod1() + "-" + oper.getMod2();
        oper.setName(name);
        InMsg inputMsg = oper.getInMsg();
        StagBlock stagblock = inputMsg.getStagBlock();
        AID aid = stagblock.getAID();
        Part aidPart = aid.getPart(0);
        String newAid = "";
        newAid = isBoard ? TEPfmUtility.getAIDFromalmFB(this.neid, this.slotID, pfmMonObj) : TEPfmUtility.getAIDFromalmFB(this.neid, this.slotID, this.pfmmonobj);
        aidPart.setValue(newAid);
        MsgBlock msgblock = inputMsg.getMsgBlock();
        DataBlock dataBlock = null;
        Part part = null;
        int len = msgblock.getDataBlockCount();
        for (int j = 0; j < len; ++j) {
            dataBlock = msgblock.getDataBlock(j);
            int length = dataBlock.getPartCount();
            for (int k = 0; k < length; ++k) {
                part = dataBlock.getPart(k);
                this.convertPartValue(part, tmper);
            }
        }
        return oper;
    }

    private void convertPartValue(Part part, String tmper) {
        if (part.getName().equalsIgnoreCase("TMPER")) {
            part.setValue(tmper);
        } else {
            part.setValue("");
        }
    }

    private TEPfmThrshRecord getCurrectRecord(ArrayList list, TEPfmThrshRecord oldRecord) {
        TEPfmThrshRecord record = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            record = (TEPfmThrshRecord)list.get(i);
            if (record.getPeID() != oldRecord.getPeID() || record.getIs15mor24h() != oldRecord.getIs15mor24h()) continue;
            return record;
        }
        return null;
    }

    public RowErrors handleErrorData(int neid, TL1Operation oper, OutMsg output) {
        InMsg input = oper.getInMsg();
        String AID2 = input.getStagBlock().getAID().getPart(0).getValue();
        String obj = TETL1FaultUtil.getBoardStructFromAID((String)AID2, (int)neid, (boolean)true, (String)oper.getMod2());
        return TEPfmUtility.handleRowError(output, obj);
    }
}

