/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nemgr.tl1necommon.performance.TEPfmUtility;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmCPEvent;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmConfigDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMonObjID;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse.BERConvertQValueClass;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse.TEHisPfmComparator;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse.TEHisPfmFilter;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse.TEHisPfmRecord;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1PfmBsEvent;
import com.huawei.nglct.tl1.nemanager.TETL1PfmEventsDataLoader;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;

public class TEHistoryPfmDataBean
extends TETL1NEExplorerBean {
    private TimeZoneDateBean TimeProccessor = null;
    ArrayList hisPfmList = new ArrayList();
    private static final String SORT_BY_COL = "sortParam";
    private static final String SORT_BY_PARAM = "sortby";
    private static final String SORT_BY_ASC = "asc";
    private static final String SORT_BY_DES = "des";
    private String sortby = "asc";
    private int sortCol = 1;
    ArrayList pfmMonObjIDs = new ArrayList();
    ArrayList eventList = new ArrayList();
    private int neID = 0;
    private int slotID = 0;
    private int period = 1;
    private static Datainterface output = null;
    private boolean ShowZeroData = false;
    private TETL1PfmMonObjID pfmmonobj = null;
    TEHisPfmFilter filter = null;
    private boolean isFalse = false;
    private boolean isTrue = false;
    private TETL1NE neObj = null;
    private String monObjStruct = "";
    private int boardType = -1;
    private HashMap pmfDataMap = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        this.TimeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neID);
        this.pfmmonobj = new TETL1PfmMonObjID();
        this.filter = new TEHisPfmFilter();
        this.subfunc = subFunc;
        this.cloneTL1OperationList = new ArrayList();
        this.neObj = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        this.pmfDataMap = TETL1PfmEventsDataLoader.getInstance().getEventMap();
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        if (null != rowParams[0].getParam("filename")) {
            rowParams = memeryData.getBussinessParams().getRowParams();
            int len = rowParams.length;
            for (int i = 0; i < len; ++i) {
                Param param = null;
                String val = "";
                param = rowParams[i].getParam("peValue");
                val = param.getValue();
                String peName = rowParams[i].getParam("peName").getValue();
                if (peName.equals("FEC-AFTCOR-ER(BER)") || peName.equals("FEC-BEFCOR-ER(BER)")) continue;
                int index = val.indexOf(".");
                if (index > val.length() - 3) {
                    param.setValue(val + "0");
                }
                if (val.length() - index <= 3) continue;
                param.setValue(val.substring(0, index + 3));
            }
            return memeryData;
        }
        PageParams pageParas = inputData.getPageParams();
        int size = pageParas.getParamCount();
        for (int i = 0; i < size; ++i) {
            if (pageParas.getParam(i).getName().equals(SORT_BY_PARAM)) {
                this.sortby = pageParas.getParam(i).getValue();
                continue;
            }
            if (!pageParas.getParam(i).getName().equals(SORT_BY_COL)) continue;
            this.sortCol = Integer.valueOf(pageParas.getParam(i).getValue());
        }
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        int len = rParams[0].getParam().length;
        for (int j = 0; j < len; ++j) {
            Calendar cal;
            Param[] params = rParams[0].getParam();
            long offset = 0L;
            Param offsetParam = rParams[0].getParam("offset");
            Param para = params[j];
            String value = para.getValue();
            if (TEPfmUtility.validateParam(para, "neID")) {
                this.pfmmonobj.m_ulNEID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(para, "slotID")) {
                this.pfmmonobj.m_usSlotID = this.slotID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(para, "fbType")) {
                this.pfmmonobj.m_usFBType = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(para, "portID")) {
                this.pfmmonobj.m_usPortID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(para, "pathID")) {
                this.pfmmonobj.m_usPathID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(para, "period")) {
                this.period = Integer.parseInt(value);
                this.filter.setPeriod(Integer.parseInt(value));
                continue;
            }
            if (TEPfmUtility.validateParam(para, "mainType")) {
                this.filter.setMainTypeList(value);
                continue;
            }
            if (TEPfmUtility.validateParam(para, "extType")) {
                this.filter.setExtTypeList(value);
                continue;
            }
            if (TEPfmUtility.validateParam(para, "subType")) {
                this.filter.setSubTypeList(value);
                continue;
            }
            if (TEPfmUtility.validateParam(para, "beginTime")) {
                if (offsetParam != null && offsetParam.getValue() != null) {
                    offset = Long.parseLong(offsetParam.getValue());
                }
                cal = Calendar.getInstance();
                cal.setTimeInMillis(TEDateUtils.strToCalendar((String)value, (String)"yyyy-MM-dd HH:mm:ss").getTimeInMillis() + offset);
                cal = TEDateUtils.getTL1NETimeFromNMUTCTime((int)neid, (long)cal.getTimeInMillis());
                String startTime = TEDateUtils.calendarToStr((Calendar)cal);
                this.filter.setNeid(this.neID);
                this.filter.setOffset(offset);
                this.filter.setStartTime(startTime);
                continue;
            }
            if (TEPfmUtility.validateParam(para, "endTime")) {
                if (offsetParam != null && offsetParam.getValue() != null) {
                    offset = Long.parseLong(offsetParam.getValue());
                }
                cal = Calendar.getInstance();
                cal.setTimeInMillis(TEDateUtils.strToCalendar((String)value, (String)"yyyy-MM-dd HH:mm:ss").getTimeInMillis() + offset);
                cal = TEDateUtils.getTL1NETimeFromNMUTCTime((int)neid, (long)cal.getTimeInMillis());
                String endTime = TEDateUtils.calendarToStr((Calendar)cal);
                this.filter.setEndTime(endTime);
                continue;
            }
            if (TEPfmUtility.validateParam(para, "ZeroData")) {
                this.ShowZeroData = value.equalsIgnoreCase("true");
                if (!this.ShowZeroData) continue;
                this.TIME_OUT = 30;
                continue;
            }
            if (!TEPfmUtility.validateParam(para, "ObjListStr")) continue;
            this.monObjStruct = value;
        }
        this.filter.setPfmmonobj(this.pfmmonobj);
        if (this.pfmmonobj.m_usPortID == -2) {
            this.pfmMonObjIDs.add(this.pfmmonobj);
            this.filter.setFb(false);
        } else {
            this.filter.setFb(true);
        }
        output = this.queryHistoryPfmData(this.neID, this.pfmmonobj, this.filter);
        output.setErrorMessage(new ErrorMessage());
        if (this.isTrue && !this.isFalse) {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
        } else if (this.isTrue && this.isFalse) {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)1));
        } else {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)2));
        }
        if (this.isNeedOperationlog()) {
            super.writeLog(this.neID, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
        }
        return output;
    }

    public Datainterface queryHistoryPfmData(int neID, TETL1PfmMonObjID pfmmonobj, TEHisPfmFilter filter) {
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        this.boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neID, this.slotID);
        ArrayList pfmMonObjID = TEPfmUtility.constructPfmMonObj(this.monObjStruct);
        this.eventList = TETL1PfmConfigDataMgr.getInstance().getBoardSupportPfmIDList(this.boardType);
        if (pfmmonobj.m_usPortID == -2) {
            int size = pfmMonObjID.size();
            for (int i = 0; i < size; ++i) {
                TETL1PfmMonObjID pfmMonObj = (TETL1PfmMonObjID)pfmMonObjID.get(i);
                this.pfmMonObjIDs.add(pfmMonObj);
                ArrayList operationList = this.createQueryHisPfmDataRequest(this.period, pfmMonObj, filter);
                int result = this.sendMessage(neID, operationList);
                if (result != 0) {
                    output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                    return output;
                }
                ArrayList eventList = this.convertHisPfmDataFromNE(neID, outputData, operationList, pfmMonObj, filter);
                this.hisPfmList.addAll(eventList);
            }
        } else {
            ArrayList operationList = this.createQueryHisPfmDataRequest(this.period, pfmmonobj, filter);
            int result = this.sendMessage(neID, operationList);
            if (result == 0) {
                ArrayList eventList = this.convertHisPfmDataFromNE(neID, outputData, operationList, pfmmonobj, filter);
                this.hisPfmList.addAll(eventList);
            } else {
                output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                return output;
            }
        }
        TEHisPfmComparator pfmComparator = new TEHisPfmComparator();
        if (this.sortby.equalsIgnoreCase(SORT_BY_DES)) {
            pfmComparator.setSortBy(1);
            pfmComparator.setcolSort(this.sortCol);
        } else {
            pfmComparator.setSortBy(0);
            pfmComparator.setcolSort(this.sortCol);
        }
        if (this.ShowZeroData) {
            this.addZeroDate();
        }
        Collections.sort(this.hisPfmList, pfmComparator);
        RowParams[] rowparams = TEHistoryPfmDataBean.convertPfmDataToRowData(neID, this.hisPfmList, this.TimeProccessor);
        for (int k = 0; k < rowparams.length; ++k) {
            outputData.getBussinessParams().addRowParams(rowparams[k]);
        }
        return outputData;
    }

    private ArrayList convertHisPfmDataFromNE(int neID2, Datainterface outputData, ArrayList operationList, TETL1PfmMonObjID pfmMonObj2, TEHisPfmFilter filter2) {
        ArrayList<TEHisPfmRecord> temp = new ArrayList<TEHisPfmRecord>();
        TL1Operation operation = (TL1Operation)operationList.get(0);
        Date date = operation.getDate();
        int size = operation.getOutMsgCount();
        if (size == 0) {
            this.isTrue = true;
        }
        for (int i = 0; i < size; ++i) {
            OutMsg output = operation.getOutMsg(i);
            if (!output.getFault().getErrDesc().equals("")) {
                this.isFalse = true;
                operation.addCmdFault(output.getFault());
                RowErrors rowerror = TEPfmUtility.handleRowError(output, this.neObj.getNEName());
                RowParams errrowparams = new RowParams();
                errrowparams.addRowErrors(rowerror);
                outputData.getBussinessParams().addRowParams(errrowparams);
                break;
            }
            this.isTrue = true;
            TEHisPfmRecord eventRecord = this.convertHisPfmDataFromNE(this.neID, output, this.filter, date);
            if (eventRecord == null || eventRecord.peid == -1) continue;
            temp.add(eventRecord);
        }
        this.cloneTL1OperationList.add(operation.clone());
        return temp;
    }

    private ArrayList createQueryHisPfmDataRequest(int periodType, TETL1PfmMonObjID pfmmonobj, TEHisPfmFilter filter) {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            TL1Operation operSour = definitions.getTL1Operation("RTRV-PM");
            TL1Operation operat = (TL1Operation)operSour.clone();
            TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
            if (pfmmonobj.mod2Name.equals("")) {
                String mod2 = fbDesc.getMOD2(pfmmonobj.m_usFBType);
                if (mod2 == null || mod2.equals("")) {
                    operat.setMod2("");
                } else {
                    operat.setMod2(mod2);
                }
            } else {
                operat.setMod2(pfmmonobj.mod2Name);
            }
            String name = operat.getCmdCode() + "-" + operat.getMod1() + "-" + operat.getMod2();
            operat.setName(name);
            InMsg inputMsg = operat.getInMsg();
            StagBlock stagblock = inputMsg.getStagBlock();
            AID aid = stagblock.getAID();
            Part aidPart = aid.getPart(0);
            String newAid = TEPfmUtility.getAIDFromalmFB(this.neID, this.slotID, pfmmonobj);
            aidPart.setValue(newAid);
            MsgBlock msgblock = inputMsg.getMsgBlock();
            DataBlock dataBlock = null;
            Part partVal = null;
            int len = msgblock.getDataBlockCount();
            for (int j = 0; j < len; ++j) {
                dataBlock = msgblock.getDataBlock(j);
                int length = dataBlock.getPartCount();
                for (int k = 0; k < length; ++k) {
                    partVal = dataBlock.getPart(k);
                    this.convertPartValue(partVal, pfmmonobj, filter);
                }
            }
            operationList.add(operat);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEHistoryPfmDataBean.createQueryHisPfmDataRequest() fail!", (Throwable)e);
        }
        return operationList;
    }

    private TEHisPfmRecord convertHisPfmDataFromNE(int neID, OutMsg output, TEHisPfmFilter filter, Date date) {
        HashMap partMap = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
        TEHisPfmRecord records = new TEHisPfmRecord();
        String aidType = "";
        String location = "";
        String direction = "";
        String startDate = "";
        String startTime = "";
        Part partVal = null;
        partVal = (Part)partMap.get("AID");
        if (partVal.getValue() == null) {
            return records;
        }
        String aid = partVal.getValue();
        int slotID = TETL1CommonUtil.getNMSlotStr((String)aid, (int)neID);
        records.pfmmonobj.m_ulNEID = neID;
        records.pfmmonobj.m_usSlotID = slotID;
        int portID = TETL1CommonUtil.getNMPortNOFromAidStruct((String)aid, (int)neID);
        int pathID = TETL1CommonUtil.getPathIDFromAidStruct((String)aid, (int)neID);
        if (portID == -1) {
            portID = 0;
        }
        if (pathID == -1) {
            pathID = 0;
        }
        records.pfmmonobj.m_usPortID = portID;
        records.pfmmonobj.m_usPathID = pathID;
        partVal = (Part)partMap.get("AIDTYPE");
        aidType = partVal.getValue();
        partVal = (Part)partMap.get("LOCN");
        location = partVal.getValue();
        partVal = (Part)partMap.get("DIRN");
        direction = partVal.getValue();
        partVal = (Part)partMap.get("MONTYPE");
        TETL1PfmBsEvent event = TEPfmUtility.getPfmDataFromStatic(aidType, TETL1FaultUtil.getTL1AlarmLocation((String)location), TETL1FaultUtil.getTL1AlarmDirection((String)direction), partVal.getValue());
        if (event == null) {
            return records;
        }
        records.peid = event.getEventID();
        records.peName = partVal.getValue() + "(" + event.getUnitName() + ")";
        records.location = TETL1FaultUtil.converAlarmLocation((String)location);
        records.direction = TETL1FaultUtil.convertAlarmDirection((String)direction);
        records.pfmmonobj.m_usFBType = event.getFbType();
        records.pfmmonobj.mod2Name = aidType;
        partVal = (Part)partMap.get("TMPER");
        records.period = partVal.getValue().equals("15-MIN") ? 1 : 2;
        partVal = (Part)partMap.get("MONDAT");
        startDate = partVal.getValue();
        String[] strdate = startDate.split("-");
        int month = Integer.parseInt(strdate[0]);
        int day = Integer.parseInt(strdate[1]);
        partVal = (Part)partMap.get("MONTM");
        startTime = partVal.getValue();
        String[] strtime = startTime.split("-");
        int hour = Integer.parseInt(strtime[0]);
        int minute = Integer.parseInt(strtime[1]);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1) - 1900;
        if (year < 1900) {
            year = cal.get(1);
        }
        Calendar calnew = Calendar.getInstance();
        calnew.set(year, month - 1, day, hour, minute, 0);
        records.startTime = TEDateUtils.calendarToStr((Calendar)calnew);
        records.startCal = calnew;
        partVal = (Part)partMap.get("MONVAL");
        records.peValue = Double.parseDouble(partVal.getValue());
        partVal = (Part)partMap.get("VLDTY");
        records.validity = partVal.getValue();
        if (filter.filter(event, records, this.pfmMonObjIDs, this.eventList, true)) {
            return records;
        }
        return null;
    }

    private void convertPartValue(Part part, TETL1PfmMonObjID pfmmonobj2, TEHisPfmFilter filter2) {
        if (part.getName().equalsIgnoreCase("TMPER")) {
            int tmper = filter2.getPeriod();
            if (tmper == 1) {
                part.setValue("15-MIN");
            } else {
                part.setValue("1-DAY");
            }
        } else if (part.getName().equalsIgnoreCase("monlev")) {
            if (this.ShowZeroData) {
                part.setValue("0-UP");
            } else {
                part.setValue("");
            }
        } else if (part.getName().equalsIgnoreCase("mondat")) {
            Calendar cal = TEDateUtils.strToCalendar((String)filter2.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            String time = TEDateUtils.calendarToStr((Calendar)cal);
            part.setValue(this.convertStrDateTimeToDate(time));
        } else if (part.getName().equalsIgnoreCase("montm")) {
            Calendar cal = TEDateUtils.strToCalendar((String)filter2.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            String time = TEDateUtils.calendarToStr((Calendar)cal);
            part.setValue(this.convertStrDateTimeToTime(time));
        } else {
            part.setValue("");
        }
    }

    private String convertStrDateTimeToDate(String startTime) {
        String[] dateTime = startTime.split(" ");
        String[] date = dateTime[0].split("-");
        return date[1] + "-" + date[2];
    }

    private String convertStrDateTimeToTime(String startTime) {
        String[] dateTime = startTime.split(" ");
        String[] date = dateTime[1].split(":");
        return date[0] + "-" + date[1];
    }

    public static RowParams[] convertPfmDataToRowData(int neID, ArrayList eventList, TimeZoneDateBean TimeProccessor) {
        RowParams[] rowparams = new RowParams[eventList.size()];
        for (int i = 0; i < eventList.size(); ++i) {
            TEHisPfmRecord record = (TEHisPfmRecord)eventList.get(i);
            rowparams[i] = new RowParams();
            rowparams[i].addParam("pfmMonObj", record.pfmmonobj.toString());
            rowparams[i].addParam("peid", String.valueOf(record.peid));
            rowparams[i].addParam("peName", record.peName);
            rowparams[i].addParam("location", record.location);
            rowparams[i].addParam("direction", record.direction);
            String period = record.period == 1 ? "15-MIN" : "1-DAY";
            rowparams[i].addParam("period", period);
            Calendar cal = TEDateUtils.strToCalendar((String)record.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            cal = TEDateUtils.getTL1NMTimeFromNETime((int)neID, (long)cal.getTimeInMillis());
            rowparams[i].addParam("beginTime", String.valueOf(cal.getTimeInMillis()));
            rowparams[i].addParam("peValue", String.valueOf(BERConvertQValueClass.convertQValue(record.peName, record.peValue)));
            rowparams[i].addParam("validity", record.validity);
        }
        return rowparams;
    }

    private void addZeroDate() {
        ArrayList tmTmpList = this.computeZeroPeriod(this.getTimeList(), this.period, this.hisPfmList);
        ArrayList eventObjList = TETL1PfmConfigDataMgr.getInstance().getBoardSupportPfmIDList(this.boardType, this.pfmmonobj.m_usPortID, this.pfmmonobj.m_usPathID, this.pfmmonobj.m_usFBType);
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        ArrayList<Object> tmpList = new ArrayList<Object>();
        int size = eventObjList.size();
        for (int i = 0; i < size; ++i) {
            TETL1PfmCPEvent cpevent = (TETL1PfmCPEvent)eventObjList.get(i);
            TETL1PfmBsEvent event = (TETL1PfmBsEvent)this.pmfDataMap.get(cpevent.getEventID());
            if (!TEPfmUtility.isCountFB(event.getEventType())) continue;
            boolean flag = true;
            int pfmsize = this.hisPfmList.size();
            for (int j = 0; j < pfmsize; ++j) {
                TEHisPfmRecord curRecord = (TEHisPfmRecord)this.hisPfmList.get(j);
                if (event.getEventID() != curRecord.getPeid() || cpevent.getPortID() != curRecord.pfmmonobj.m_usPortID || cpevent.getPathID() != curRecord.pfmmonobj.m_usPathID || cpevent.getFbType() != curRecord.pfmmonobj.m_usFBType) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            TEHisPfmRecord record = new TEHisPfmRecord();
            record.peid = event.getEventID();
            record.peName = event.getEventName() + "(" + event.getUnitName() + ")";
            String location = TETL1FaultUtil.getTL1ArarmLocationStr((int)event.getLocation());
            String direction = TETL1FaultUtil.getTL1ArarmDirectionStr((int)event.getDirection());
            record.location = TETL1FaultUtil.converAlarmLocation((String)location);
            record.direction = TETL1FaultUtil.convertAlarmDirection((String)direction);
            record.pfmmonobj.m_ulNEID = this.neID;
            record.pfmmonobj.m_usSlotID = this.slotID;
            record.pfmmonobj.m_usFBType = cpevent.getFbType();
            record.pfmmonobj.m_usPortID = cpevent.getPortID();
            record.pfmmonobj.m_usPathID = cpevent.getPathID();
            record.pfmmonobj.mod2Name = fbDesc.getMOD2(cpevent.getFbType());
            record.period = this.filter.getPeriod();
            record.peValue = 0.0;
            record.validity = "Invalid";
            if (!this.filter.filter(event, record, this.pfmMonObjIDs, this.eventList, false)) continue;
            int size3 = tmTmpList.size();
            for (int k = 0; k < size3; ++k) {
                record.endTime = record.startTime = TEDateUtils.calendarToStr((Calendar)((Calendar)tmTmpList.get(k)));
                if (record.startTime.compareToIgnoreCase(this.filter.getStartTime()) < 0 || record.endTime.compareToIgnoreCase(this.filter.getEndTime()) > 0) continue;
                record.startCal = (Calendar)tmTmpList.get(k);
                if (tmpList.contains(record)) continue;
                tmpList.add(record.clone());
            }
        }
        this.hisPfmList.addAll(tmpList);
    }

    public ArrayList computeZeroPeriod(ArrayList tmList, int period, ArrayList hisPfmList) {
        int nMaxEventCount = 0;
        long nInterval = 0L;
        if (1 == period) {
            nInterval = 900000L;
            nMaxEventCount = 16;
        } else {
            nMaxEventCount = 6;
            nInterval = 86400000L;
        }
        ArrayList<Object> tmTmpList = new ArrayList<Object>();
        if (!tmList.isEmpty()) {
            Calendar tmpTime = (Calendar)tmList.get(0);
            TELogFactory.getNormalLogger().info("\u00bc\u00c6\u00cb\u00e3\u00b5\u00c4\u00d6\u00dc\u00c6\u00da\u00ca\u00b1\u00bc\u00e4\u00b5\u00e3\u00c8\u00e7\u00cf\u00c2:");
            if (hisPfmList.isEmpty()) {
                tmpTime = TEDateUtils.getTL1NETimeFromNMTime((int)this.neID, (long)tmpTime.getTimeInMillis());
            }
            for (int i = 0; i < nMaxEventCount; ++i) {
                String tempTimeStr = TEDateUtils.calendarToStr((Calendar)tmpTime);
                if (tempTimeStr.compareToIgnoreCase(this.filter.getStartTime()) < 0 || tempTimeStr.compareToIgnoreCase(this.filter.getEndTime()) > 0) {
                    tmpTime.setTimeInMillis(tmpTime.getTimeInMillis() - nInterval);
                    continue;
                }
                TELogFactory.getNormalLogger().info(tempTimeStr);
                tmTmpList.add(tmpTime.clone());
                tmpTime.setTimeInMillis(tmpTime.getTimeInMillis() - nInterval);
            }
        }
        return tmTmpList;
    }

    private ArrayList getTimeList() {
        ArrayList<Calendar> tmList = new ArrayList<Calendar>();
        if (!this.hisPfmList.isEmpty()) {
            int size = this.hisPfmList.size();
            for (int i = 0; i < size; ++i) {
                Calendar tmpTime;
                TEHisPfmRecord record = (TEHisPfmRecord)this.hisPfmList.get(i);
                if (null == record.startTime || tmList.contains(tmpTime = TEDateUtils.strToCalendar((String)record.startTime))) continue;
                tmList.add(tmpTime);
            }
        }
        if (tmList.isEmpty()) {
            tmList.add(this.getCurrentTime(this.filter.getPeriod()));
        } else {
            Collections.sort(tmList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Calendar cal1 = (Calendar)o1;
                    Calendar cal2 = (Calendar)o2;
                    if (cal1.before(cal2)) {
                        return 1;
                    }
                    if (cal1.after(cal2)) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        return tmList;
    }

    private Calendar getCurrentTime(int period) {
        if (period == 1) {
            Calendar car = Calendar.getInstance();
            int min = car.get(12);
            if (min >= 45) {
                min = 45;
            } else if (min >= 30) {
                min = 30;
            } else if (min >= 15) {
                min = 15;
            } else if (min >= 0) {
                min = 0;
            }
            car.set(12, min);
            car.set(13, 0);
            return car;
        }
        Calendar car = Calendar.getInstance();
        car.add(10, -24);
        return car;
    }

    public boolean isNeedOperationlog() {
        return true;
    }
}

