/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse;

import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMonObjID;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse.TEHisPfmRecord;
import java.io.Serializable;
import java.util.Comparator;

public class TEHisPfmComparator
implements Comparator,
Serializable {
    private static final long serialVersionUID = -908367249092894135L;
    private static final int DEFAULT_VALUE = -1;
    private static final int MONITOR_OBJECT = 1;
    private static final int PE_NAME = 2;
    private static final int LOCATION = 3;
    private static final int DIRECTION = 4;
    private static final int START_TIME = 6;
    private static final int PE_VALUE = 7;
    private static final int VALIDITY = 8;
    private int sortby = 0;
    private int colSort = -1;

    public void setSortBy(int sortby) {
        this.sortby = sortby;
    }

    public int getSortBy() {
        return this.sortby;
    }

    public void setcolSort(int colSort) {
        this.colSort = colSort;
    }

    public int getColSort() {
        return this.colSort;
    }

    public int compare(Object o1, Object o2) {
        TEHisPfmRecord obj1 = (TEHisPfmRecord)o1;
        TEHisPfmRecord obj2 = (TEHisPfmRecord)o2;
        switch (this.colSort) {
            case -1: {
                return -1;
            }
            case 1: {
                return this.pfmMonitorObjCompare(obj1, obj2);
            }
            case 2: {
                return this.pfmPeNameCompare(obj1, obj2);
            }
            case 3: {
                return this.pfmLocationCompare(obj1, obj2);
            }
            case 4: {
                return this.pfmDirectionCompare(obj1, obj2);
            }
            case 6: {
                return this.pfmStartTimeCompare(obj1, obj2);
            }
            case 7: {
                return this.pfmPeValueCompare(obj1, obj2);
            }
            case 8: {
                return this.pfmValidityCompare(obj1, obj2);
            }
        }
        return -1;
    }

    private int pfmValidityCompare(TEHisPfmRecord obj1, TEHisPfmRecord obj2) {
        String s1 = obj1.getValidity();
        String s2 = obj2.getValidity();
        if (this.sortby == 0) {
            return s1.compareTo(s2);
        }
        return s2.compareTo(s1);
    }

    private int pfmDirectionCompare(TEHisPfmRecord obj1, TEHisPfmRecord obj2) {
        if (this.sortby == 0) {
            return obj1.getDirection().compareTo(obj2.getDirection());
        }
        return obj2.getDirection().compareTo(obj1.getDirection());
    }

    private int pfmLocationCompare(TEHisPfmRecord obj1, TEHisPfmRecord obj2) {
        if (this.sortby == 0) {
            return obj1.getLocation().compareTo(obj2.getLocation());
        }
        return obj2.getLocation().compareTo(obj1.getLocation());
    }

    private int pfmMonitorObjCompare(TEHisPfmRecord obj1, TEHisPfmRecord obj2) {
        if (this.sortby == 0) {
            return this.monObjCompare(obj1, obj2);
        }
        return this.monObjCompare(obj2, obj1);
    }

    private int monObjCompare(TEHisPfmRecord obj1, TEHisPfmRecord obj2) {
        TETL1PfmMonObjID tEPfmMonObjID1 = obj1.getPfmmonobj();
        TETL1PfmMonObjID tEPfmMonObjID2 = obj2.getPfmmonobj();
        if (tEPfmMonObjID1.m_usPortID == tEPfmMonObjID2.m_usPortID) {
            if (tEPfmMonObjID1.m_usFBType == tEPfmMonObjID2.m_usFBType) {
                return tEPfmMonObjID1.m_usPathID - tEPfmMonObjID2.m_usPathID;
            }
            return tEPfmMonObjID1.m_usFBType - tEPfmMonObjID2.m_usFBType;
        }
        return tEPfmMonObjID1.m_usPortID - tEPfmMonObjID2.m_usPortID;
    }

    private int pfmStartTimeCompare(TEHisPfmRecord obj1, TEHisPfmRecord obj2) {
        long s1 = obj1.getStartCal().getTimeInMillis();
        long s2 = obj2.getStartCal().getTimeInMillis();
        if (this.sortby == 0) {
            return Long.valueOf(s1).compareTo(s2);
        }
        return Long.valueOf(s2).compareTo(s1);
    }

    private int pfmPeNameCompare(TEHisPfmRecord obj1, TEHisPfmRecord obj2) {
        String s1 = obj1.getPeName();
        String s2 = obj2.getPeName();
        if (this.sortby == 0) {
            return s1.compareTo(s2);
        }
        return s2.compareTo(s1);
    }

    private int pfmPeValueCompare(TEHisPfmRecord obj1, TEHisPfmRecord obj2) {
        if (this.sortby == 0) {
            return new Double(obj1.getPeValue()).compareTo(new Double(obj2.getPeValue()));
        }
        return new Double(obj2.getPeValue()).compareTo(new Double(obj1.getPeValue()));
    }
}

