/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nemgr.tl1necommon.performance.TEPfmUtility;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmCPEvent;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmConfigDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMonObjID;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse.BERConvertQValueClass;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse.TECurPfmFilter;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse.TECurPfmRecord;
import com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse.TECurrentPfmComparator;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1PfmBsEvent;
import com.huawei.nglct.tl1.nemanager.TETL1PfmEventsDataLoader;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

public class TECurrentPfmDataBean
extends TETL1NEExplorerBean {
    private TEResourceUtil res = null;
    private static ArrayList pfmEventList = new ArrayList();
    private static final String SORT_BY_COL = "sortParam";
    private static final String SORT_BY_PARAM = "sortby";
    private static final String SORT_BY_ASC = "asc";
    private static final String SORT_BY_DES = "des";
    private String sortby = "asc";
    private int sortCol = 1;
    ArrayList pfmMonObjIDs = new ArrayList();
    ArrayList eventList = new ArrayList();
    private int neID = 0;
    private int slotID = 0;
    private boolean ShowZeroData = false;
    private TETL1PfmMonObjID pfmmonobj = null;
    TECurPfmFilter filter = new TECurPfmFilter();
    private HashMap pmfDataMap = null;
    private static Datainterface output = null;
    private boolean isFalse = false;
    private boolean isTrue = false;
    private TETL1NE neObj = null;
    private int boardType = -1;
    private String monObjStruct = "";
    private Calendar neTimeforZero = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        this.pfmmonobj = new TETL1PfmMonObjID();
        this.filter = new TECurPfmFilter();
        this.subfunc = subFunc;
        this.cloneTL1OperationList.clear();
        this.neObj = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        this.pmfDataMap = TETL1PfmEventsDataLoader.getInstance().getEventMap();
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        if (null != rowParams[0].getParam("filename")) {
            StringBuffer filePath = new StringBuffer();
            filePath.append(TEPathManager.RESOURCE_PROFILE_PATH).append("performance").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
            this.res = TEGetFilePath.getResource((int)this.neID, (StringBuffer)filePath);
            rowParams = memeryData.getBussinessParams().getRowParams();
            int len = rowParams.length;
            for (int i = 0; i < len; ++i) {
                String peName;
                Param param = rowParams[i].getParam("period");
                String value = param.getValue();
                if ("1".equals(value)) {
                    param.setValue(this.res.getString("minute") + " ");
                }
                if ("2".equals(value)) {
                    param.setValue(this.res.getString("hour") + " ");
                }
                if ((peName = rowParams[i].getParam("peName").getValue()).equals("FEC-AFTCOR-ER(BER)") || peName.equals("FEC-BEFCOR-ER(BER)")) continue;
                param = rowParams[i].getParam("peValue");
                value = param.getValue();
                int index = value.indexOf(".");
                if (index > value.length() - 3) {
                    param.setValue(value + "0");
                }
                if (value.length() - index <= 3) continue;
                param.setValue(value.substring(0, index + 3));
            }
            return memeryData;
        }
        pfmEventList.clear();
        output = new Datainterface();
        PageParams pageParams = inputData.getPageParams();
        int size = pageParams.getParamCount();
        for (int i = 0; i < size; ++i) {
            if (pageParams.getParam(i).getName().equals(SORT_BY_PARAM)) {
                this.sortby = pageParams.getParam(i).getValue();
                continue;
            }
            if (!pageParams.getParam(i).getName().equals(SORT_BY_COL)) continue;
            this.sortCol = Integer.valueOf(pageParams.getParam(i).getValue());
        }
        this.convertValue(inputData);
        this.filter.setPfmmonobj(this.pfmmonobj);
        if (this.pfmmonobj.m_usPortID == -2) {
            this.pfmMonObjIDs.add(this.pfmmonobj);
            this.filter.setFb(false);
        } else {
            this.filter.setFb(true);
        }
        output = this.queryCurrentPfmData(this.neID, this.pfmmonobj, this.filter);
        if (output.getErrorMessage() == null) {
            output.setErrorMessage(new ErrorMessage());
            if (this.isTrue && !this.isFalse) {
                output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
            } else if (this.isTrue && this.isFalse) {
                output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)1));
            } else {
                output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)2));
            }
        }
        if (this.isNeedOperationlog()) {
            super.writeLog(this.neID, subFunc, user, ipAddress, this.cloneTL1OperationList);
        }
        return output;
    }

    private void convertValue(Datainterface inputData) {
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        int len = rParams[0].getParam().length;
        for (int j = 0; j < len; ++j) {
            Param[] params = rParams[0].getParam();
            Param param = params[j];
            String value = param.getValue();
            if (TEPfmUtility.validateParam(param, "neID")) {
                this.pfmmonobj.m_ulNEID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "slotID")) {
                this.pfmmonobj.m_usSlotID = this.slotID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "fbType")) {
                this.pfmmonobj.m_usFBType = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "portID")) {
                this.pfmmonobj.m_usPortID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "pathID")) {
                this.pfmmonobj.m_usPathID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "period")) {
                this.filter.setPeriodList(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "mainType")) {
                this.filter.setMainTypeList(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "extType")) {
                this.filter.setExtTypeList(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "subType")) {
                this.filter.setSubTypeList(value);
                continue;
            }
            if (TEPfmUtility.validateParam(param, "ZeroData")) {
                this.ShowZeroData = value.equalsIgnoreCase("true");
                if (!this.ShowZeroData) continue;
                this.TIME_OUT = 30;
                continue;
            }
            if (!TEPfmUtility.validateParam(param, "ObjListStr")) continue;
            this.monObjStruct = value;
        }
    }

    public Datainterface queryCurrentPfmData(int neID, TETL1PfmMonObjID pfmmonobj, TECurPfmFilter filter) {
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        this.boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neID, this.slotID);
        ArrayList pfmMonObjID = TEPfmUtility.constructPfmMonObj(this.monObjStruct);
        this.eventList = TETL1PfmConfigDataMgr.getInstance().getBoardSupportPfmIDList(this.boardType);
        if (pfmmonobj.m_usPortID == -2) {
            int size = pfmMonObjID.size();
            for (int i = 0; i < size; ++i) {
                TETL1PfmMonObjID pfmMonObj = (TETL1PfmMonObjID)pfmMonObjID.get(i);
                this.pfmMonObjIDs.add(pfmMonObj);
                ArrayList operationList = this.createQueryCurPfmDataRequest(pfmMonObj, filter);
                int result = this.sendMessage(neID, operationList);
                if (result != 0) {
                    output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                    this.isFalse = true;
                    return output;
                }
                this.processCurPfmOperationReturn(neID, outputData, operationList, pfmMonObj, filter);
            }
        } else {
            ArrayList operationList = this.createQueryCurPfmDataRequest(pfmmonobj, filter);
            int result = this.sendMessage(neID, operationList);
            if (result == 0) {
                this.processCurPfmOperationReturn(neID, outputData, operationList, pfmmonobj, filter);
            } else {
                output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                this.isFalse = true;
                return output;
            }
        }
        TECurrentPfmComparator pfmComparator = new TECurrentPfmComparator();
        if (this.sortby.equalsIgnoreCase(SORT_BY_DES)) {
            pfmComparator.setSortBy(1);
            pfmComparator.setcolSort(this.sortCol);
        } else {
            pfmComparator.setSortBy(0);
            pfmComparator.setcolSort(this.sortCol);
        }
        if (this.ShowZeroData) {
            this.addZeroData();
        }
        Collections.sort(pfmEventList, pfmComparator);
        RowParams[] rowparams = this.convertPfmDataToRowData(neID, pfmEventList);
        for (int k = 0; k < rowparams.length; ++k) {
            outputData.getBussinessParams().addRowParams(rowparams[k]);
        }
        return outputData;
    }

    private void processCurPfmOperationReturn(int neID, Datainterface outputData, ArrayList operationlist, TETL1PfmMonObjID pfmmonobj, TECurPfmFilter filter) {
        TL1Operation operation = (TL1Operation)operationlist.get(0);
        Date date = operation.getDate();
        int size = operation.getOutMsgCount();
        if (size == 0) {
            this.isTrue = true;
        }
        for (int i = 0; i < size; ++i) {
            OutMsg output = operation.getOutMsg(i);
            if (output.getFault().getCompletionCode() != 0) {
                this.isFalse = true;
                operation.addCmdFault(output.getFault());
                RowErrors rowerror = TEPfmUtility.handleRowError(output, this.neObj.getNEName());
                RowParams errrowparams = new RowParams();
                errrowparams.addRowErrors(rowerror);
                outputData.getBussinessParams().addRowParams(errrowparams);
                break;
            }
            this.isTrue = true;
            TECurPfmRecord eventRecord = this.convertCurPfmDataFromNE(neID, output, filter, date);
            if (eventRecord == null || eventRecord.peid == -1) continue;
            pfmEventList.add(eventRecord);
        }
        this.cloneTL1OperationList.add(operation.clone());
    }

    private ArrayList createQueryCurPfmDataRequest(TETL1PfmMonObjID pfmmonobj1, TECurPfmFilter filter) {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            TL1Operation operSour = definitions.getTL1Operation("RTRV-PM");
            TL1Operation tl1oper = (TL1Operation)operSour.clone();
            if (pfmmonobj1.mod2Name.equals("")) {
                TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
                String mod2 = fbDesc.getMOD2(pfmmonobj1.m_usFBType);
                if (mod2 == null || mod2.equals("")) {
                    tl1oper.setMod2("");
                } else {
                    tl1oper.setMod2(mod2);
                }
            } else {
                tl1oper.setMod2(pfmmonobj1.mod2Name);
            }
            String name = tl1oper.getCmdCode() + "-" + tl1oper.getMod1() + "-" + tl1oper.getMod2();
            tl1oper.setName(name);
            InMsg inputMsg = tl1oper.getInMsg();
            StagBlock stagblock = inputMsg.getStagBlock();
            AID aid = stagblock.getAID();
            Part aidPart = aid.getPart(0);
            String newAid = TEPfmUtility.getAIDFromalmFB(this.neID, this.slotID, pfmmonobj1);
            aidPart.setValue(newAid);
            MsgBlock msgblock = inputMsg.getMsgBlock();
            DataBlock dataBlock = null;
            Part part1 = null;
            int len = msgblock.getDataBlockCount();
            for (int j = 0; j < len; ++j) {
                dataBlock = msgblock.getDataBlock(j);
                int length = dataBlock.getPartCount();
                for (int k = 0; k < length; ++k) {
                    part1 = dataBlock.getPart(k);
                    this.convertPartValue(part1, pfmmonobj1, filter);
                }
            }
            operationList.add(tl1oper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TECurrentPfmDataBean.createQueryCurPfmDataRequest() fail!", (Throwable)e);
        }
        return operationList;
    }

    private void convertPartValue(Part part, TETL1PfmMonObjID pfmmonobj2, TECurPfmFilter filter2) {
        if (part.getName().equalsIgnoreCase("TMPER")) {
            String tmper = filter2.getPeriodList();
            if (Integer.parseInt(tmper) == 1) {
                part.setValue("15-MIN");
            } else {
                part.setValue("1-DAY");
            }
        } else if (part.getName().equalsIgnoreCase("monlev")) {
            if (this.ShowZeroData) {
                part.setValue("0-UP");
            } else {
                part.setValue("");
            }
        } else {
            part.setValue("");
        }
    }

    private TECurPfmRecord convertCurPfmDataFromNE(int neID, OutMsg output, TECurPfmFilter curfilter, Date date) {
        HashMap partMap = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
        TECurPfmRecord recordCur = new TECurPfmRecord();
        String aidType = "";
        String location = "";
        String direction = "";
        String startDate = "";
        String startTime = "";
        Part part = null;
        part = (Part)partMap.get("AID");
        if (part.getValue() == null) {
            return recordCur;
        }
        String aid = part.getValue();
        int slotID = TETL1CommonUtil.getNMSlotStr((String)aid, (int)neID);
        recordCur.pfmmonobj.m_ulNEID = neID;
        recordCur.pfmmonobj.m_usSlotID = slotID;
        int portID = TETL1CommonUtil.getNMPortNOFromAidStruct((String)aid, (int)neID);
        int pathID = TETL1CommonUtil.getPathIDFromAidStruct((String)aid, (int)neID);
        if (portID == -1) {
            portID = 0;
        }
        if (pathID == -1) {
            pathID = 0;
        }
        recordCur.pfmmonobj.m_usPortID = portID;
        recordCur.pfmmonobj.m_usPathID = pathID;
        part = (Part)partMap.get("AIDTYPE");
        aidType = part.getValue();
        part = (Part)partMap.get("LOCN");
        location = part.getValue();
        part = (Part)partMap.get("DIRN");
        direction = part.getValue();
        part = (Part)partMap.get("MONTYPE");
        TETL1PfmBsEvent event = TEPfmUtility.getPfmDataFromStatic(aidType, TETL1FaultUtil.getTL1AlarmLocation((String)location), TETL1FaultUtil.getTL1AlarmDirection((String)direction), part.getValue());
        if (event == null) {
            return recordCur;
        }
        recordCur.peid = event.getEventID();
        recordCur.peName = part.getValue() + "(" + event.getUnitName() + ")";
        recordCur.location = TETL1FaultUtil.converAlarmLocation((String)location);
        recordCur.direction = TETL1FaultUtil.convertAlarmDirection((String)direction);
        recordCur.pfmmonobj.m_usFBType = event.getFbType();
        recordCur.pfmmonobj.mod2Name = aidType;
        part = (Part)partMap.get("TMPER");
        recordCur.period = part.getValue();
        part = (Part)partMap.get("MONDAT");
        startDate = part.getValue();
        String[] strdate = startDate.split("-");
        int month = Integer.parseInt(strdate[0]);
        int day = Integer.parseInt(strdate[1]);
        part = (Part)partMap.get("MONTM");
        startTime = part.getValue();
        String[] strtime = startTime.split("-");
        int hour = Integer.parseInt(strtime[0]);
        int minute = Integer.parseInt(strtime[1]);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        Calendar calnew = Calendar.getInstance();
        calnew.set(year, month - 1, day, hour, minute, 0);
        recordCur.startTime = TEDateUtils.calendarToStr((Calendar)calnew);
        recordCur.startCal = calnew;
        recordCur.setLocalTime(true);
        part = (Part)partMap.get("MONVAL");
        String value = part.getValue();
        recordCur.peValue = Double.parseDouble(value);
        part = (Part)partMap.get("VLDTY");
        recordCur.validity = part.getValue().equals("VALID") ? "Valid" : "Invalid";
        if (curfilter.filter(event, recordCur, this.pfmMonObjIDs, this.eventList, true)) {
            return recordCur;
        }
        return null;
    }

    public RowParams[] convertPfmDataToRowData(int neID, ArrayList eventList) {
        RowParams[] rowparams = new RowParams[eventList.size()];
        int size = eventList.size();
        for (int i = 0; i < size; ++i) {
            TECurPfmRecord record = (TECurPfmRecord)eventList.get(i);
            rowparams[i] = new RowParams();
            rowparams[i].addParam("pfmMonObj", record.pfmmonobj.toString());
            rowparams[i].addParam("peid", String.valueOf(record.peid));
            rowparams[i].addParam("peName", record.peName);
            rowparams[i].addParam("location", record.location);
            rowparams[i].addParam("direction", record.direction);
            rowparams[i].addParam("period", record.period);
            Calendar cal = TEDateUtils.strToCalendar((String)record.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
            if (record.isLocalTime() || record.period.equals("1-DAY")) {
                cal = TEDateUtils.getTL1NMTimeFromNETime((int)neID, (long)cal.getTimeInMillis());
            }
            rowparams[i].addParam("beginTime", String.valueOf(cal.getTimeInMillis()));
            rowparams[i].addParam("peValue", String.valueOf(BERConvertQValueClass.convertQValue(record.peName, record.peValue)));
            rowparams[i].addParam("validity", record.validity);
        }
        return rowparams;
    }

    private void addZeroData() {
        int pfmsize = pfmEventList.size();
        for (int j = 0; j < pfmsize; ++j) {
            TECurPfmRecord curRecord = (TECurPfmRecord)pfmEventList.get(j);
            if (!this.filter.getPeriodList().equals(this.getPeroid(curRecord.period))) continue;
            this.neTimeforZero = curRecord.startCal;
            break;
        }
        ArrayList eventObjList = TETL1PfmConfigDataMgr.getInstance().getBoardSupportPfmIDList(this.boardType, this.pfmmonobj.m_usPortID, this.pfmmonobj.m_usPathID, this.pfmmonobj.m_usFBType);
        ArrayList<TECurPfmRecord> tmpList = new ArrayList<TECurPfmRecord>();
        Date date = new Date();
        TimeZone timezone = TimeZone.getDefault();
        date.setTime(date.getTime() - (long)timezone.getRawOffset());
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        int size = eventObjList.size();
        for (int i = 0; i < size; ++i) {
            TETL1PfmCPEvent cpevent = (TETL1PfmCPEvent)eventObjList.get(i);
            TETL1PfmBsEvent event = (TETL1PfmBsEvent)this.pmfDataMap.get(cpevent.getEventID());
            if (!TEPfmUtility.isCountFB(event.getEventType())) continue;
            boolean flag = true;
            int pfmsize2 = pfmEventList.size();
            for (int j = 0; j < pfmsize2; ++j) {
                TECurPfmRecord curRecord = (TECurPfmRecord)pfmEventList.get(j);
                if (event.getEventID() != curRecord.getPeid() || cpevent.getPortID() != curRecord.pfmmonobj.m_usPortID || cpevent.getPathID() != curRecord.pfmmonobj.m_usPathID || cpevent.getFbType() != curRecord.pfmmonobj.m_usFBType) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            TECurPfmRecord record = new TECurPfmRecord();
            record.peid = event.getEventID();
            record.peName = event.getEventName() + "(" + event.getUnitName() + ")";
            String location = TETL1FaultUtil.getTL1ArarmLocationStr((int)event.getLocation());
            String direction = TETL1FaultUtil.getTL1ArarmDirectionStr((int)event.getDirection());
            record.location = TETL1FaultUtil.converAlarmLocation((String)location);
            record.direction = TETL1FaultUtil.convertAlarmDirection((String)direction);
            record.pfmmonobj.m_ulNEID = this.neID;
            record.pfmmonobj.m_usSlotID = this.slotID;
            record.pfmmonobj.m_usFBType = cpevent.getFbType();
            record.pfmmonobj.m_usPortID = cpevent.getPortID();
            record.pfmmonobj.m_usPathID = cpevent.getPathID();
            record.pfmmonobj.mod2Name = fbDesc.getMOD2(cpevent.getFbType());
            String tmper = this.filter.getPeriodList();
            record.setLocalTime(false);
            if (Integer.parseInt(tmper) == 1) {
                record.period = "15-MIN";
                record.startTime = TEDateUtils.calendarToStr((Calendar)this.getPfm15MinTime(this.neTimeforZero));
                record.startCal = this.getPfm15MinTime(this.neTimeforZero);
            } else {
                record.period = "1-DAY";
                record.startTime = TEDateUtils.calendarToStr((Calendar)this.getPfm24HourTime(this.neTimeforZero));
                record.startCal = this.getPfm24HourTime(this.neTimeforZero);
            }
            record.peValue = 0.0;
            record.validity = "Invalid";
            if (!this.filter.filter(event, record, this.pfmMonObjIDs, this.eventList, false)) continue;
            tmpList.add(record);
        }
        pfmEventList.addAll(tmpList);
    }

    private Calendar getPfm24HourTime(Calendar _cal) {
        Calendar calneTime;
        if (_cal != null) {
            calneTime = TEDateUtils.getTL1NMTimeFromNETime((int)this.neID, (long)_cal.getTimeInMillis());
            int hour = this.neObj.getPmdaytime();
            int localhour = calneTime.get(11);
            int min = calneTime.get(12);
            int sec = calneTime.get(13);
            long timeInMillis = ((localhour * 60 + min) * 60 + sec) * 1000;
            long realHour = hour * 60 * 60 * 1000;
            calneTime.setTimeInMillis(calneTime.getTimeInMillis() - timeInMillis + realHour);
        } else {
            Date date = new Date();
            TimeZone timezone = TimeZone.getDefault();
            date.setTime(date.getTime() - (long)timezone.getRawOffset());
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            String timeZone = this.neObj.getTimeZome();
            String neZone = TEDateUtils.setNEStrToUtcStr((String)timeZone);
            TimeZone zone = TimeZone.getTimeZone(neZone);
            Date dateNe = new Date(cal.getTimeInMillis() + (long)zone.getRawOffset());
            calneTime = Calendar.getInstance();
            calneTime.setTime(dateNe);
            int hour = this.neObj.getPmdaytime();
            int localhour = calneTime.get(11);
            int min = calneTime.get(12);
            int sec = calneTime.get(13);
            long timeInMillis = ((localhour * 60 + min) * 60 + sec) * 1000;
            long realHour = hour * 60 * 60 * 1000;
            calneTime.setTimeInMillis(calneTime.getTimeInMillis() - timeInMillis + realHour + (long)zone.getRawOffset());
        }
        return calneTime;
    }

    private Calendar getPfm15MinTime(Calendar _cal) {
        Calendar cal;
        if (_cal != null) {
            cal = TEDateUtils.getTL1NMTimeFromNETime((int)this.neID, (long)_cal.getTimeInMillis());
        } else {
            Date date = new Date();
            cal = Calendar.getInstance();
            cal.setTime(date);
        }
        int min = cal.get(12);
        int sec = cal.get(13);
        long timeInMillis = 0L;
        if (min >= 0 && min < 15) {
            timeInMillis = min * 60 * 1000 + sec * 1000;
        } else if (min >= 15 && min < 30) {
            timeInMillis = (min - 15) * 60 * 1000 + sec * 1000;
        } else if (min >= 30 && min < 45) {
            timeInMillis = (min - 30) * 60 * 1000 + sec * 1000;
        } else if (min >= 45 && min < 60) {
            timeInMillis = (min - 45) * 60 * 1000 + sec * 1000;
        }
        cal.setTimeInMillis(cal.getTimeInMillis() - timeInMillis);
        return cal;
    }

    public String getPeroid(String nePer) {
        if (nePer.equalsIgnoreCase("1-DAY")) {
            return "2";
        }
        return "1";
    }

    public boolean isNeedOperationlog() {
        return true;
    }
}

