/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.performance.pfmbrowse;

import java.text.DecimalFormat;

public class BERConvertQValueClass {
    private static final double PI = Math.PI;
    public static final String FEC_AFTCOR_ER = "FEC-AFTCOR-ER(BER)";
    public static final String FEC_BEFCOR_ER = "FEC-BEFCOR-ER(BER)";

    public static String convertQValue(String peid, double peValue) {
        String pValue = String.valueOf(peValue);
        if (peid.equals(FEC_BEFCOR_ER)) {
            if (peValue == 0.0) {
                return "0(Q over 18dB)";
            }
            if (peValue > 1.0E-307 && peValue < 0.15) {
                double tmpValue = BERConvertQValueClass.BERConvertQValue(peValue);
                return pValue + "(Q=" + BERConvertQValueClass.formatNumber(tmpValue) + "dB)";
            }
        }
        if (peid.equals(FEC_AFTCOR_ER)) {
            return pValue + "(-)";
        }
        return pValue;
    }

    public static double BERConvertQValue(double m_dBer) {
        double t = 0.0;
        double QTH = 1.0E-4;
        t = Math.sqrt(-2.0 * Math.log(m_dBer));
        double dQ0 = t - (2.307 + 0.2706 * t) / (1.0 + t * (0.9923 + 0.0448 * t));
        double dQn = BERConvertQValueClass.calculate(m_dBer, dQ0);
        int i = 0;
        while (Math.abs(dQ0 - dQn) / dQn > QTH) {
            dQ0 = dQn;
            dQn = BERConvertQValueClass.calculate(m_dBer, dQ0);
            ++i;
        }
        return 20.0 * Math.log10(dQn);
    }

    private static String formatNumber(double pdouble) {
        DecimalFormat dcformat = new DecimalFormat("#.00");
        return dcformat.format(pdouble);
    }

    private static double calculate(double m_dBer, double dQ0) {
        double dQn = Math.sqrt(-2.0 * Math.log(m_dBer * Math.sqrt(Math.PI * 2) * (0.6816901138162093 * dQ0 + Math.sqrt(Math.pow(dQ0, 2.0) + Math.PI * 2) / Math.PI)));
        return dQn;
    }
}

