/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.performance.model;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmCPEvent;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMOD2Struct;
import com.huawei.nglct.tl1.nemanager.TETL1PfmBsEvent;
import com.huawei.nglct.tl1.nemanager.TETL1PfmEventsDataLoader;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.InvalidSyntaxException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TETL1PfmConfigDataMgr {
    private static TETL1PfmConfigDataMgr instance = null;
    private HashMap pfmCPEventMap = new HashMap();
    private HashMap pfmCPFBEventMap = new HashMap();
    private HashMap pmfDataMap = null;

    private TETL1PfmConfigDataMgr() {
        if (this.pfmCPEventMap.isEmpty()) {
            this.parseXML("sonetpfmcpevent");
            this.parseXML("sonetpfmcpevent_MARINE");
            this.parseSupportThrsh();
        }
    }

    public static synchronized TETL1PfmConfigDataMgr getInstance() {
        if (instance == null) {
            instance = new TETL1PfmConfigDataMgr();
        }
        return instance;
    }

    private void parseXML(String filename) {
        StringBuffer tl1Path = new StringBuffer("").append(File.separator).append("nemgr").append(File.separator).append("tl1necommon").append(File.separator).append("conf").append(File.separator).append(filename).append(".xml");
        try {
            this.pmfDataMap = TETL1PfmEventsDataLoader.getInstance().getEventMap();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            InputSource f = new InputSource(TEResourceManager.getURL((String)"com.huawei.weblct.tl1necommon", (String)tl1Path.toString()).openStream());
            sp.parse(f, (DefaultHandler)new PaserPfmHandler());
        }
        catch (SAXException e) {
            TELogFactory.getNormalLogger().error("TETL1PfmConfigDataMgr.parseXML() fail!", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            TELogFactory.getNormalLogger().error("TETL1PfmConfigDataMgr.parseXML() fail!", (Throwable)e);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TETL1PfmConfigDataMgr.parseXML() fail!", (Throwable)e);
        }
        catch (InvalidSyntaxException e) {
            TELogFactory.getNormalLogger().error("TETL1PfmConfigDataMgr.parseXML() fail!", (Throwable)e);
        }
    }

    public ArrayList getPfmCPSupportMOD2(int boardType) {
        ArrayList<Object> fbList = new ArrayList<Object>();
        HashMap map = this.getBoardSupportPfmFB(boardType);
        Object[] obj = map.keySet().toArray();
        int size = obj.length;
        for (int i = 0; i < size; ++i) {
            fbList.add(obj[i]);
        }
        return fbList;
    }

    public ArrayList getPfmEvent(int boardType, int port, int path, int fbtype) {
        ArrayList evtList = this.getBoardSupportPfmIDList(boardType, port, path, fbtype);
        ArrayList<TETL1PfmBsEvent> list = new ArrayList<TETL1PfmBsEvent>();
        int size = evtList.size();
        for (int i = 0; i < size; ++i) {
            Integer evtID = (Integer)evtList.get(i);
            TETL1PfmBsEvent pfmevent = (TETL1PfmBsEvent)this.pmfDataMap.get(evtID);
            if (pfmevent == null) continue;
            list.add(pfmevent);
        }
        return list;
    }

    public HashMap getBoardSupportPfmFB(int boardType) {
        HashMap boardSupportpfmFB = (HashMap)this.pfmCPFBEventMap.get(new Integer(boardType));
        if (boardSupportpfmFB == null) {
            return new HashMap();
        }
        return boardSupportpfmFB;
    }

    public ArrayList getBoardSupportPfmIDList(int boardType) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        ArrayList boardSupportpfm = (ArrayList)this.pfmCPEventMap.get(new Integer(boardType));
        if (boardSupportpfm != null) {
            int size = boardSupportpfm.size();
            for (int i = 0; i < size; ++i) {
                TETL1PfmCPEvent event = (TETL1PfmCPEvent)boardSupportpfm.get(i);
                Integer eventID = event.getEventID();
                if (idList.contains(eventID)) continue;
                idList.add(eventID);
            }
        }
        return idList;
    }

    public HashMap getPfmCPEventMap() {
        return this.pfmCPEventMap;
    }

    public ArrayList getCPSupportEventType(int boardType) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        ArrayList eventList = (ArrayList)this.pfmCPEventMap.get(boardType);
        if (eventList != null) {
            int size = eventList.size();
            for (int i = 0; i < size; ++i) {
                TETL1PfmCPEvent event = (TETL1PfmCPEvent)eventList.get(i);
                TETL1PfmBsEvent pfmevent = (TETL1PfmBsEvent)this.pmfDataMap.get(event.getEventID());
                Integer eventType = pfmevent.getEventType();
                if (list.contains(eventType)) continue;
                list.add(eventType);
            }
        }
        return list;
    }

    public ArrayList getBoardSupportPfmIDList(int boardType, int port, int path, int fbtype) {
        ArrayList<TETL1PfmCPEvent> idList = new ArrayList<TETL1PfmCPEvent>();
        ArrayList boardSupportpfm = (ArrayList)this.pfmCPEventMap.get(boardType);
        if (boardSupportpfm != null) {
            int size = boardSupportpfm.size();
            for (int i = 0; i < size; ++i) {
                TETL1PfmCPEvent event = (TETL1PfmCPEvent)boardSupportpfm.get(i);
                if (port == -2) {
                    idList.add(event);
                    continue;
                }
                if (port != event.getPortID() || path != event.getPathID() || fbtype != event.getFbType()) continue;
                idList.add(event);
            }
        }
        return idList;
    }

    private void parseSupportThrsh() {
        Object[] objarr = this.pfmCPFBEventMap.values().toArray();
        int len = objarr.length;
        for (int i = 0; i < len; ++i) {
            HashMap map = (HashMap)objarr[i];
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                boolean issupport = false;
                Map.Entry entry = it.next();
                TETL1PfmMOD2Struct key = (TETL1PfmMOD2Struct)entry.getKey();
                ArrayList value = (ArrayList)entry.getValue();
                int size = value.size();
                for (int j = 0; j < size; ++j) {
                    TETL1PfmCPEvent pfmCpEvent = (TETL1PfmCPEvent)value.get(j);
                    TETL1PfmBsEvent pfmevent = (TETL1PfmBsEvent)this.pmfDataMap.get(pfmCpEvent.getEventID());
                    if (pfmevent.getMinThr15m() == 0 && pfmevent.getMinThr24h() == 0 && pfmevent.getMaxThr15m() == 0 && pfmevent.getMaxThr24h() == 0 && pfmevent.getDftThr15m() == 0 && pfmevent.getDftThr24h() == 0) continue;
                    issupport = true;
                    break;
                }
                key.setSupportPfmThrs(issupport);
            }
        }
    }

    class PaserPfmHandler
    extends DefaultHandler {
        PaserPfmHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("param")) {
                TETL1PfmMOD2Struct pfmMod2;
                int cpType = Integer.parseInt(attributes.getValue("CPType"));
                int eventID = Integer.parseInt(attributes.getValue("EventID"));
                int fbType = Integer.parseInt(attributes.getValue("FBType"));
                int portID = Integer.parseInt(attributes.getValue("PortID"));
                int pathID = Integer.parseInt(attributes.getValue("PathID"));
                int fbTypeValue = Integer.parseInt(attributes.getValue("FBTypeValue"));
                TETL1PfmCPEvent pmfCPevent = new TETL1PfmCPEvent(cpType, eventID, fbType, portID, pathID, fbTypeValue);
                ArrayList<TETL1PfmCPEvent> pfmList = (ArrayList<TETL1PfmCPEvent>)TETL1PfmConfigDataMgr.this.pfmCPEventMap.get(cpType);
                if (pfmList == null) {
                    pfmList = new ArrayList<TETL1PfmCPEvent>();
                    TETL1PfmConfigDataMgr.this.pfmCPEventMap.put(cpType, pfmList);
                }
                pfmList.add(pmfCPevent);
                HashMap<TETL1PfmMOD2Struct, ArrayList<TETL1PfmCPEvent>> pfmFBMap = (HashMap<TETL1PfmMOD2Struct, ArrayList<TETL1PfmCPEvent>>)TETL1PfmConfigDataMgr.this.pfmCPFBEventMap.get(cpType);
                if (pfmFBMap == null) {
                    pfmFBMap = new HashMap<TETL1PfmMOD2Struct, ArrayList<TETL1PfmCPEvent>>();
                    TETL1PfmConfigDataMgr.this.pfmCPFBEventMap.put(cpType, pfmFBMap);
                }
                if ((pfmMod2 = this.getMod2StructFromEvent(eventID, portID, pathID)) != null) {
                    pfmMod2.setFbType(fbType);
                    ArrayList<TETL1PfmCPEvent> supportList = (ArrayList<TETL1PfmCPEvent>)pfmFBMap.get(pfmMod2);
                    if (supportList == null) {
                        supportList = new ArrayList<TETL1PfmCPEvent>();
                        pfmFBMap.put(pfmMod2, supportList);
                    }
                    supportList.add(pmfCPevent);
                }
            }
        }

        private TETL1PfmMOD2Struct getMod2StructFromEvent(int eventID, int portID, int pathID) {
            TETL1PfmBsEvent pfmevent = (TETL1PfmBsEvent)TETL1PfmConfigDataMgr.this.pmfDataMap.get(eventID);
            if (pfmevent == null) {
                return null;
            }
            int aidType = pfmevent.getFbType();
            TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
            String mod2Name = fbDesc.getMOD2(aidType);
            if (mod2Name.equals("")) {
                return null;
            }
            TETL1PfmMOD2Struct aid = new TETL1PfmMOD2Struct(mod2Name, portID, pathID);
            aid.setAidPreFix(fbDesc.getAIDPrefix(aidType));
            return aid;
        }
    }
}

