/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.performance;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TEPerformanceDataMgr;
import com.huawei.nglct.nelist.model.TESDFuncBlockRecord;
import com.huawei.nglct.nelist.model.performance.TEPerformModel;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMOD2Struct;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMonObjID;
import com.huawei.nglct.ngwdm_pub.TETL1AIDTranslateRuleMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1PfmBsEvent;
import com.huawei.nglct.tl1.nemanager.TETL1PfmEventsDataLoader;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class TEPfmUtility {
    public static final String DELIMITER = "-";
    private static final String TL1_DES_PATH = "conf" + File.separator + "tl1describ.xml";

    public static TEPerformModel getPfmModel(int neid, int slotid) {
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        TEBoard board = ne.getBoard(slotid);
        if (null == board) {
            return null;
        }
        try {
            TEPerformModel model = TEPerformanceDataMgr.getInstance().getPerformModel(board.getBoardType());
            model.setNEID(neid);
            return model;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ArrayList getTokensFromStr(String str) {
        if (null == str || str.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            arrayList.add(tokenizer.nextToken());
        }
        return arrayList;
    }

    public static HashMap getTokenListFromStr(String str) {
        if (null == str || str.length() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            ArrayList tmp = TEPfmUtility.getTokensFromStr(token);
            if (null == tmp || tmp.size() != 2) continue;
            String key = (String)tmp.get(0);
            String value = (String)tmp.get(1);
            map.put(key, value);
        }
        return map;
    }

    public static String getStringFromSequenceOfInt(ArrayList src) {
        if (src != null) {
            StringBuffer result = new StringBuffer();
            int size = src.size();
            for (int i = 0; i < size; ++i) {
                result.append((Integer)src.get(i));
                if (i == size - 1) continue;
                result.append(DELIMITER);
            }
            return result.toString();
        }
        return "";
    }

    public static TETL1PfmBsEvent getPfmBsEvent(int neid, int slotid, int peid) {
        return TETL1PfmEventsDataLoader.getInstance().getTL1PfmBsEvent(neid, peid);
    }

    public static int pfmEid2Qx5Eid(int neid, int slotid, int nmEid) {
        TEPerformModel model = TEPfmUtility.getPfmModel(neid, slotid);
        if (null == model) {
            return nmEid;
        }
        int neEid = model.getNEEvent(nmEid);
        if (neEid > 4096) {
            return neEid;
        }
        return neEid & 0xFF;
    }

    public static int qx5Eid2PfmEid(int neid, int slotid, int neEid) {
        TEPerformModel model = TEPfmUtility.getPfmModel(neid, slotid);
        if (null == model) {
            return neEid;
        }
        int nmEid = model.getNMEventID(neEid);
        int size = model.getEventList().size();
        for (int i = 0; i < size; ++i) {
            Integer tmp = (Integer)model.getEventList().get(i);
            if (tmp != nmEid) continue;
            return nmEid;
        }
        return neEid;
    }

    public static int pfmValue2Qx5Value(int neid, int slotid, double pfmValue, int peid) {
        TETL1PfmBsEvent event = TEPfmUtility.getPfmBsEvent(neid, slotid, peid);
        if ((double)event.getUnit() == 0.1) {
            return (int)(pfmValue * 10.0);
        }
        return (int)pfmValue;
    }

    public static double qx5Value2PfmValue(int neid, int slotid, int qx5Value, int peid) {
        double pfmValue = 0.0;
        if (qx5Value == Integer.MAX_VALUE) {
            return -1.0;
        }
        if (peid == 0) {
            return -1.0;
        }
        if (slotid == 0) {
            return -1.0;
        }
        TETL1PfmBsEvent event = TEPfmUtility.getPfmBsEvent(neid, slotid, peid);
        if (null == event) {
            return -1.0;
        }
        return pfmValue;
    }

    public static double qxValuePfmValue(int neid, int slotid, double qx5Value, int peid) {
        if (qx5Value == 2.147483647E9) {
            return -1.0;
        }
        if (peid == 0) {
            return -1.0;
        }
        if (slotid == 0) {
            return -1.0;
        }
        return qx5Value;
    }

    public static TL1Operation getOperation(int neid, String tl1Des) throws Exception {
        TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.common", (String)TL1_DES_PATH);
        return definitions.getTL1Operation(tl1Des);
    }

    public static TL1Operation getOperation(int neid, int cmdCode) throws Exception {
        TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.common", (String)TL1_DES_PATH);
        return definitions.getTL1Operation(cmdCode);
    }

    public static boolean validatePart(Part part, String name) {
        return part.getName().equalsIgnoreCase(name) && part.getValue() != null;
    }

    public static boolean validateParam(Param param, String name) {
        return param.getName().equalsIgnoreCase(name) && param.getValue().length() > 0;
    }

    public static RowErrors handleRowError(OutMsg output, String errorDesc) {
        String errorCode = output.getFault().getErrCode();
        String errorinfo = output.getFault().getErrDesc();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("monObj", errorDesc);
        rowError.addParam(errorparam);
        return rowError;
    }

    public static TETL1PfmMonObjID convertTL1PfmMonObj(TETL1PfmMOD2Struct mod2Struct, int neID, int slotID) {
        TETL1PfmMonObjID monObjID = new TETL1PfmMonObjID();
        monObjID.m_ulNEID = neID;
        monObjID.mod2Name = mod2Struct.getMod2Name();
        monObjID.m_usSlotID = slotID;
        monObjID.m_usFBType = mod2Struct.getFbType();
        monObjID.m_usPortID = mod2Struct.getPortID();
        monObjID.m_usPathID = mod2Struct.getPathID();
        monObjID.aidPreFix = mod2Struct.getAidPreFix();
        return monObjID;
    }

    public static double qx5ValuePfmValue(int neid, double qx5Value, int peid) {
        double pfmValue = 0.0;
        if (peid == 0) {
            return -1.0;
        }
        TETL1PfmBsEvent event = TEPfmUtility.getPfmBsEvent(neid, 255, peid);
        if (null == event) {
            return -1.0;
        }
        return pfmValue;
    }

    public static int getTL1Location(String locationStr) {
        if (locationStr != null) {
            if (locationStr.equalsIgnoreCase("NEND")) {
                return 1;
            }
            if (locationStr.equalsIgnoreCase("FEND")) {
                return 2;
            }
        }
        return 0;
    }

    public static int getTL1Direction(String directionStr) {
        if (directionStr != null) {
            if (directionStr.equalsIgnoreCase("RCV")) {
                return 1;
            }
            if (directionStr.equalsIgnoreCase("TRMT")) {
                return 2;
            }
        }
        return 0;
    }

    public static TETL1PfmBsEvent getPfmDataFromStatic(String MOD2, int location, int direction, String eventName) {
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        Object[] fbList = fbDesc.getFBRecord().getValues();
        int[] aidTypeArray = new int[12];
        int k = 0;
        int size = fbList.length;
        for (int i = 0; i < size; ++i) {
            TESDFuncBlockRecord fb = (TESDFuncBlockRecord)fbList[i];
            if (!fb.strMOD2.equals(MOD2)) continue;
            aidTypeArray[k] = fb.fbType;
            ++k;
        }
        HashMap pfmDataMap = TETL1PfmEventsDataLoader.getInstance().getEventMap();
        ArrayList<TETL1PfmBsEvent> tempPfmList = new ArrayList<TETL1PfmBsEvent>();
        for (Map.Entry entry : pfmDataMap.entrySet()) {
            TETL1PfmBsEvent tmpData = (TETL1PfmBsEvent)entry.getValue();
            int len = aidTypeArray.length;
            for (int i = 0; i < len; ++i) {
                if (tmpData.getFbType() != aidTypeArray[i] || !tmpData.getEventName().equals(eventName)) continue;
                tempPfmList.add(tmpData);
            }
        }
        int size2 = tempPfmList.size();
        for (int i = 0; i < size2; ++i) {
            TETL1PfmBsEvent pfmData = (TETL1PfmBsEvent)tempPfmList.get(i);
            if (pfmData.getLocation() != location || pfmData.getDirection() != direction) continue;
            return pfmData;
        }
        return null;
    }

    public static ArrayList getPfmEventList(int location, int direction, String eventName) {
        ArrayList<TETL1PfmBsEvent> list = new ArrayList<TETL1PfmBsEvent>();
        HashMap pfmDataMap = TETL1PfmEventsDataLoader.getInstance().getEventMap();
        for (Map.Entry entry : pfmDataMap.entrySet()) {
            TETL1PfmBsEvent tmpData = (TETL1PfmBsEvent)entry.getValue();
            if (!tmpData.getEventName().equals(eventName) || tmpData.getDirection() != direction || tmpData.getLocation() != location) continue;
            list.add(tmpData);
        }
        return list;
    }

    public static String getAIDFromalmFB(int neid, int slotid, TETL1PfmMonObjID fbobj) {
        String neSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)neid, (int)slotid);
        String aidpre = TETL1CommonUtil.getAIDFrefix((int)neid, (int)fbobj.m_usSlotID, (int)fbobj.m_usPortID);
        int portNENo = TETL1CommonUtil.getAIDPortNo((int)neid, (int)fbobj.m_usSlotID, (int)fbobj.m_usPortID);
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        if (aidpre.equals("") && (aidpre = fbobj.aidPreFix).equals("")) {
            aidpre = fbDesc.getAIDPrefix(fbobj.m_usFBType);
        }
        if (fbobj.m_usPortID == 0) {
            return new StringBuffer().append("SLOT").append(DELIMITER).append(neSlot).toString();
        }
        if (fbobj.m_usPathID == 0) {
            return new StringBuffer().append(aidpre).append(DELIMITER).append(neSlot).append(DELIMITER).append(portNENo).toString();
        }
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, fbobj.m_usSlotID);
        String showPath = String.valueOf(fbobj.m_usPathID);
        if (fbobj.m_usPathID > 1200) {
            showPath = TETL1AIDTranslateRuleMgr.getInstance().getTL1Path(boardType, String.valueOf(fbobj.m_usPathID));
        }
        StringBuffer valuePath = new StringBuffer().append(aidpre).append(DELIMITER).append(neSlot).append(DELIMITER).append(portNENo);
        if (!showPath.isEmpty()) {
            valuePath.append(DELIMITER).append(showPath);
        }
        return valuePath.toString();
    }

    public static ArrayList constructPfmMonObj(String strMonObj) {
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        ArrayList<TETL1PfmMonObjID> list = new ArrayList<TETL1PfmMonObjID>();
        for (String monObj : strMonObj.split(",")) {
            String mod2Name;
            String[] objStruct = monObj.split("&");
            if (objStruct.length < 5) continue;
            TETL1PfmMonObjID monObjID = new TETL1PfmMonObjID();
            try {
                monObjID.m_ulNEID = Integer.parseInt(objStruct[0]);
                monObjID.m_usSlotID = Integer.parseInt(objStruct[1]);
                monObjID.m_usPortID = Integer.parseInt(objStruct[2]);
                monObjID.m_usPathID = Integer.parseInt(objStruct[3]);
                monObjID.m_usFBType = Integer.parseInt(objStruct[4]);
            }
            catch (Exception e) {
                continue;
            }
            if (monObjID.m_usPortID == -2) continue;
            monObjID.mod2Name = mod2Name = fbDesc.getMOD2(monObjID.m_usFBType);
            list.add(monObjID);
        }
        return list;
    }

    public static boolean isCountFB(int fbType) {
        boolean bResult = true;
        if (fbType != 30 && fbType != 31 && fbType != 34 && fbType != 6 && fbType != 35 && fbType != 36) {
            bResult = false;
        }
        return bResult;
    }
}

