/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.performance;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.performance.TEPfmUtility;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmConfigDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMOD2Struct;
import com.huawei.nglct.nemgr.tl1necommon.performance.model.TETL1PfmMonObjID;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.Fault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class TEPfmCommonBean
extends TETL1NEExplorerBean {
    private int slotid = -1;
    private static final int GET_MON_OBJ_CODE = 111119;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.slotid = this.getSlotID(inputData);
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        this.outputData = new Datainterface();
        if (subFunc.getCode() != 2101284) {
            this.slotIDList = new HashSet();
            this.slotIDList.add(this.slotid);
            this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList, (Datainterface)this.outputData);
            if (this.aidAndTypeList == null) {
                return this.outputData;
            }
            if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                this.addRTRVPORTError(neid, ne, this.outputData);
                return this.outputData;
            }
        }
        if (subFunc.getCode() == 0x201021 || subFunc.getCode() == 111119) {
            return this.getPfmMonObjIDs();
        }
        if (subFunc.getCode() == 2101283) {
            return this.getPfmTHMonObjIDs();
        }
        if (subFunc.getCode() == 2101284) {
            return this.getCpSupportEventType();
        }
        return null;
    }

    protected void addRTRVPORTError(int neid, TETL1NE ne, Datainterface tempOutput) {
        Object[] slotIDArr = this.slotIDList.toArray();
        int slotID = (Integer)slotIDArr[0];
        Fault fault = this.aidAndTypeList.getFaultInfo(slotID);
        String errorCode = fault.getErrCode();
        String errorinfo = fault.getErrDesc();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        RowErrors errorRowparams = new RowErrors();
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        errorRowparams.setErrorMessage(errorMessage);
        errorparam = new Param("monObj", ne.getNEName());
        errorRowparams.addParam(errorparam);
        RowParams rowparams = new RowParams();
        rowparams.addRowErrors(errorRowparams);
        tempOutput.setBussinessParams(new BussinessParams());
        tempOutput.getBussinessParams().addRowParams(rowparams);
        tempOutput.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
    }

    private Datainterface getPfmMonObjIDs() {
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, this.slotid);
        ArrayList pfmMonObjIDs = TETL1PfmConfigDataMgr.getInstance().getPfmCPSupportMOD2(boardType);
        TETL1PfmMOD2Struct boardStruct = new TETL1PfmMOD2Struct("", -2, 0);
        pfmMonObjIDs.add(0, boardStruct);
        Collections.sort(pfmMonObjIDs);
        int size = pfmMonObjIDs.size();
        for (int i = 0; i < size; ++i) {
            ArrayList allModList;
            TETL1PfmMOD2Struct mod2Struct = (TETL1PfmMOD2Struct)pfmMonObjIDs.get(i);
            if (!TETL1FaultUtil.isSupportODUTCMService((TEAIDAndTypeList)this.aidAndTypeList, (int)this.neid, (int)this.slotid, (int)mod2Struct.getPortID()) && mod2Struct.getMod2Name().indexOf("TCM") != -1) continue;
            TETL1PfmMonObjID monObjID = TEPfmUtility.convertTL1PfmMonObj(mod2Struct, this.neid, this.slotid);
            int portID = monObjID.m_usPortID;
            int pathID = monObjID.m_usPathID;
            if (portID != 0 && (!(allModList = TETL1FaultUtil.getUseableModName((TEAIDAndTypeList)this.aidAndTypeList, (int)this.neid, (int)this.slotid, (int)portID, (int)pathID)).contains(monObjID.mod2Name) || TETL1FaultUtil.isNotSupport52TomODU((TEAIDAndTypeList)this.aidAndTypeList, (int)this.neid, (int)this.slotid, (int)portID, (int)pathID, (String)monObjID.mod2Name))) continue;
            RowParams rowParam = new RowParams();
            Param[] params = monObjID.toRowParams();
            for (int k = 0; k < params.length; ++k) {
                rowParam.addParam(params[k]);
            }
            outputData.getBussinessParams().addRowParams(rowParam);
        }
        outputData.setErrorMessage(new ErrorMessage());
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        return outputData;
    }

    private Datainterface getPfmTHMonObjIDs() {
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, this.slotid);
        ArrayList pfmMonObjIDs = TETL1PfmConfigDataMgr.getInstance().getPfmCPSupportMOD2(boardType);
        TETL1PfmMOD2Struct boardStruct = new TETL1PfmMOD2Struct("", -2, 0);
        pfmMonObjIDs.add(0, boardStruct);
        Collections.sort(pfmMonObjIDs);
        int size = pfmMonObjIDs.size();
        for (int i = 0; i < size; ++i) {
            ArrayList allModList;
            TETL1PfmMOD2Struct mod2Struct = (TETL1PfmMOD2Struct)pfmMonObjIDs.get(i);
            if (!mod2Struct.isSupportPfmThrs() || !TETL1FaultUtil.isSupportODUTCMService((TEAIDAndTypeList)this.aidAndTypeList, (int)this.neid, (int)this.slotid, (int)mod2Struct.getPortID()) && mod2Struct.getMod2Name().indexOf("TCM") != -1) continue;
            TETL1PfmMonObjID monObjID = TEPfmUtility.convertTL1PfmMonObj(mod2Struct, this.neid, this.slotid);
            if (0 == monObjID.m_usPortID && 0 == monObjID.m_usPathID) continue;
            int portID = monObjID.m_usPortID;
            int pathID = monObjID.m_usPathID;
            if (portID != 0 && (!(allModList = TETL1FaultUtil.getUseableModName((TEAIDAndTypeList)this.aidAndTypeList, (int)this.neid, (int)this.slotid, (int)portID, (int)pathID)).contains(monObjID.mod2Name) || TETL1FaultUtil.isNotSupport52TomODU((TEAIDAndTypeList)this.aidAndTypeList, (int)this.neid, (int)this.slotid, (int)portID, (int)pathID, (String)monObjID.mod2Name))) continue;
            RowParams rowParam = new RowParams();
            Param[] params = monObjID.toRowParams();
            for (int k = 0; k < params.length; ++k) {
                rowParam.addParam(params[k]);
            }
            outputData.getBussinessParams().addRowParams(rowParam);
        }
        outputData.setErrorMessage(new ErrorMessage());
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        return outputData;
    }

    private Datainterface getCpSupportEventType() {
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, this.slotid);
        ArrayList cpSupPfmEventList = TETL1PfmConfigDataMgr.getInstance().getCPSupportEventType(boardType);
        RowParams rowParam = new RowParams();
        rowParam.addParam("fbType", String.valueOf(0));
        rowParam.addParam("eventType", TEPfmUtility.getStringFromSequenceOfInt(cpSupPfmEventList));
        outputData.getBussinessParams().addRowParams(rowParam);
        outputData.setErrorMessage(new ErrorMessage());
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        return outputData;
    }

    private int getSlotID(Datainterface inputData) {
        Param[] paramArr = inputData.getBussinessParams().getRowParams(0).getParam();
        int tmp = -1;
        int size = paramArr.length;
        for (int i = 0; i < size; ++i) {
            if (!paramArr[i].getName().equalsIgnoreCase("slotid")) continue;
            try {
                tmp = Integer.parseInt(paramArr[i].getValue());
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Get slotid fail:\n", (Throwable)e);
                return -1;
            }
            return tmp;
        }
        return -1;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

