/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.nesecurity.neusermgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;

public class TETL1ModifyUserPwdBean
extends TETL1NEExplorerBean {
    private TEResourceUtil res = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.curUser = user;
            this.curIpAddress = ipAddress;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            TENE ne = TENEListUtils.getNEObj((int)neid);
            BussinessParams businessparams = inputData.getBussinessParams();
            RowParams rowparams = businessparams.getRowParams(0);
            String uid = rowparams.getParam("UID").getValue();
            byte[] oldPwd = ne.getCurUserPassword();
            if (ne.getCurUser().equals(uid)) {
                ArrayList tl1OperList = this.getEdPwdOperList(oldPwd, rowparams);
                if (null == tl1OperList || tl1OperList.size() == 0) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                    return this.outputData;
                }
                int result = this.sendMessage(neid, tl1OperList);
                if (result == 0) {
                    this.handleMessage(neid, tl1OperList, subFunc, this.getFilterErrorCodeList());
                    byte[] value = EncryptUtils.decrypt((String)rowparams.getParam("NEWPID").getValue());
                    ne.setCurUserPassword(value);
                    EncryptUtils.clearByte((byte[])value);
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                }
                this.printLog();
            } else {
                this.outputData = super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
            }
            oldPwd = null;
            return this.outputData;
        }
        catch (Exception e) {
            return null;
        }
    }

    private ArrayList getEdPwdOperList(byte[] oldPwd, RowParams rowParams) {
        try {
            this.cloneTL1OperationList.clear();
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
            TL1Operation tl1Operation = tl1definitions.getTL1Operation("ED-PID");
            InMsg inputMsg = tl1Operation.getInMsg();
            this.fillMsgBlock(rowParams, inputMsg.getMsgBlock());
            ArrayList<TL1Operation> tl1List = new ArrayList<TL1Operation>();
            tl1List.add(tl1Operation);
            this.cloneTL1OperationList.add(tl1Operation.clone());
            return tl1List;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        TENE ne = TENEListUtils.getNEObj((int)this.neid);
        byte[] oldPwd = ne.getCurUserPassword();
        if (part.getName().equalsIgnoreCase("PID")) {
            part.setValue(EncryptUtils.encryptAESByte2Str((byte[])oldPwd));
            EncryptUtils.clearByte((byte[])oldPwd);
            return true;
        }
        if (part.getName().equalsIgnoreCase("NEWPID")) {
            super.convertPartValue(part, rowparams);
            byte[] value = EncryptUtils.decrypt((String)part.getValue());
            part.setValue(EncryptUtils.convertByte2Str((byte[])value));
            EncryptUtils.clearByte((byte[])value);
            return true;
        }
        return super.convertPartValue(part, rowparams);
    }

    public void writeLog(int neid, SubFunc subfunc, String user, String ipAddress, ArrayList tl1OperList) {
        try {
            int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo_Mody = new TELogInfo();
            loginfo_Mody.setCmdID(subfunc.getCode());
            loginfo_Mody.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                loginfo_Mody.setUserID(userID);
            }
            loginfo_Mody.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo_Mody.setOperateName(subfunc.getSubFuncDes(neid));
            loginfo_Mody.setOperateObject("");
            loginfo_Mody.setOperateDesc(this.addProtectionToString(this.inputData));
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                loginfo_Mody.setOperateObject(String.valueOf(neid));
            } else {
                loginfo_Mody.setOperateObject(neObj.getNEName());
            }
            if (errorCode == 0) {
                loginfo_Mody.setResult(0);
                loginfo_Mody.setErrCode(0);
                loginfo_Mody.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo_Mody);
            } else if (errorCode == 2 || errorCode == 1) {
                loginfo_Mody.setResult(errorCode);
                if (null == this.outputData.getBussinessParams() || this.outputData.getBussinessParams().getRowParamsCount() == 0) {
                    loginfo_Mody.setErrCode(errorCode);
                }
                int len = this.outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    loginfo_Mody.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    loginfo_Mody.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(loginfo_Mody);
                    break;
                }
            } else {
                loginfo_Mody.setResult(2);
                loginfo_Mody.setErrCode(errorCode);
                loginfo_Mody.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo_Mody);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String addProtectionToString(Datainterface inputData) {
        String des = "";
        StringBuffer strBuf = new StringBuffer();
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"neId").getValue());
        String username = params[0].getValue();
        StringBuffer filePath = new StringBuffer();
        filePath.append("tl1necommon").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("nesecurity").append(File.separator).append("neusermgr").append(File.separator).append("neusermanage_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neId, (StringBuffer)filePath);
        des = this.res.getString("neuser") + username;
        strBuf.append(des);
        return strBuf.toString();
    }
}

