/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.nesecurity;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TESplitPageBean;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1DataConverter;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TEQueryNElog
extends TETL1NEExplorerBean {
    private static final int TIME_OUT = 900;
    private static final String SUCCESSCODE = "0";
    private final HashMap allLogUserMap = new HashMap();
    private static Datainterface outputData = null;
    private String offset = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        if (memeryData != null && SUCCESSCODE.equals(memeryData.getErrorMessage().getErrorcode())) {
            int size = inputData.getPageParams().getParamCount();
            for (int i = 0; i < size; ++i) {
                if (!inputData.getPageParams().getParam(i).getValue().equals("neName")) continue;
                return memeryData;
            }
            TESplitPageBean.sortData((Datainterface)memeryData, (SubFunc)subFunc, (PageParams)inputData.getPageParams());
            return memeryData;
        }
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            if (null != rParams[0].getParam("filename")) {
                return outputData;
            }
            this.offset = inputData.getBussinessParams().getRowParams(0).getParam("offset").getValue();
            outputData = new Datainterface();
            this.tl1OperList = this.getTL1Operation(neid, subFunc, inputData, memeryData);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, (List)this.tl1OperList, 900);
            if (result.retCode != 0) {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)result.retCode));
            } else {
                this.handleMessage(neid, this.tl1OperList, subFunc, this.getFilterErrorCodeList(), inputData);
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return outputData;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList, Datainterface inputData) {
        this.convertToDatainterface(neid, subfunc, tl1OperList, filterErrorCodeList, inputData);
    }

    protected Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList tl1OperList, ArrayList filterErrorCodeList, Datainterface inputData) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        int tl1OperSize = tl1OperList.size();
        TL1Operation errtl1oper = (TL1Operation)tl1OperList.get(0);
        String specilerr = errtl1oper.getOutMsg(0).getFault().getErrDesc();
        int specilerrcode = errtl1oper.getOutMsg(0).getFault().getCompletionCode();
        ArrayList errorData = null;
        RowParams rowparams = null;
        outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        if (!specilerr.equals("") && specilerrcode != 0) {
            errorData = this.joinTL1Operation(neid, subfunc, tl1OperList, filterErrorCodeList);
            if (0 == tl1OperList.size()) {
                if (null != errorData && 0 != errorData.size()) {
                    rowparams = new RowParams();
                    int sizei = errorData.size();
                    for (int ii = 0; ii < sizei; ++ii) {
                        rowparams.addRowErrors((RowErrors)errorData.get(ii));
                    }
                    outputData.getBussinessParams().addRowParams(rowparams);
                    outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
                } else {
                    rowparams = new RowParams();
                    outputData.getBussinessParams().addRowParams(rowparams);
                    outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                }
                return outputData;
            }
        }
        TL1Operation tl1Operation = null;
        InMsg input = null;
        OutMsg output = null;
        this.cloneTL1OperationList.clear();
        int len = tl1OperList.size();
        for (int i = 0; i < len; ++i) {
            tl1Operation = (TL1Operation)tl1OperList.get(i);
            input = tl1Operation.getInMsg();
            List commentList = tl1Operation.getCommentList();
            int size = tl1Operation.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                output = tl1Operation.getOutMsg(row);
                rowparams = new RowParams();
                output.getFault().setErrDesc((String)commentList.get(row));
                if (!this.handleRowData(neid, subfunc, rowparams, input, output, inputData)) continue;
                if (null != errorData && 0 != errorData.size()) {
                    rowparams = new RowParams();
                    int sizei = errorData.size();
                    for (int ii = 0; ii < sizei; ++ii) {
                        rowparams.addRowErrors((RowErrors)errorData.get(ii));
                    }
                }
                outputData.getBussinessParams().addRowParams(rowparams);
            }
            this.cloneTL1OperationList.add(tl1Operation.clone());
        }
        Set nameset = this.allLogUserMap.entrySet();
        Iterator nameit = nameset.iterator();
        StringBuffer namesetit = new StringBuffer();
        while (nameit.hasNext()) {
            String tempnext = nameit.next().toString();
            String[] temparray = tempnext.split("=");
            namesetit.append(temparray[0] + ":");
        }
        if (namesetit.length() != 0) {
            outputData.getBussinessParams().getRowParams(0).getParam("allloguser").setValue(namesetit.toString());
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (null == errorData || 0 == errorData.size()) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (errorData.size() >= tl1OperSize) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return outputData;
    }

    protected boolean handleRowData(int neid, SubFunc subfunc, RowParams rowparams, InMsg input, OutMsg output, Datainterface inputData) {
        Part tmpPart = null;
        HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
        String faultstr = output.getFault().getErrDesc();
        if (!this.isFilterRowData(faultstr, input, inputData)) {
            return false;
        }
        Param param = null;
        int len = subfunc.getOutput().getParamCount();
        for (int col = 0; col < len; ++col) {
            param = new Param(subfunc.getOutput().getParam(col).getName(), "");
            if ("neid".equalsIgnoreCase(param.getName())) {
                param.setValue(String.valueOf(neid));
            }
            if (null != input) {
                tmpPart = input.getPart(param.getName());
            }
            if (null != tmpPart) {
                param.setValue(tmpPart.getValue());
            }
            this.convertParamValue(param, partmap, input, output);
            rowparams.addParam(param);
        }
        TETL1DataConverter.addReturnParam((int)neid, (RowParams)rowparams);
        return true;
    }

    protected boolean isFilterRowData(String faultcode, InMsg input, Datainterface inputData) {
        boolean logflag = false;
        TENE ne = TENEListUtils.getNEObj((int)this.neid);
        String filterStartDate = inputData.getBussinessParams().getRowParams(0).getParam("starttime").getValue();
        long startTime = TEDateUtils.strToCalendar((String)filterStartDate, (String)TimeZoneDateBean.getTimeConvertFormat()).getTimeInMillis() + Long.parseLong(this.offset);
        Calendar startTimeCal = TEDateUtils.setUtcDateToNMTime((long)startTime);
        String filterEndDate = inputData.getBussinessParams().getRowParams(0).getParam("endtime").getValue();
        long endTime = TEDateUtils.strToCalendar((String)filterEndDate, (String)TimeZoneDateBean.getTimeConvertFormat()).getTimeInMillis() + Long.parseLong(this.offset);
        Calendar endTimeCal = TEDateUtils.setUtcDateToNMTime((long)endTime);
        String filteruser = inputData.getBussinessParams().getRowParams(0).getParam("logusername").getValue();
        String logdate = this.convertCDate(faultcode);
        String logtime = this.convertCTime(faultcode);
        String loguser = "";
        if ("OPLOG".equalsIgnoreCase(input.getPart("LOGNAME").getValue())) {
            loguser = this.convertCusername(faultcode);
        }
        String format = "yyyy-MM-dd HH-mm-ss";
        Calendar logcal = TEDateUtils.strToCalendar((String)(logdate + " " + logtime), (String)format);
        long time = TEDateUtils.getTL1NMTimeFromNETime((int)this.neid, (long)logcal.getTimeInMillis()).getTimeInMillis();
        logflag = filteruser.equals(SUCCESSCODE) || filteruser.equals(loguser);
        if (logflag) {
            logflag = time > startTimeCal.getTimeInMillis() && time < endTimeCal.getTimeInMillis();
        }
        if (logflag && !loguser.equals("")) {
            this.allLogUserMap.put(loguser, loguser);
        }
        return logflag;
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap, InMsg input, OutMsg output) {
        String content = output.getFault().getErrDesc();
        String[] callbackcontent = this.convertContentString(content, input);
        if (oldParam.getName().endsWith("UID")) {
            oldParam.setValue(callbackcontent[1]);
        } else if (oldParam.getName().endsWith("LOGNAME")) {
            if ("OPLOG".equalsIgnoreCase(input.getPart("LOGNAME").getValue())) {
                oldParam.setValue("OPT");
            } else {
                oldParam.setValue("NR");
            }
        } else if (oldParam.getName().endsWith("time")) {
            TENE ne = TENEListUtils.getNEObj((int)this.neid);
            String format = "yyyy-MM-dd HH-mm-ss";
            Calendar logcal = TEDateUtils.strToCalendar((String)callbackcontent[0], (String)format);
            long time = TEDateUtils.getTL1NMTimeFromNETime((int)this.neid, (long)logcal.getTimeInMillis()).getTimeInMillis();
            oldParam.setValue(String.valueOf(time));
        } else if (oldParam.getName().endsWith("detail")) {
            oldParam.setValue(callbackcontent[2]);
        } else if (oldParam.getName().endsWith("offset")) {
            oldParam.setValue(this.offset);
        }
        return oldParam;
    }

    private String[] convertContentString(String str, InMsg input) {
        String[] result = "OPLOG".equalsIgnoreCase(input.getPart("LOGNAME").getValue()) ? this.convertOPContent(str) : this.convertNRContent(str);
        return result;
    }

    private String[] convertOPContent(String str) {
        String[] errcode = str.split(",");
        String cdate = this.convertCDate(str);
        String ctime = this.convertCTime(str);
        String cusername = this.convertCusername(str);
        StringBuffer useract = new StringBuffer();
        for (int i = 2; i < errcode.length; ++i) {
            String[] tempstr = errcode[i].split(":");
            for (int j = 0; j < tempstr.length; ++j) {
                if (i == errcode.length - 1 && j == tempstr.length - 1) {
                    useract.append(tempstr[j].trim());
                    continue;
                }
                useract.append(tempstr[j].trim() + ":");
            }
        }
        String[] content = new String[]{cdate + " " + ctime, cusername, useract.toString()};
        return content;
    }

    private String[] convertNRContent(String str) {
        String cdate = this.convertCDate(str);
        String ctime = this.convertCTime(str);
        String cusername = "-";
        String[] contentInfo = str.split(":");
        StringBuffer useract = new StringBuffer();
        for (int i = 2; i < contentInfo.length; ++i) {
            if (i == contentInfo.length - 1) {
                useract.append(contentInfo[i].trim());
                continue;
            }
            useract.append(contentInfo[i].trim() + ":");
        }
        String[] content = new String[]{cdate + " " + ctime, cusername, useract.toString()};
        if (useract.length() >= 2) {
            content[2] = useract.substring(1, useract.length() - 1);
        }
        return content;
    }

    private String convertCDate(String str) {
        return str.substring(0, 10);
    }

    private String convertCTime(String str) {
        return str.substring(11, 19);
    }

    private String convertCusername(String str) {
        String[] errstr = str.split(",");
        return errstr[1].substring(6, errstr[1].length()).trim();
    }
}

