/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.necommunication.dccmgr;

import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;

public class TESONETDCCAIDData
implements Comparable,
Cloneable {
    private int neID = -1;
    private int slotID = -1;
    private int portID = -1;
    private int channelID = -1;
    private String preAid = "";
    private int hashCode = 0;
    private String name = null;

    public TESONETDCCAIDData(int _neID, String _dcc) {
        String[] vararr = TETL1CommonUtil.parseAID((String)_dcc, (int)_neID);
        this.neID = _neID;
        this.slotID = TETL1CommonUtil.getNMSlotStr((String)_dcc, (int)_neID);
        this.portID = Integer.parseInt(vararr[3]);
        this.channelID = Integer.parseInt(vararr[4]);
        this.preAid = vararr[0];
    }

    public int getNeID() {
        return this.neID;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public int getPortID() {
        return this.portID;
    }

    public int getChannelID() {
        return this.channelID;
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            int ret = 17;
            ret = ret * 37 + this.neID;
            ret = ret * 37 + this.slotID;
            ret = ret * 37 + this.portID;
            this.hashCode = ret = ret * 37 + this.channelID;
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.name == null) {
            int boardtypeid = TEConfigurationDataMgr.getInstance().getBoardType(this.neID, this.slotID);
            String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neID, boardtypeid);
            String portName = "";
            portName = this.preAid.equalsIgnoreCase("DCC") || this.preAid.equalsIgnoreCase("GCC") ? TETL1CommonUtil.getPortNameFromNEPort((String)"FAC", (int)this.slotID, (int)this.portID, (int)this.neID) : TETL1CommonUtil.getPortNameFromNEPort((String)this.preAid, (int)this.slotID, (int)this.portID, (int)this.neID);
            StringBuffer buf = new StringBuffer();
            String showSlot = TETL1CommonUtil.getShelfSlotName((int)this.neID, (int)this.slotID);
            buf.append(showSlot);
            buf.append("-");
            buf.append(boardName);
            buf.append("-");
            buf.append(portName);
            if (this.preAid.equalsIgnoreCase("DCC")) {
                buf.append("-");
                if (this.channelID == 1) {
                    buf.append("D1-D3");
                } else if (this.channelID == 2) {
                    buf.append("D4-D12");
                } else if (this.channelID == 3) {
                    if (boardtypeid == 1275 || boardtypeid == 1262) {
                        buf.append("OSC18");
                    } else {
                        buf.append("ETHA");
                    }
                } else if (this.channelID == 4) {
                    buf.append("ETHB");
                }
            } else if (!(this.preAid.equals("") || this.preAid.equals("-1") || this.preAid.equalsIgnoreCase("DCC"))) {
                buf.append("-");
                if (this.channelID == 1) {
                    buf.append("GCC0");
                } else if (this.channelID == 2) {
                    buf.append("GCC12");
                } else if (this.channelID == 3) {
                    buf.append("GCCA");
                }
            }
            this.name = buf.toString();
        }
        return this.name;
    }

    public int compareTo(Object obj) {
        if (obj == null || !(obj instanceof TESONETDCCAIDData)) {
            return 1;
        }
        TESONETDCCAIDData compareAIDData = (TESONETDCCAIDData)obj;
        int ret = this.neID - compareAIDData.neID;
        if (0 != ret) {
            return ret;
        }
        ret = this.slotID - compareAIDData.slotID;
        if (0 != ret) {
            return ret;
        }
        ret = this.portID - compareAIDData.portID;
        if (0 != ret) {
            return ret;
        }
        return this.channelID - compareAIDData.channelID;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TESONETDCCAIDData)) {
            return false;
        }
        TESONETDCCAIDData compareAIDData = (TESONETDCCAIDData)obj;
        return this.neID == compareAIDData.getNeID() && this.slotID == compareAIDData.getSlotID() && this.portID == compareAIDData.getPortID() && this.channelID == compareAIDData.getChannelID();
    }

    public Object clone() {
        TESONETDCCAIDData dccAIDData = null;
        try {
            dccAIDData = (TESONETDCCAIDData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            dccAIDData = new TESONETDCCAIDData(this.neID, "");
            return dccAIDData;
        }
        return dccAIDData;
    }

    public String getPreAid() {
        return this.preAid;
    }

    public void setPreAid(String preAid) {
        this.preAid = preAid;
    }
}

