/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.necommunication.dccmgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEDCCSupportPortMgr {
    private static final String path = "conf" + File.separator + "necommunication" + File.separator + "portsuppdccrate.xml";
    private static TEDCCSupportPortMgr instance = null;
    private Map boardPortMap = new HashMap();

    private TEDCCSupportPortMgr(int neid) {
        this.boardPortMap = this.getSupportBoardList(neid);
    }

    public static synchronized TEDCCSupportPortMgr getInstance(int neid) {
        if (instance == null) {
            instance = new TEDCCSupportPortMgr(neid);
        }
        return instance;
    }

    private Map getSupportBoardList(int neid) {
        try {
            Document doc = TEParseXMLFile.parseFile((String)(TEResourceManager.getPath() + TEGetFilePath.getFilePath((int)neid, (String)path)));
            if (null == doc) {
                return null;
            }
            NodeList nodeList = doc.getElementsByTagName("board");
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Element boardElement = (Element)nodeList.item(i);
                String boardType = boardElement.getAttribute("type");
                String suppPort = boardElement.getAttribute("dccportlist");
                this.boardPortMap.put(boardType, suppPort);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEDCCSupportPortMgr.getSupportBoardList() fail!", (Throwable)e);
        }
        return this.boardPortMap;
    }

    public String[] getBoardSupportPorts(int neid, String boardType) {
        String[] portList = new String[]{};
        if (this.boardPortMap == null) {
            this.boardPortMap = this.getSupportBoardList(neid);
        }
        if (this.boardPortMap.containsKey(boardType)) {
            String boardPorts = (String)this.boardPortMap.get(boardType);
            portList = boardPorts.split(",");
        }
        return portList;
    }

    public Map getBoardPortMap(int neid) {
        if (this.boardPortMap == null) {
            this.boardPortMap = this.getSupportBoardList(neid);
        }
        return this.boardPortMap;
    }
}

