/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.necommunication;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1DataConverter;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;

public class TEQueryTIDIPBean
extends TETL1NEExplorerBean {
    protected Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList tl1OperList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        int tl1OperSize = tl1OperList.size();
        RowParams rowparams = null;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        ArrayList errorData = this.getErrorData(neid, subfunc, tl1OperList, filterErrorCodeList);
        PageParams pageParams = new PageParams();
        Param param = new Param();
        param.setName("nename");
        param.setValue(TENEListUtils.getNEObj((int)neid).getNEName());
        pageParams.addParam(param);
        outputData.setPageParams(pageParams);
        TL1Operation tl1Operation = null;
        if (0 == tl1OperList.size()) {
            if (0 == errorData.size()) {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else if (errorData.size() >= tl1OperSize) {
                rowparams = new RowParams();
                int sizei = errorData.size();
                for (int ii = 0; ii < sizei; ++ii) {
                    rowparams.addRowErrors((RowErrors)errorData.get(ii));
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            } else {
                rowparams = new RowParams();
                int sizei = errorData.size();
                for (int ii = 0; ii < sizei; ++ii) {
                    rowparams.addRowErrors((RowErrors)errorData.get(ii));
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            }
            return outputData;
        }
        InMsg input = null;
        OutMsg output = null;
        int len = tl1OperList.size();
        for (int i = 0; i < len; ++i) {
            tl1Operation = (TL1Operation)tl1OperList.get(i);
            input = tl1Operation.getInMsg();
            int size = tl1Operation.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                rowparams = new RowParams();
                output = tl1Operation.getOutMsg(row);
                if (!this.handleReturnRowData(neid, subfunc, rowparams, input, output)) continue;
                outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
        if (0 != errorData.size()) {
            rowparams = new RowParams();
            int sizei = errorData.size();
            for (int ii = 0; ii < sizei; ++ii) {
                rowparams.addRowErrors((RowErrors)errorData.get(ii));
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (0 == errorData.size()) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (errorData.size() >= tl1OperSize) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return outputData;
    }

    protected boolean handleReturnRowData(int neid, SubFunc subfunc, RowParams rowparams, InMsg input, OutMsg output) {
        HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
        Param param = null;
        param = new Param();
        param.setName("tid");
        param.setValue(((Part)partmap.get("TID")).getValue());
        rowparams.addParam(param);
        param = new Param();
        param.setName("ipaddr");
        param.setValue(((Part)partmap.get("IPADDR")).getValue());
        rowparams.addParam(param);
        param = new Param();
        param.setName("mode");
        param.setValue(((Part)partmap.get("MODE")).getValue());
        rowparams.addParam(param);
        return true;
    }

    private ArrayList getErrorData(int neid, SubFunc subfunc, ArrayList tl1OperationList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        TL1Operation tl1Oper = null;
        OutMsg curOutput = null;
        String errorCode = "OK";
        if (null == tl1OperationList || 0 == tl1OperationList.size()) {
            return errorDataList;
        }
        this.cloneTL1OperationList.clear();
        for (int i = tl1OperationList.size() - 1; i >= 0; --i) {
            tl1Oper = (TL1Operation)tl1OperationList.get(i);
            for (int index = tl1Oper.getOutMsgCount() - 1; index >= 0; --index) {
                curOutput = tl1Oper.getOutMsg(index);
                errorCode = curOutput.getFault().getErrCode();
                if (filterErrorCodeList.contains(errorCode)) {
                    tl1Oper.removeOutMsg(curOutput);
                    continue;
                }
                if ("".equals(errorCode)) continue;
                errorDataList.add(0, TETL1DataConverter.handleErrorData((int)neid, (SubFunc)subfunc, (InMsg)tl1Oper.getInMsg(), (OutMsg)curOutput));
                tl1Oper.removeOutMsg(curOutput);
            }
            this.cloneTL1OperationList.add(tl1Oper.clone());
            if (tl1Oper.getOutMsgCount() != 0) continue;
            tl1OperationList.remove(i);
        }
        int operSize = tl1OperationList.size();
        if (0 == operSize) {
            return errorDataList;
        }
        return errorDataList;
    }
}

