/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.necommunication;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class TEGetETHAttrBean
extends TETL1NEExplorerBean {
    private static final String ADAPT_LAN_MODE = "1";
    private static final String FIXED_LAN_MODE = "0";
    private static final String LAN_SPEED_100M = "1";
    private static final String LAN_SPEED_10M = "0";
    private static final String FULL_WORK_DUPLEX = "1";
    private static final String HALF_WORK_DUPLEX = "0";
    private static final String OPEN_ENABLE_STATUS = "1";
    private static final String CLOSE_ENABLE_STATUS = "0";
    private static final int MAIN_SUBRACK_ID = 1;
    private static final List<Integer> SCC_BOARDS = new ArrayList<Integer>();

    public TEGetETHAttrBean() {
        this.msgBlockFlag = false;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector logBoardList = null;
        if (null != ne) {
            logBoardList = ne.getBoardList();
        }
        if (null == logBoardList || 0 == logBoardList.size()) {
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        int len = logBoardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)logBoardList.get(i);
            if (!SCC_BOARDS.contains(board.getBoardType())) continue;
            RowParams row = new RowParams();
            Param param = new Param();
            if (1 != TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)board.getSlotID())) continue;
            param.setName("slotid");
            param.setValue(String.valueOf(board.getSlotID()));
            row.addParam(param);
            inputData.getBussinessParams().addRowParams(0, row);
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        String aid = "";
        if (null == rowparams.getParam("slotid")) {
            return false;
        }
        if ("AID".equals(part.getName()) && null != rowparams.getParam("slotid")) {
            String neSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)Integer.parseInt(rowparams.getParam("slotid").getValue()));
            aid = "LAN-" + neSlotID + "-ALL";
            part.setValue(aid);
        }
        return true;
    }

    protected boolean fillMsgBlock(RowParams rowparams, MsgBlock msgBlock) {
        return true;
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        Param param = null;
        if ("workmode".equals(oldParam.getName())) {
            param = (Param)oldParam.clone();
            String lanMode = "1";
            String lanSpeed = "1";
            String workDuplex = "1";
            Part part = (Part)partmap.get("LANMODE");
            if (part != null && part.getValue() != null && "FIXED".equals(part.getValue())) {
                lanMode = "0";
            }
            if ((part = (Part)partmap.get("LANSPEED")) != null && part.getValue() != null && "10M".equals(part.getValue())) {
                lanSpeed = "0";
            }
            if ((part = (Part)partmap.get("WORKDUPLEX")) != null && part.getValue() != null && "HALF".equals(part.getValue())) {
                workDuplex = "0";
            }
            param.setValue(lanMode + "-" + lanSpeed + "-" + workDuplex);
        }
        if ("enablestatus".equals(oldParam.getName())) {
            param = (Param)oldParam.clone();
            String lanState = "1";
            Part part = (Part)partmap.get("LANSTATE");
            if (part != null && part.getValue() != null && "CLOSE".equals(part.getValue())) {
                lanState = "0";
            }
            param.setValue(lanState);
        }
        if ("AID".equals(oldParam.getName())) {
            param = (Param)oldParam.clone();
            Part part = (Part)partmap.get("AID");
            if (part != null && part.getValue() != null) {
                param.setValue(part.getValue());
            }
        }
        return param;
    }

    protected boolean handleRowData(int neid, SubFunc subfunc, RowParams rowparams, InMsg input, OutMsg output) {
        if (super.handleRowData(neid, subfunc, rowparams, input, output)) {
            String aid = rowparams.getParam("AID").getValue();
            String port = "";
            int soltid = TETL1CommonUtil.getNMSlotStr((String)aid, (int)neid);
            String shelfname = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)soltid);
            String slotID = aid.substring(aid.indexOf("-") + 1, aid.lastIndexOf("-"));
            String portid = aid.substring(aid.lastIndexOf("-") + 1);
            TEConfigurationDataMgr instance = TEConfigurationDataMgr.getInstance();
            int boardtype = instance.getBoardType(neid, soltid);
            String boardname = instance.getBoardTypeName(neid, boardtype);
            port = shelfname + "-" + slotID.split("-")[1] + "-" + boardname + "-" + portid + "(ETH" + portid + ")";
            rowparams.addParam(new Param("port", port));
            return true;
        }
        return false;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<String> errorList = new ArrayList<String>();
        errorList.add("PARAMETER NOT VALID, Invalid slot number");
        return errorList;
    }

    static {
        SCC_BOARDS.add(1314);
    }
}

