/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.fault;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEAlarmData;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.tl1necommon.fault.TEAlarmAeIDKey;
import com.huawei.nglct.nemgr.tl1necommon.fault.TETL1AlarmAttrValue;
import com.huawei.nglct.ngwdm_pub.TETL1AIDTranslateRuleMgr;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TEBoardSupportAlarmAID;
import com.huawei.nglct.tl1.TEBoardSupportAlarmMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class TEQueryNeAlarmProperty
extends TETL1NEExplorerBean {
    private int slotID = -1;
    private Datainterface outputData = null;
    public static final int NELEVEL = -2;
    public static final int ALARM_COM = -1;
    private boolean isTrue = false;
    private boolean isFalse = false;
    private Hashtable alarmDataMap = new Hashtable();
    private int boardCount = 1;
    private int result = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
            ne.setAlarmAttrDataMap(this.alarmDataMap);
            this.outputData = new Datainterface();
            this.cloneTL1OperationList = new ArrayList();
            this.boardCount = ne.getBoardList().size();
            this.outputData.setBussinessParams(new BussinessParams());
            BussinessParams businessparams = inputData.getBussinessParams();
            RowParams rowparams = businessparams.getRowParams(0);
            this.slotID = Integer.parseInt(rowparams.getParam("slotID").getValue());
            if (this.slotID == -2) {
                ArrayList operList = this.getNEAlarmTL1Opertion("ALL");
                if (null == operList || operList.size() == 0) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                    return this.outputData;
                }
                this.result = this.sendMessage(neid, operList);
                if (this.result == 0) {
                    this.processRspData(operList);
                }
            } else {
                this.slotIDList = new HashSet();
                this.slotIDList.add(this.slotID);
                this.aidAndTypeList = TETL1CommonUtil.queryPortType((int)neid, (HashSet)this.slotIDList);
                if (this.aidAndTypeList == null) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
                    return this.outputData;
                }
                if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                    Fault fault = this.aidAndTypeList.getFaultInfo(this.slotID);
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2, (String)fault.getErrDesc()));
                    return this.outputData;
                }
                TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, this.slotID);
                if (board == null) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                    return this.outputData;
                }
                ArrayList fbList = TEBoardSupportAlarmMgr.getInstance().getBoardSupportAlarmFBList(board.getBoardType());
                Collections.sort(fbList);
                if (fbList == null || fbList.size() == 0) {
                    this.isTrue = true;
                } else {
                    this.dealFbList(neid, fbList);
                }
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
            }
            RowParams[] outrowparams = this.convertAlarmAttrDataToRowData(this.alarmDataMap);
            for (int k = 0; k < outrowparams.length; ++k) {
                this.outputData.getBussinessParams().addRowParams(outrowparams[k]);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.setOutputMessage(neid);
    }

    private Datainterface setOutputMessage(int neid) {
        this.outputData.setErrorMessage(new ErrorMessage());
        if (this.isTrue && !this.isFalse) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (this.isFalse && !this.isTrue) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else if (this.result == 1090650120) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1090650120));
            this.outputData.setBussinessParams(new BussinessParams());
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return this.outputData;
    }

    private void dealFbList(int neid, ArrayList fbList) {
        int len = fbList.size();
        for (int j = 0; j < len; ++j) {
            ArrayList allModList;
            TEBoardSupportAlarmAID fbobj = (TEBoardSupportAlarmAID)fbList.get(j);
            int portID = fbobj.getPortID();
            int pathID = fbobj.getPathID();
            if (fbobj.getMod2Name().equals("ENV") || fbobj.getPortID() == 0 && fbobj.getPathID() == 0 && !fbobj.getMod2Name().equals("EQPT") && !fbobj.getMod2Name().equals("COM") || !TETL1FaultUtil.isSupportODUTCMService((TEAIDAndTypeList)this.aidAndTypeList, (int)neid, (int)this.slotID, (int)fbobj.getPortID()) && fbobj.getMod2Name().indexOf("TCM") != -1 || portID != 0 && (!(allModList = TETL1FaultUtil.getUseableModName((TEAIDAndTypeList)this.aidAndTypeList, (int)neid, (int)this.slotID, (int)portID, (int)pathID)).contains(fbobj.getMod2Name()) || TETL1FaultUtil.isNotSupport52TomODU((TEAIDAndTypeList)this.aidAndTypeList, (int)neid, (int)this.slotID, (int)fbobj.getPortID(), (int)fbobj.getPathID(), (String)fbobj.getMod2Name()))) continue;
            ArrayList operList = this.getAlarmTL1Opertion(this.slotID, fbobj);
            if (null == operList || operList.size() == 0) {
                this.isTrue = true;
                continue;
            }
            this.result = this.sendMessage(neid, operList);
            if (this.result == 0) {
                this.processRspData(operList);
                continue;
            }
            if (this.result == 1090650120) break;
        }
    }

    private void processRspData(ArrayList tl1OperList) {
        int len = tl1OperList.size();
        for (int i = 0; i < len; ++i) {
            TL1Operation tl1Operation = (TL1Operation)tl1OperList.get(i);
            int size = tl1Operation.getOutMsgCount();
            if (size == 0) {
                this.isTrue = true;
            }
            for (int j = 0; j < size; ++j) {
                OutMsg output = tl1Operation.getOutMsg(j);
                if (output.getFault().getCompletionCode() != 0) {
                    this.isFalse = true;
                    tl1Operation.addCmdFault(output.getFault());
                    RowErrors rowerror = this.handleErrorData(this.neid, tl1Operation, output);
                    RowParams errrowparams = new RowParams();
                    errrowparams.addRowErrors(rowerror);
                    this.outputData.getBussinessParams().addRowParams(errrowparams);
                    break;
                }
                this.isTrue = true;
                HashMap partmap = TETL1CommonUtil.getOutMsgPart((OutMsg)output);
                this.saveAlarmAttrData(partmap);
            }
            this.cloneTL1OperationList.add(tl1Operation.clone());
        }
    }

    private ArrayList getNEAlarmTL1Opertion(String mode2) {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.tl1ngwdm", (String)TETL1CommonUtil.TL1_DES_PATH);
            TL1Operation opery = definitions.getTL1Operation("RTRV-ATTR");
            TL1Operation oper = (TL1Operation)opery.clone();
            oper.setMod2(mode2);
            String name = oper.getCmdCode() + "-" + oper.getMod1() + "-" + oper.getMod2();
            oper.setName(name);
            InMsg inputMsg = oper.getInMsg();
            StagBlock stagblock = inputMsg.getStagBlock();
            AID aid = stagblock.getAID();
            Part aidPart = aid.getPart(0);
            aidPart.setValue("");
            operationList.add(oper);
            if (this.isSupportTALM()) {
                TL1Operation operT_Alm = definitions.getTL1Operation("RTRV-ATTRTCA-MOD2");
                TL1Operation operT = (TL1Operation)operT_Alm.clone();
                operT.setMod2(mode2);
                String nameTAlm = operT.getCmdCode() + "-" + operT.getMod1() + "-" + operT.getMod2();
                operT.setName(nameTAlm);
                InMsg inputMsgTAlm = operT.getInMsg();
                StagBlock stagblockTalm = inputMsgTAlm.getStagBlock();
                AID aidTalm = stagblockTalm.getAID();
                Part aidPartTAlm = aidTalm.getPart(0);
                aidPartTAlm.setValue("");
                operationList.add(operT);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryNeAlarmProperty.getNEAlarmTL1Opertion() fail!", (Throwable)e);
        }
        return operationList;
    }

    private ArrayList getAlarmTL1Opertion(int slotID2, TEBoardSupportAlarmAID fbobj) {
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile((String)"com.huawei.weblct.tl1ngwdm", (String)TETL1CommonUtil.TL1_DES_PATH);
            TL1Operation opery = definitions.getTL1Operation("RTRV-ATTR");
            TL1Operation oper = (TL1Operation)opery.clone();
            String mod2 = fbobj.getMod2Name();
            oper.setMod2(mod2);
            String name = oper.getCmdCode() + "-" + oper.getMod1() + "-" + oper.getMod2();
            oper.setName(name);
            InMsg inputMsg = oper.getInMsg();
            StagBlock stagblock = inputMsg.getStagBlock();
            AID aid = stagblock.getAID();
            Part aidPart = aid.getPart(0);
            if (mod2.equals("COM")) {
                aidPart.setValue("");
            } else {
                String newAid = this.getAIDFromalmFB(slotID2, fbobj);
                aidPart.setValue(newAid);
            }
            operationList.add(oper);
            TL1Operation operTAlm = this.createTAlmOperation(definitions, fbobj, this.slotID);
            if (operTAlm != null) {
                operationList.add(operTAlm);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryNeAlarmProperty.getAlarmTL1Opertion() fail!", (Throwable)e);
        }
        return operationList;
    }

    private TL1Operation createTAlmOperation(TL1Definitions definitions, TEBoardSupportAlarmAID fbobj, int slotID2) {
        if (fbobj.isSupportT_Alm() && this.isSupportTALM()) {
            TL1Operation operOld = definitions.getTL1Operation("RTRV-ATTRTCA-MOD2");
            TL1Operation oper = (TL1Operation)operOld.clone();
            String mod2 = fbobj.getMod2Name();
            if (mod2.equals("SFP")) {
                mod2 = "EQPT";
            }
            oper.setMod2(mod2);
            String name = oper.getCmdCode() + "-" + oper.getMod1() + "-" + oper.getMod2();
            oper.setName(name);
            InMsg inputMsg = oper.getInMsg();
            StagBlock stagblock = inputMsg.getStagBlock();
            AID aid = stagblock.getAID();
            Part aidPart = aid.getPart(0);
            if (mod2.equals("COM")) {
                aidPart.setValue("");
            } else {
                String newAid = this.getAIDFromalmFB(this.slotID, fbobj);
                aidPart.setValue(newAid);
            }
            return oper;
        }
        return null;
    }

    private String getAIDFromalmFB(int slotID2, TEBoardSupportAlarmAID fbobj) {
        String neSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID((int)this.neid, (int)slotID2);
        int nePort = TETL1CommonUtil.getAIDPortNo((int)this.neid, (int)slotID2, (int)fbobj.getPortID());
        String aidpre = TETL1CommonUtil.getAIDFrefix((int)this.neid, (int)slotID2, (int)fbobj.getPortID());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID2);
        if (fbobj.getPortID() == 0) {
            return new StringBuffer().append("SLOT").append("-").append(neSlot).toString();
        }
        if (fbobj.getPathID() == 0) {
            if (fbobj.getMod2Name().equals("EQPT")) {
                aidpre = "SLOT";
            }
            return new StringBuffer().append(aidpre).append("-").append(neSlot).append("-").append(nePort).toString();
        }
        String showPath = String.valueOf(fbobj.getPathID());
        if (fbobj.getPathID() > 1200) {
            showPath = TETL1AIDTranslateRuleMgr.getInstance().getTL1Path(boardType, String.valueOf(fbobj.getPathID()));
        }
        if (showPath.equals("")) {
            return new StringBuffer().append(aidpre).append("-").append(neSlot).append("-").append(nePort).toString();
        }
        return new StringBuffer().append(aidpre).append("-").append(neSlot).append("-").append(nePort).append("-").append(showPath).toString();
    }

    public int getTimeOut() {
        return 60 + this.boardCount * 2;
    }

    private RowParams[] convertAlarmAttrDataToRowData(Hashtable alarmDataMap2) {
        RowParams[] rowparams = new RowParams[alarmDataMap2.size()];
        Iterator it = alarmDataMap2.entrySet().iterator();
        int i = 0;
        int size = alarmDataMap2.size();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            TEAlarmAeIDKey key = (TEAlarmAeIDKey)entry.getKey();
            ArrayList list = (ArrayList)entry.getValue();
            if (list.size() == 0) continue;
            TETL1AlarmAttrValue attr = (TETL1AlarmAttrValue)list.get(0);
            rowparams[i] = new RowParams();
            rowparams[i].addParam("aidType", attr.getAidType());
            rowparams[i].addParam("curAID", attr.getCurAID());
            rowparams[i].addParam("faultEvent", attr.getFaultName());
            rowparams[i].addParam("location", String.valueOf(attr.getLocation()));
            rowparams[i].addParam("directions", String.valueOf(attr.getDirection()));
            rowparams[i].addParam("faultLevel", String.valueOf(this.getFaultLevel(list)));
            rowparams[i].addParam("affectService", attr.getAffectService());
            rowparams[i].addParam("aeID", String.valueOf(key.getAeID()));
            rowparams[i].addParam("defaultValue", String.valueOf(attr.getDefaultLevel()));
            rowparams[i].addParam("conditiontype", String.valueOf(attr.getCondType()));
            rowparams[i].addParam("totalResultNum", String.valueOf(size));
            ++i;
        }
        return rowparams;
    }

    private int getFaultLevel(ArrayList list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            TETL1AlarmAttrValue value = (TETL1AlarmAttrValue)list.get(i);
            for (int j = i + 1; j < size; ++j) {
                TETL1AlarmAttrValue valueNext = (TETL1AlarmAttrValue)list.get(j);
                if (value.getLevel() == valueNext.getLevel()) continue;
                return 0;
            }
        }
        TETL1AlarmAttrValue firstvalue = (TETL1AlarmAttrValue)list.get(0);
        return firstvalue.getLevel();
    }

    private void saveAlarmAttrData(HashMap partmap) {
        TEAlarmData alarmData;
        Part part = (Part)partmap.get("AIDTYPE");
        String mod2Name = part.getValue();
        part = (Part)partmap.get("LOCN");
        int loc = TETL1FaultUtil.getTL1AlarmLocation((String)part.getValue());
        part = (Part)partmap.get("DIRN");
        int dir = TETL1FaultUtil.getTL1AlarmDirection((String)part.getValue());
        part = (Part)partmap.get("CONDTYPE");
        String faultName = part.getValue();
        part = (Part)partmap.get("AID");
        String aid = part.getValue();
        part = (Part)partmap.get("NTFCNCDE");
        String strlevel = part.getValue();
        part = (Part)partmap.get("SRVEFF");
        String affectService = part.getValue();
        part = (Part)partmap.get("CONDEFF");
        String condType = "-";
        if (part != null && part.getValue() != null) {
            condType = part.getValue();
        }
        if ((alarmData = TETL1FaultUtil.getAlarmDataFromStatic((String)mod2Name, (int)loc, (int)dir, (String)faultName)) == null) {
            return;
        }
        if (this.isSFPModel(aid, mod2Name)) {
            mod2Name = "SFP";
        }
        TEAlarmAeIDKey aeIDkey = new TEAlarmAeIDKey(alarmData.getAeID(), mod2Name);
        ArrayList<TETL1AlarmAttrValue> list = (ArrayList<TETL1AlarmAttrValue>)this.alarmDataMap.get(aeIDkey);
        TETL1AlarmAttrValue attr = new TETL1AlarmAttrValue();
        attr.setAidType(mod2Name);
        attr.setFaultName(faultName);
        attr.setLocation(loc);
        attr.setDirection(dir);
        attr.setCurAID(aid);
        attr.setLevel(strlevel);
        attr.setService(affectService);
        attr.setDefaultLevel(alarmData.getAeSeverity());
        attr.setCondType(condType);
        if (list == null) {
            list = new ArrayList<TETL1AlarmAttrValue>();
            this.alarmDataMap.put(aeIDkey, list);
        }
        list.add(attr);
    }

    private boolean isSFPModel(String aid, String aidType) {
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)this.neid);
        try {
            if (aid.split("-")[0].equalsIgnoreCase("SLOT") && aidType.equalsIgnoreCase("EQPT")) {
                if (ne.getNEType() == 70 && aid.split("-").length == 3) {
                    return true;
                }
                if (aid.split("-").length == 4) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryBoardAlarmProperty.isSFPModel() String is null!", (Throwable)e);
        }
        return false;
    }

    public RowErrors handleErrorData(int neid, TL1Operation oper, OutMsg output) {
        InMsg input = oper.getInMsg();
        String AID2 = input.getStagBlock().getAID().getPart(0).getValue();
        String obj = TETL1FaultUtil.getBoardStructFromAID((String)AID2, (int)neid, (boolean)true, (String)oper.getMod2());
        return TETL1CommonUtil.createRowErrors((int)neid, (Fault)output.getFault(), (String)obj);
    }

    private boolean isSupportTALM() {
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)this.neid);
        if (ne.getNEType() == 66) {
            return false;
        }
        if (ne.getHostVersion().indexOf("5.70") != -1 || ne.getHostVersion().indexOf("5.71") != -1) {
            return false;
        }
        return ne.getHostVersion().compareTo("5.51.06.12") > 0;
    }
}

