/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.fault;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEAlarmData;
import com.huawei.nglct.nelist.TEAlarmKey;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListConstant;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.tl1.TEBoardSupportAlarmData;
import com.huawei.nglct.tl1.TEBoardSupportAlarmMgr;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class TEDefaultAlarmAttrBean
extends TETL1NEExplorerBean {
    private Datainterface outputData = null;
    TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            ArrayList neSupportAlarmList;
            this.outputData = new Datainterface();
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
            Param param = inputData.getBussinessParams().getRowParams(0).getParam("slotID");
            int boardType = -1;
            if (param != null) {
                int slot = Integer.parseInt(param.getValue());
                boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slot);
            }
            if ((neSupportAlarmList = this.getNESupportAlarmList((TENE)ne, boardType)).size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            this.outputData.setBussinessParams(new BussinessParams());
            RowParams rowparams = null;
            int size = neSupportAlarmList.size();
            for (int i = 0; i < size; ++i) {
                TEAlarmData alarmData = (TEAlarmData)neSupportAlarmList.get(i);
                rowparams = new RowParams();
                Param[] params = this.buildParams(alarmData);
                for (int k = 0; k < params.length; ++k) {
                    rowparams.addParam(params[k]);
                }
                this.outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private Param[] buildParams(TEAlarmData alarmData) {
        Param[] params = new Param[5];
        params[0] = new Param();
        params[0].setName("AeName");
        params[0].setValue(alarmData.getAeName());
        params[1] = new Param();
        params[1].setName("AIDType");
        String mod2 = "";
        mod2 = this.fbDesc.getMOD2(alarmData.getAIDType());
        params[1].setValue(mod2);
        params[2] = new Param();
        params[2].setName("Location");
        params[2].setValue(String.valueOf(alarmData.getLocation()));
        params[3] = new Param();
        params[3].setName("Direction");
        params[3].setValue(String.valueOf(alarmData.getDirection()));
        params[4] = new Param();
        params[4].setName("Severity");
        params[4].setValue(String.valueOf(alarmData.getAeSeverity()));
        return params;
    }

    private ArrayList getNESupportAlarmList(TENE ne, int boardType) {
        ArrayList neSupAlmList = new ArrayList();
        HashMap almDataMap = TENEListConstant.getInstance().getTL1NMAlmData();
        if (boardType != -1) {
            int i;
            Vector boardList = ne.getBoardList();
            ArrayList allSupportList = new ArrayList();
            int size = boardList.size();
            for (i = 0; i < size; ++i) {
                TEBoard board = (TEBoard)boardList.get(i);
                ArrayList alarmList = TEBoardSupportAlarmMgr.getInstance().getBoardSupportAllAlarm(board.getBoardType());
                allSupportList.addAll(alarmList);
            }
            size = allSupportList.size();
            for (i = 0; i < size; ++i) {
                TEBoardSupportAlarmData brdSupAlm = (TEBoardSupportAlarmData)allSupportList.get(i);
                TEAlarmKey almKey = new TEAlarmKey(brdSupAlm.getEqType(), brdSupAlm.getAeID());
                TEAlarmData almdata = (TEAlarmData)almDataMap.get(almKey);
                if (neSupAlmList.contains(almdata)) continue;
                neSupAlmList.add(almdata);
            }
        } else {
            neSupAlmList = TEBoardSupportAlarmMgr.getInstance().getBoardSupportAllAlarm(boardType);
        }
        return neSupAlmList;
    }
}

