/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.fault;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.tl1necommon.fault.TEAlarmAeIDKey;
import com.huawei.nglct.nemgr.tl1necommon.fault.TETL1AlarmAttrValue;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Hashtable;

public class TEApplyNeAlarmProperty
extends TETL1NEExplorerBean {
    private Datainterface outputData = null;
    private ArrayList allTL1OperationList = null;
    private String errorObj = "";
    private Hashtable alarmDataMap = new Hashtable();
    private int slotID = -1;
    private String neName = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            this.cloneTL1OperationList.clear();
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
            this.neName = ne.getNEName();
            this.alarmDataMap = ne.getAlarmAttrDataMap();
            RowParams param = inputData.getBussinessParams().getRowParams(0);
            this.errorObj = param.getParam("monObj").getValue();
            this.slotID = Integer.parseInt(param.getParam("slotID").getValue());
            boolean isFalse = false;
            boolean isTrue = false;
            int result = -1;
            this.allTL1OperationList = this.getTL1Operation(neid, subFunc, inputData, memeryData);
            if (null == this.allTL1OperationList || this.allTL1OperationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int size = this.allTL1OperationList.size();
            for (int i = 0; i < size; ++i) {
                TL1Operation tl1Operation;
                TL1Operation oper = (TL1Operation)this.allTL1OperationList.get(i);
                ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
                operationList.add(oper);
                RowParams rowparam = new RowParams();
                result = this.sendMessage(neid, operationList);
                if (result == 0) {
                    tl1Operation = (TL1Operation)operationList.get(0);
                    if (tl1Operation.getOutMsgCount() == 0) {
                        isTrue = true;
                    } else {
                        OutMsg[] out = tl1Operation.getOutMsg();
                        RowErrors rowerror = this.handleErrorData(out[0]);
                        if (out[0].getFault().getCompletionCode() == 0) {
                            isTrue = true;
                        } else {
                            isFalse = true;
                            tl1Operation.addCmdFault(out[0].getFault());
                            rowparam.addRowErrors(rowerror);
                        }
                        this.outputData.getBussinessParams().addRowParams(rowparam);
                    }
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                    return this.outputData;
                }
                this.cloneTL1OperationList.add(tl1Operation.clone());
            }
            this.outputData.setErrorMessage(new ErrorMessage());
            if (isTrue && !isFalse) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            } else if (isTrue && isFalse) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
        String aid;
        String mod2 = rowparams.getParam("aidType").getValue();
        if (mod2.equals("SFP")) {
            mod2 = "EQPT";
        }
        if (rowparams.getParam("curAID") != null && (aid = rowparams.getParam("curAID").getValue()) != null && this.isSFPModel(aid, mod2)) {
            mod2 = "EQPT";
        }
        tl1Operation.setMod2(mod2);
        tl1Operation.setName(tl1Operation.getCmdCode() + "-" + tl1Operation.getMod1() + "-" + tl1Operation.getMod2());
    }

    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                tl1List.add(subfunc.getQxMapping(i).getContent());
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = tl1List.size();
            for (int i = 0; i < size; ++i) {
                tl1Operation = tl1Definitions.getTL1Operation((String)tl1List.get(i));
                if (null == tl1Operation) continue;
                this.changeMod2(tl1Operation, rowparams);
                int aeID = Integer.parseInt(rowparams.getParam("aeID").getValue());
                String aidType = rowparams.getParam("aidType").getValue();
                TEAlarmAeIDKey key = new TEAlarmAeIDKey(aeID, aidType);
                ArrayList aidList = this.getAlarmAttrList(key);
                if (aidList == null) continue;
                int aidLen = aidList.size();
                for (int j = 0; j < aidLen; ++j) {
                    TL1Operation oper = (TL1Operation)tl1Operation.clone();
                    TETL1AlarmAttrValue datavalue = (TETL1AlarmAttrValue)aidList.get(j);
                    if (!datavalue.getCondType().equals("-")) {
                        if (!tl1Operation.getMod1().equals("ATTRTCA")) continue;
                        oper.setMod1("ATTRTCA");
                        oper.setName(oper.getCmdCode() + "-" + oper.getMod1() + "-" + oper.getMod2());
                    } else if (tl1Operation.getMod1().equals("ATTRTCA")) continue;
                    String aid = datavalue.getCurAID();
                    if (aid.equals("COM")) {
                        aid = "";
                    }
                    if (null == (inputMsg = oper.getInMsg())) {
                        tl1OperList.add(oper);
                        continue;
                    }
                    oper.clearCmdFaultInfo();
                    fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock(), aid);
                    if (fillComplete) {
                        fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                    }
                    if (!this.msgBlockFlag && !fillComplete) continue;
                    tl1OperList.add(oper);
                }
            }
        }
        return tl1OperList;
    }

    protected boolean fillStagBlock(RowParams rowparams, StagBlock stagBlock, String aid) {
        boolean flag = true;
        AID aidObj = stagBlock.getAID();
        Part part = null;
        int len = aidObj.getPartCount();
        for (int i = 0; i < len; ++i) {
            part = aidObj.getPart(i);
            if (this.convertPartValue(part, rowparams, aid)) continue;
            if (null != part.getDefault()) {
                part.setValue(part.getDefault());
                continue;
            }
            flag = false;
            break;
        }
        return flag;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams, String _aid) {
        boolean flag = true;
        if (part.getName().equalsIgnoreCase("AID")) {
            if (this.slotID == -1) {
                part.setValue("");
            } else {
                part.setValue(_aid);
            }
            return flag;
        }
        return flag;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        if (part.getName().equalsIgnoreCase("NTFCNCDE")) {
            if (rowparams.getParam("faultLevel") == null || rowparams.getParam("faultLevel").getValue() == null) {
                return false;
            }
            String alarmLevel = rowparams.getParam("faultLevel").getValue();
            if (alarmLevel.equals("1")) {
                part.setValue("CR");
            } else if (alarmLevel.equals("2")) {
                part.setValue("MJ");
            } else if (alarmLevel.equals("3")) {
                part.setValue("MN");
            } else if (alarmLevel.equals("4")) {
                part.setValue("NA");
            } else if (alarmLevel.equals("5")) {
                part.setValue("NR");
            }
            return true;
        }
        if (part.getName().equals("CONDTYPE")) {
            String faultEvent = rowparams.getParam("faultEvent").getValue();
            part.setValue(faultEvent);
            return true;
        }
        if (part.getName().equalsIgnoreCase("LOCN")) {
            String location = rowparams.getParam("location").getValue();
            if (location.equals("1")) {
                part.setValue("NEND");
            } else if (location.equals("2")) {
                part.setValue("FEND");
            }
            return true;
        }
        if (part.getName().equalsIgnoreCase("DIRN")) {
            String location = rowparams.getParam("directions").getValue();
            if (location.equals("1")) {
                part.setValue("RCV");
            } else if (location.equals("2")) {
                part.setValue("TRMT");
            } else {
                part.setValue("");
            }
            return true;
        }
        if (part.getName().equalsIgnoreCase("SRVEFF")) {
            part.setValue("");
            return true;
        }
        if (part.getName().equalsIgnoreCase("CONDEFF")) {
            String conditiontype = rowparams.getParam("conditiontype").getValue();
            part.setValue(conditiontype);
            return true;
        }
        return super.convertPartValue(part, rowparams);
    }

    private RowErrors handleErrorData(OutMsg output) {
        String errorCode = output.getFault().getErrCode();
        String errorinfo = output.getFault().getErrDesc();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = errorinfo.indexOf("LOGIN NOT ACTIVE") != -1 ? new Param("neObj", this.neName) : new Param("neObj", this.errorObj);
        rowError.addParam(errorparam);
        return rowError;
    }

    private ArrayList getAlarmAttrList(TEAlarmAeIDKey aidKey) {
        ArrayList<TETL1AlarmAttrValue> alarmList = new ArrayList<TETL1AlarmAttrValue>();
        ArrayList aidList = (ArrayList)this.alarmDataMap.get(aidKey);
        if (this.slotID == -2) {
            return aidList;
        }
        int size = aidList.size();
        for (int i = 0; i < size; ++i) {
            TETL1AlarmAttrValue datavalue = (TETL1AlarmAttrValue)aidList.get(i);
            if (datavalue.getCurAID().equals("COM")) {
                alarmList.add(datavalue);
                continue;
            }
            if (datavalue.getSlotID(this.neid) != this.slotID) continue;
            alarmList.add(datavalue);
        }
        return alarmList;
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)neid);
            return this.convertToTL1Operation(subFunc, inputData, tl1definitions, null);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    private boolean isSFPModel(String aid, String aidType) {
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)this.neid);
        try {
            if (aid.split("-")[0].equalsIgnoreCase("SLOT") && aidType.equalsIgnoreCase("EQPT")) {
                if (ne.getNEType() == 70 && aid.split("-").length == 3) {
                    return true;
                }
                if (aid.split("-").length == 4) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryBoardAlarmProperty.isSFPModel() String is null!", (Throwable)e);
        }
        return false;
    }
}

