/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon.fault;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.tl1necommon.fault.TEBitErrThMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;

public class TEApplyBitErrorBean
extends TETL1NEExplorerBean {
    private TEBitErrThMgr tEBitErrThMgr = TEBitErrThMgr.getInstance();
    private HashMap modifyParam = null;
    private boolean isTrue = false;
    private boolean isFalse = false;
    private HashMap modifyMap = new HashMap();
    private String neName = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        this.neName = ne.getNEName();
        this.cloneTL1OperationList = new ArrayList();
        this.modifyParam = this.tEBitErrThMgr.getAidMod2Map();
        this.outputData = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        this.outputData.setBussinessParams(bParams);
        ArrayList tl1OperList = this.getABitErrorOperList(neid, inputData);
        if (null == tl1OperList || tl1OperList.size() == 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        int result = this.sendMessage(neid, tl1OperList);
        if (result != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            return this.outputData;
        }
        this.handleMessage(neid, tl1OperList);
        if (this.isTrue && !this.isFalse) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (this.isTrue && this.isFalse) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
        }
        return this.outputData;
    }

    private void handleMessage(int neid, ArrayList tl1OperList) {
        RowParams rowparams = new RowParams();
        this.outputData.getBussinessParams().addRowParams(rowparams);
        int size = tl1OperList.size();
        for (int i = 0; i < size; ++i) {
            TL1Operation oper = (TL1Operation)tl1OperList.get(i);
            OutMsg outmsg = null;
            if (oper.getOutMsgCount() == 0) {
                this.isTrue = true;
            }
            int len = oper.getOutMsgCount();
            for (int j = 0; j < len; ++j) {
                outmsg = oper.getOutMsg(j);
                if (outmsg.getFault().getCompletionCode() != 0) {
                    this.isFalse = true;
                    rowparams.addRowErrors(this.createRowErrors(outmsg.getFault(), oper));
                    oper.addCmdFault(outmsg.getFault());
                    continue;
                }
                this.isTrue = true;
            }
            this.cloneTL1OperationList.add((TL1Operation)oper.clone());
        }
    }

    private RowErrors createRowErrors(Fault fault, TL1Operation operation) {
        String errorCode = fault.getErrCode();
        String errorinfo = fault.getErrDesc();
        String aidstr = operation.getInMsg().getStagBlock().getAID().getPart(0).getValue();
        String monObj = TETL1CommonUtil.getBoardStructFromAID((String)aidstr, (int)this.neid, (boolean)true);
        monObj = monObj + ":" + operation.getMod1();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = errorinfo.indexOf("LOGIN NOT ACTIVE") != -1 ? new Param("neObj", this.neName) : new Param("neObj", monObj);
        rowError.addParam(errorparam);
        ArrayList list = (ArrayList)this.modifyMap.get(aidstr);
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                String errorCol = (String)list.get(i);
                String[] errorArr = errorCol.split(",");
                errorparam = new Param(errorArr[0], errorArr[1]);
                rowError.addParam(errorparam);
            }
        }
        return rowError;
    }

    private ArrayList getABitErrorOperList(int neID, Datainterface inputData) {
        ArrayList list = new ArrayList();
        TL1Definitions tl1definitions = null;
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile((int)this.neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEApplyBitErrorBean.getABitErrorOperList() fail!", (Throwable)e);
        }
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        int size = rParams.length;
        for (int i = 0; i < size; ++i) {
            String aidStruct = rParams[i].getParam("aidStruct").getValue();
            ArrayList mod2List = (ArrayList)this.modifyParam.get(aidStruct);
            if (mod2List == null) continue;
            ArrayList<String> listtmp = new ArrayList<String>();
            this.modifyMap.put(aidStruct, listtmp);
            int count = rParams[i].getParamCount();
            for (int k = 0; k < count; ++k) {
                if (!rParams[i].getParam(k).getModifyFlag()) continue;
                String singleOperMod2 = this.getMod2FromBitError(mod2List, rParams[i].getParam(k).getName());
                String tl1DesOperMod2 = this.getTL1Mod2FromBitError(mod2List, rParams[i].getParam(k).getName());
                String opername = "ED-" + tl1DesOperMod2;
                TL1Operation oper = tl1definitions.getTL1Operation(opername);
                TETL1CommonUtil.modifyMOD2((TL1Operation)oper, (String)singleOperMod2);
                TL1Operation operClone = (TL1Operation)oper.clone();
                AID aid = operClone.getInMsg().getStagBlock().getAID();
                aid.getPart(0).setValue(aidStruct);
                DataBlock datablock = operClone.getInMsg().getMsgBlock().getDataBlock(1);
                if (operClone.getInMsg().getMsgBlock().getDataBlockCount() > 2) {
                    DataBlock pstdatablock = operClone.getInMsg().getMsgBlock().getDataBlock(2);
                    operClone.getInMsg().getMsgBlock().removeDataBlock(pstdatablock);
                }
                if (rParams[i].getParam(k) != null) {
                    String value = rParams[i].getParam(k).getValue();
                    String paramName = this.tEBitErrThMgr.getParamFromCol(rParams[i].getParam(k).getName());
                    if (!value.equals("")) {
                        if (paramName.equals("BEFECSDBER")) {
                            this.setPartValue(paramName, this.convertNEBefBer(value), datablock);
                        } else if (paramName.equals("B1SFBER") || paramName.equals("B1SDBER")) {
                            String b1sf = rParams[i].getParam("biterr_type_101").getValue();
                            String b1sd = rParams[i].getParam("biterr_type_102").getValue();
                            this.setPartValue("B1SFBER", TEBitErrThMgr.convertNESDSFValue(b1sf), datablock);
                            this.setPartValue("B1SDBER", TEBitErrThMgr.convertNESDSFValue(b1sd), datablock);
                        } else if (paramName.equals("B2SFBER") || paramName.equals("B2SDBER")) {
                            String b2sf = rParams[i].getParam("biterr_type_103").getValue();
                            String b2sd = rParams[i].getParam("biterr_type_104").getValue();
                            this.setPartValue("B2SFBER", TEBitErrThMgr.convertNESDSFValue(b2sf), datablock);
                            this.setPartValue("B2SDBER", TEBitErrThMgr.convertNESDSFValue(b2sd), datablock);
                        } else {
                            this.setPartValue(paramName, TEBitErrThMgr.convertNESDSFValue(value), datablock);
                        }
                        listtmp.add(paramName + "," + value);
                    }
                }
                TETL1CommonUtil.addOperList(list, (TL1Operation)operClone);
            }
        }
        return list;
    }

    private String convertNEBefBer(String befecBit) {
        if (befecBit.indexOf("_CoeffiFlag") != -1) {
            return befecBit.split("_")[0];
        }
        return "1E-" + befecBit;
    }

    private void setPartValue(String partName, String value, DataBlock datablock) {
        int dataLen = datablock.getPartCount();
        for (int m = 0; m < dataLen; ++m) {
            Part part = datablock.getPart(m);
            if (!part.getName().equals(partName)) continue;
            part.setValue(value);
            break;
        }
    }

    private String getMod2FromBitError(ArrayList mod2list, String colName) {
        int index = colName.lastIndexOf("_");
        String bit = colName.substring(index + 1, colName.length());
        int size = mod2list.size();
        for (int i = 0; i < size; ++i) {
            String tempStr = (String)mod2list.get(i);
            String[] str = tempStr.split("&");
            if (!str[0].equals(bit)) continue;
            return str[1];
        }
        return "";
    }

    private String getTL1Mod2FromBitError(ArrayList mod2list, String colName) {
        int index = colName.lastIndexOf("_");
        String bit = colName.substring(index + 1, colName.length());
        int size = mod2list.size();
        for (int i = 0; i < size; ++i) {
            String tempStr = (String)mod2list.get(i);
            String[] str = tempStr.split("&");
            if (!str[0].equals(bit)) continue;
            return str[2];
        }
        return "";
    }
}

