/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.tl1necommon.TEAlarmComparator;
import com.huawei.nglct.nemgr.tl1necommon.TECurrentAlarmFilter;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1Alarm;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Vector;

public class TEPrintCurrentAlarmBean
extends TETL1NEExplorerBean {
    private static final int SYNC_ALARM = 2099235;
    private static final int TECMDCODE_ALM_HISTORY_PRINT = 2555939;
    private static final String SORT_BY_COL = "sortParam";
    private static final String SORT_BY_PARAM = "sortby";
    private static final String SORT_BY_DES = "des";
    public static final String ALARM_SOURCE_FILE = "res" + File.separator + "alarmsource_" + TENEListUtils.getLanguage() + ".ini";
    private Vector currentAlarmVector = null;
    private String sortby = "des";
    private int sortCol = 1;
    private TECurrentAlarmFilter filter = null;
    private Datainterface filterAlmDataInterface = new Datainterface();
    private SubFunc Fuc = null;

    public Datainterface performBussinessProcess(int neID, SubFunc subFuc, Datainterface inputData, Datainterface MemoryData, String user, String ipAddress) {
        this.Fuc = subFuc;
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neID);
        this.cloneTL1OperationList.clear();
        this.parseInputData(inputData);
        this.currentAlarmVector = this.getCurrentAlarmList((TENE)ne);
        BussinessParams bParam = new BussinessParams();
        TEAlarmComparator alarmComp = new TEAlarmComparator();
        if (this.sortby.equalsIgnoreCase(SORT_BY_DES)) {
            alarmComp.setSortBy(1);
            alarmComp.setcolSort(this.sortCol);
        } else {
            alarmComp.setSortBy(0);
            alarmComp.setcolSort(this.sortCol);
        }
        Vector filterAlarmList = this.filter.filter(this.currentAlarmVector);
        Collections.sort(filterAlarmList, alarmComp);
        ne.setLastQueryAlarmList((Vector)filterAlarmList.clone());
        this.currentAlarmVector = new Vector();
        int size = filterAlarmList.size();
        for (int n = 0; n < size; ++n) {
            this.currentAlarmVector.add(filterAlarmList.get(n));
        }
        size = this.currentAlarmVector.size();
        for (int i = 0; i < size; ++i) {
            TETL1Alarm tempAlarm = (TETL1Alarm)this.currentAlarmVector.get(i);
            bParam.addRowParams(tempAlarm.toRowParam());
        }
        this.filterAlmDataInterface.setBussinessParams(bParam);
        this.filterAlmDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
        if (this.isNeedOperationlog()) {
            super.writeLog(neID, subFuc, user, ipAddress, this.cloneTL1OperationList);
        }
        return this.filterAlmDataInterface;
    }

    public boolean isNeedOperationlog() {
        return 2099235 == this.Fuc.getCode();
    }

    public Vector getCurrentAlarmList(TENE tempNE) {
        Vector alarmVector = (Vector)tempNE.getAlarmList().clone();
        return alarmVector;
    }

    private void parseInputData(Datainterface inputData) {
        ArrayList<String> alarmName = new ArrayList<String>();
        ArrayList<Integer> alarmLevel = new ArrayList<Integer>();
        ArrayList<Integer> alarmType = new ArrayList<Integer>();
        String startFrom = null;
        String startTo = null;
        this.filter = new TECurrentAlarmFilter();
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        int size = rParams.length;
        for (int i = 0; i < size; ++i) {
            int len = rParams[i].getParam().length;
            for (int j = 0; j < len; ++j) {
                long offset;
                Param offsetParam;
                Calendar cal;
                Param[] params = rParams[i].getParam();
                Param param = params[j];
                String name = param.getName();
                String value = param.getValue();
                if (name.equals(SORT_BY_PARAM)) {
                    this.sortby = value;
                } else if (name.equals(SORT_BY_COL)) {
                    this.sortCol = Integer.valueOf(value);
                } else if (name.equals("alarmName") && !value.equals("-1")) {
                    alarmName.add(value);
                } else if (name.equals("alarmLevel") && !value.equals("-1")) {
                    alarmLevel.add(new Integer(value));
                } else if (name.equals("alarmType") && !value.equals("-1")) {
                    alarmType.add(new Integer(value));
                }
                if (name.equals("startFrom")) {
                    if (value != null && value.length() > 0) {
                        cal = Calendar.getInstance();
                        offsetParam = rParams[i].getParam("offset");
                        offset = 0L;
                        if (offsetParam != null && offsetParam.getValue() != null) {
                            offset = Long.parseLong(offsetParam.getValue());
                        }
                        cal.setTimeInMillis(TEDateUtils.strToCalendar((String)value, (String)"yyyy-MM-dd HH:mm:ss").getTimeInMillis() + offset);
                        cal = TEDateUtils.setUtcDateToNMTime((long)cal.getTimeInMillis());
                        startFrom = TEDateUtils.calendarToStr((Calendar)cal);
                    } else {
                        startFrom = null;
                    }
                } else if (name.equals("startTo")) {
                    if (value != null && value.length() > 0) {
                        cal = Calendar.getInstance();
                        offsetParam = rParams[i].getParam("offset");
                        offset = 0L;
                        if (offsetParam != null && offsetParam.getValue() != null) {
                            offset = Long.parseLong(offsetParam.getValue());
                        }
                        cal.setTimeInMillis(TEDateUtils.strToCalendar((String)value, (String)"yyyy-MM-dd HH:mm:ss").getTimeInMillis() + offset);
                        cal = TEDateUtils.setUtcDateToNMTime((long)cal.getTimeInMillis());
                        startTo = TEDateUtils.calendarToStr((Calendar)cal);
                    } else {
                        startTo = null;
                    }
                }
                if (!name.equalsIgnoreCase("slotid")) continue;
                this.filter.setSoltId(value);
            }
        }
        if (this.Fuc.getCode() == 2555939) {
            alarmLevel.clear();
            alarmLevel.add(5);
            this.filter.setAlarmLevel(alarmLevel);
            this.filter.setAlarmName(alarmName);
            this.filter.setAlarmType(alarmType);
            this.filter.setStartFrom(startFrom);
            this.filter.setStartTo(startTo);
        } else {
            this.filter.setAlarmLevel(alarmLevel);
            this.filter.setAlarmName(alarmName);
            this.filter.setAlarmType(alarmType);
            this.filter.setStartFrom(startFrom);
            this.filter.setStartTo(startTo);
        }
    }
}

