/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TEDeleteAlmBean
implements TENEMgrInterface {
    private boolean allSuccess = true;
    private boolean allFailed = true;
    private TEResourceUtil res = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Datainterface rtnDatainterface = new Datainterface();
        BussinessParams rtnBParams = new BussinessParams();
        int neID = neid;
        RowParams[] rowParamsArr = inputData.getBussinessParams().getRowParams();
        int alarmLength = rowParamsArr.length;
        int[] evtSerialNum = new int[alarmLength];
        int len = rowParamsArr.length;
        for (int i = 0; i < len; ++i) {
            for (Param tmpParam : rowParamsArr[i].getParam()) {
                if (!tmpParam.getName().equals("evtSerialNum")) continue;
                evtSerialNum[i] = new Integer(tmpParam.getValue());
            }
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        int[] retCode = ne.deleteAlm(evtSerialNum);
        if (retCode[0] != 0) {
            this.allFailed = false;
        }
        int len2 = retCode.length;
        for (int i = 1; i < len2; ++i) {
            if (retCode[i] == 0) continue;
            this.allSuccess = false;
            RowParams rowParam = new RowParams();
            RowErrors rowErr = new RowErrors();
            Param errParam = new Param();
            errParam.setName("nename");
            errParam.setValue(ne.getNEName());
            rowErr.addParam(errParam);
            rowErr.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)retCode[i]));
            rowParam.addRowErrors(rowErr);
            rtnBParams.addRowParams(rowParam);
        }
        ErrorMessage bigErr = this.allSuccess ? TEErrorResourceUtil.getErrorMessage((int)neID, (int)0) : (this.allFailed ? TEErrorResourceUtil.getErrorMessage((int)neID, (int)2) : TEErrorResourceUtil.getErrorMessage((int)neID, (int)1));
        rtnDatainterface.setBussinessParams(rtnBParams);
        rtnDatainterface.setErrorMessage(bigErr);
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, rtnDatainterface);
        }
        return rtnDatainterface;
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            StringBuffer filePath = new StringBuffer();
            filePath.append(TEPathManager.RESOURCE_PROFILE_PATH).append("fault").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
            this.res = TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                loginfo.setUserID(userID);
            }
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateName(subfunc.getSubFuncDes(neid));
            loginfo.setOperateObject("");
            loginfo.setOperateDesc(this.almToString(inputData));
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                loginfo.setOperateObject(String.valueOf(neid));
            } else {
                loginfo.setOperateObject(neObj.getNEName());
            }
            if (errorCode == 0) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            } else if (errorCode == 2 || errorCode == 1) {
                loginfo.setResult(errorCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    loginfo.setErrCode(errorCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    loginfo.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    loginfo.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(loginfo);
                    break;
                }
            } else {
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String almToString(Datainterface inputData) {
        StringBuffer strBuf = new StringBuffer();
        String alarm = this.res.getString("alarm");
        String num = this.res.getString("evtSerialNum");
        RowParams[] rowParamsArr = inputData.getBussinessParams().getRowParams();
        int len = rowParamsArr.length;
        for (int i = 0; i < len; ++i) {
            for (Param tmpParam : rowParamsArr[i].getParam()) {
                if (tmpParam.getName().equals("alarmName")) {
                    strBuf.append(alarm).append(tmpParam.getValue()).append(",");
                    continue;
                }
                if (!tmpParam.getName().equals("evtSerialNum")) continue;
                strBuf.append(num).append(tmpParam.getValue());
            }
            strBuf.append(" ");
        }
        return strBuf.toString();
    }
}

