/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.tl1necommon.TEAlarmComparator;
import com.huawei.nglct.nemgr.tl1necommon.TECurrentAlarmFilter;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1Alarm;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Vector;

public class TEBrowseCurrentAlarmBean
extends TETL1NEExplorerBean {
    protected static final int SYNC_ALARM = 2099235;
    protected static final String SORT_BY_COL = "sortParam";
    protected static final String SORT_BY_PARAM = "sortby";
    protected static final String SORT_BY_DES = "des";
    public static final String ALARM_SOURCE_FILE = "res" + File.separator + "alarmsource_" + TENEListUtils.getLanguage() + ".ini";
    private Vector currentAlarmVector = null;
    protected String sortby = "des";
    protected int sortCol = 1;
    protected TECurrentAlarmFilter filter = null;
    private Datainterface filterAlmDataInterface = new Datainterface();
    protected int pageNum = 1;
    protected int resultNumPerPage = 40;
    private int pageTl1EndIndex = 0;
    private int pageTl1StartIndex = 0;
    private SubFunc Fuc = null;

    public Datainterface performBussinessProcess(int neID, SubFunc subFuc, Datainterface inputData, Datainterface MemoryData, String user, String ipAddress) {
        this.Fuc = subFuc;
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neID);
        String neName = ne.getNEName();
        this.cloneTL1OperationList.clear();
        this.parseInputData(inputData);
        if (subFuc.getCode() == 2099235) {
            this.cloneTL1OperationList = ne.queryTL1Alarm();
            if (!ne.isQueryAlarmSucc) {
                this.filterAlmDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)1090646019));
                return this.filterAlmDataInterface;
            }
            TL1Operation oper = (TL1Operation)this.cloneTL1OperationList.get(0);
            OutMsg[] out = oper.getOutMsg();
            if (0 != out.length) {
                RowParams rowparam = new RowParams();
                RowErrors rowerror = this.handleErrorData(out[0], neName);
                if (out[0].getFault().getCompletionCode() != 0) {
                    oper.addCmdFault(out[0].getFault());
                    rowparam.addRowErrors(rowerror);
                    this.filterAlmDataInterface.setBussinessParams(new BussinessParams());
                    this.filterAlmDataInterface.getBussinessParams().addRowParams(rowparam);
                    this.filterAlmDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)2));
                    if (this.isNeedOperationlog()) {
                        super.writeLog(neID, subFuc, user, ipAddress, this.cloneTL1OperationList);
                    }
                    return this.filterAlmDataInterface;
                }
            }
        }
        this.currentAlarmVector = this.getCurrentAlarmList((TENE)ne);
        BussinessParams bTl1Param = new BussinessParams();
        Param tl1tempParam = new Param();
        TEAlarmComparator alarmTl1Comp = new TEAlarmComparator();
        if (this.sortby.equalsIgnoreCase(SORT_BY_DES)) {
            alarmTl1Comp.setSortBy(1);
            alarmTl1Comp.setcolSort(this.sortCol);
        } else {
            alarmTl1Comp.setSortBy(0);
            alarmTl1Comp.setcolSort(this.sortCol);
        }
        Vector filterAlarmList = this.filter.filter(this.currentAlarmVector);
        Collections.sort(filterAlarmList, alarmTl1Comp);
        ne.setLastQueryAlarmList((Vector)filterAlarmList.clone());
        int pageTl1Size = filterAlarmList.size();
        this.pageTl1StartIndex = (this.pageNum - 1) * this.resultNumPerPage;
        this.pageTl1EndIndex = this.pageTl1StartIndex + this.resultNumPerPage;
        int totalPageNumTl1 = 0;
        if (this.pageTl1EndIndex > pageTl1Size) {
            this.pageTl1EndIndex = pageTl1Size;
        }
        if (0 == (totalPageNumTl1 = pageTl1Size % this.resultNumPerPage == 0 ? pageTl1Size / this.resultNumPerPage : pageTl1Size / this.resultNumPerPage + 1)) {
            totalPageNumTl1 = 1;
        }
        if (this.pageTl1StartIndex > pageTl1Size) {
            this.pageNum = totalPageNumTl1;
            this.pageTl1StartIndex = this.pageNum != 0 ? (this.pageNum - 1) * this.resultNumPerPage : this.pageNum;
        }
        this.currentAlarmVector = new Vector();
        for (int n = this.pageTl1StartIndex; n < this.pageTl1EndIndex; ++n) {
            this.currentAlarmVector.add(filterAlarmList.get(n));
        }
        RowParams tl1RowParams = new RowParams();
        bTl1Param.addRowParams(tl1RowParams);
        tl1tempParam.setName("totalPageNum");
        tl1tempParam.setValue("" + totalPageNumTl1);
        tl1RowParams.addParam(tl1tempParam);
        tl1tempParam = new Param();
        tl1tempParam.setName("totalResultNum");
        tl1tempParam.setValue(String.valueOf(pageTl1Size));
        tl1RowParams.addParam(tl1tempParam);
        tl1tempParam = new Param();
        tl1tempParam.setName("pageNum");
        tl1tempParam.setValue("" + this.pageNum);
        tl1RowParams.addParam(tl1tempParam);
        tl1tempParam = new Param();
        tl1tempParam.setName("resultNumPerPage");
        tl1tempParam.setValue("" + this.resultNumPerPage);
        tl1RowParams.addParam(tl1tempParam);
        int size = this.currentAlarmVector.size();
        for (int i = 0; i < size; ++i) {
            TETL1Alarm tempAlarm = (TETL1Alarm)this.currentAlarmVector.get(i);
            bTl1Param.addRowParams(tempAlarm.toRowParam());
        }
        this.filterAlmDataInterface.setBussinessParams(bTl1Param);
        this.filterAlmDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
        if (this.isNeedOperationlog()) {
            super.writeLog(neID, subFuc, user, ipAddress, this.cloneTL1OperationList);
        }
        return this.filterAlmDataInterface;
    }

    private RowErrors handleErrorData(OutMsg output, String errorObj) {
        String errorCode = output.getFault().getErrCode();
        String errorinfo = output.getFault().getErrDesc();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("neObj", errorObj);
        rowError.addParam(errorparam);
        return rowError;
    }

    public boolean isNeedOperationlog() {
        return 2099235 == this.Fuc.getCode();
    }

    public Vector getCurrentAlarmList(TENE tempNE) {
        Vector alarmVector = (Vector)tempNE.getAlarmList().clone();
        return alarmVector;
    }

    protected void parseInputData(Datainterface inputData) {
        ArrayList<String> alarmName = new ArrayList<String>();
        ArrayList<Integer> alarmLevel = new ArrayList<Integer>();
        ArrayList<Integer> alarmType = new ArrayList<Integer>();
        String startFrom = null;
        String startTo = null;
        this.filter = new TECurrentAlarmFilter();
        RowParams[] rTl1Params = inputData.getBussinessParams().getRowParams();
        int size = rTl1Params.length;
        for (int i = 0; i < size; ++i) {
            int len = rTl1Params[i].getParam().length;
            for (int j = 0; j < len; ++j) {
                long offset;
                Param offsetParam;
                Calendar cal;
                Param[] params = rTl1Params[i].getParam();
                Param param = params[j];
                String tl1Name = param.getName();
                String value = param.getValue();
                if (tl1Name.equals(SORT_BY_PARAM)) {
                    this.sortby = value;
                } else if (tl1Name.equals(SORT_BY_COL)) {
                    this.sortCol = Integer.valueOf(value);
                } else if (tl1Name.equals("pageNum")) {
                    this.pageNum = Integer.valueOf(value);
                } else if (tl1Name.equals("resultNumPerPage")) {
                    this.resultNumPerPage = Integer.valueOf(value);
                } else if (tl1Name.equals("alarmName") && !value.equals("-1")) {
                    alarmName.add(value);
                } else if (tl1Name.equals("alarmLevel") && !value.equals("-1")) {
                    alarmLevel.add(new Integer(value));
                } else if (tl1Name.equals("alarmType") && !value.equals("-1")) {
                    alarmType.add(new Integer(value));
                }
                if (tl1Name.equals("startFrom")) {
                    if (value != null && value.length() > 0) {
                        cal = Calendar.getInstance();
                        offsetParam = rTl1Params[i].getParam("offset");
                        offset = 0L;
                        if (offsetParam != null && offsetParam.getValue() != null) {
                            offset = Long.parseLong(offsetParam.getValue());
                        }
                        cal.setTimeInMillis(TEDateUtils.strToCalendar((String)value, (String)"yyyy-MM-dd HH:mm:ss").getTimeInMillis() + offset);
                        cal = TEDateUtils.setUtcDateToNMTime((long)cal.getTimeInMillis());
                        startFrom = TEDateUtils.calendarToStr((Calendar)cal);
                    } else {
                        startFrom = null;
                    }
                } else if (tl1Name.equals("startTo")) {
                    if (value != null && value.length() > 0) {
                        cal = Calendar.getInstance();
                        offsetParam = rTl1Params[i].getParam("offset");
                        offset = 0L;
                        if (offsetParam != null && offsetParam.getValue() != null) {
                            offset = Long.parseLong(offsetParam.getValue());
                        }
                        cal.setTimeInMillis(TEDateUtils.strToCalendar((String)value, (String)"yyyy-MM-dd HH:mm:ss").getTimeInMillis() + offset);
                        cal = TEDateUtils.setUtcDateToNMTime((long)cal.getTimeInMillis());
                        startTo = TEDateUtils.calendarToStr((Calendar)cal);
                    } else {
                        startTo = null;
                    }
                }
                if (!tl1Name.equalsIgnoreCase("slotid")) continue;
                this.filter.setSoltId(value);
            }
        }
        this.filter.setAlarmLevel(alarmLevel);
        this.filter.setAlarmName(alarmName);
        this.filter.setAlarmType(alarmType);
        this.filter.setStartFrom(startFrom);
        this.filter.setStartTo(startTo);
    }
}

