/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.tl1necommon;

import com.huawei.nglct.tl1.nemanager.TETL1Alarm;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Comparator;

public class TEAlarmComparator
implements Comparator,
Serializable {
    private static final long serialVersionUID = 6710550461752844056L;
    private static final int DEFAULT_VALUE = -1;
    private static final int ALARMLEVEL_VALUE = 1;
    private static final int ALARMNAME_VALUE = 2;
    private static final int ALARMLOCATION_VALUE = 3;
    private static final int ALARMDIRECTION_VALUE = 4;
    private static final int ALARMMON_VALUE = 5;
    private static final int STARTTIME_VALUE = 6;
    private static final int ALARMTYPE_VALUE = 7;
    private int sortby = 0;
    private int colSort = -1;

    public void setSortBy(int sortby) {
        this.sortby = sortby;
    }

    public int getSortBy() {
        return this.sortby;
    }

    public void setcolSort(int colSort) {
        this.colSort = colSort;
    }

    public int getColSort() {
        return this.colSort;
    }

    public int compare(Object o1, Object o2) {
        TETL1Alarm obj1 = (TETL1Alarm)o1;
        TETL1Alarm obj2 = (TETL1Alarm)o2;
        switch (this.colSort) {
            case -1: {
                return -1;
            }
            case 1: {
                return this.alarmLevelCompare(obj1, obj2);
            }
            case 2: {
                return this.alarmNameCompare(obj1, obj2);
            }
            case 3: {
                return this.alarmLocationCompare(obj1, obj2);
            }
            case 4: {
                return this.alarmDirectionCompare(obj1, obj2);
            }
            case 5: {
                return this.alarmMonObjCompare(obj1, obj2);
            }
            case 6: {
                return this.startTimeCompare(obj1, obj2);
            }
            case 7: {
                return this.alarmTypeCompare(obj1, obj2);
            }
        }
        return -1;
    }

    private int alarmDirectionCompare(TETL1Alarm obj1, TETL1Alarm obj2) {
        if (this.sortby == 0) {
            return TETL1FaultUtil.getTL1AlarmDirection((String)obj1.getAlarmDirection()) - TETL1FaultUtil.getTL1AlarmDirection((String)obj2.getAlarmDirection());
        }
        return TETL1FaultUtil.getTL1AlarmDirection((String)obj2.getAlarmDirection()) - TETL1FaultUtil.getTL1AlarmDirection((String)obj1.getAlarmDirection());
    }

    private int alarmLocationCompare(TETL1Alarm obj1, TETL1Alarm obj2) {
        if (this.sortby == 0) {
            return TETL1FaultUtil.getTL1AlarmLocation((String)obj1.getAlarmLocation()) - TETL1FaultUtil.getTL1AlarmLocation((String)obj2.getAlarmLocation());
        }
        return TETL1FaultUtil.getTL1AlarmLocation((String)obj2.getAlarmLocation()) - TETL1FaultUtil.getTL1AlarmLocation((String)obj1.getAlarmLocation());
    }

    private int alarmLevelCompare(TETL1Alarm obj1, TETL1Alarm obj2) {
        if (this.sortby == 0) {
            return TETL1FaultUtil.getTL1AlarmLevel((String)obj1.getAlarmLevel()) - TETL1FaultUtil.getTL1AlarmLevel((String)obj2.getAlarmLevel());
        }
        return TETL1FaultUtil.getTL1AlarmLevel((String)obj2.getAlarmLevel()) - TETL1FaultUtil.getTL1AlarmLevel((String)obj1.getAlarmLevel());
    }

    private int alarmNameCompare(TETL1Alarm obj1, TETL1Alarm obj2) {
        String s1 = obj1.getAlarmName();
        String s2 = obj2.getAlarmName();
        if (this.sortby == 0) {
            return s1.compareTo(s2);
        }
        return s2.compareTo(s1);
    }

    private int alarmMonObjCompare(TETL1Alarm obj1, TETL1Alarm obj2) {
        if (this.sortby == 0) {
            return this.monObjCompare(obj1, obj2);
        }
        return this.monObjCompare(obj2, obj1);
    }

    private int monObjCompare(TETL1Alarm obj1, TETL1Alarm obj2) {
        if (obj1.getSlotID() == obj2.getSlotID()) {
            return obj1.getMonObject().compareTo(obj2.getMonObject());
        }
        return obj1.getSlotID() - obj2.getSlotID();
    }

    private int startTimeCompare(TETL1Alarm obj1, TETL1Alarm obj2) {
        Calendar s1 = obj1.getStartDateTime();
        Calendar s2 = obj2.getStartDateTime();
        if (this.sortby == 0) {
            if (s1.after(s2)) {
                return 1;
            }
            return 0;
        }
        if (s1.before(s2)) {
            return 1;
        }
        return 0;
    }

    private int alarmTypeCompare(TETL1Alarm obj1, TETL1Alarm obj2) {
        if (this.sortby == 0) {
            return obj1.getAlarmType() - obj2.getAlarmType();
        }
        return obj2.getAlarmType() - obj1.getAlarmType();
    }
}

