/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.comservlets;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogUtil;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TESplitPageBean;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.wnemgrprocess.TEWNEMgrBussinessProcess;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;

public class TETL1NEExplorerServlet
extends HttpServlet {
    private static int GET_DATA_FROM_NE = 1;
    private static int GET_DATA_FROM_MEMORY = 0;
    private static int WRITE_SERVER_INTERFACE_LOG = 1;
    private static final String INPUTDATA_PARAM = "inputdata";
    private static final String SUBMIT_STATUS_WAIT = "wait";
    private static final String SUBMIT_STUTUS_PARAMNAME = "submitstatus";
    private static Logger log = TELogFactory.getNormalLogger();

    public void init() throws ServletException {
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int neid = -1;
        Datainterface outputData = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        response.setContentType("text/xml;charset=UTF-8");
        PrintWriter print = response.getWriter();
        StringWriter out = null;
        int sfid = Integer.parseInt(request.getParameter("sfid"));
        boolean isDebugNeeded = TELogUtil.isContainsPasswordPrint((int)sfid);
        boolean isImportanceLog = TELogUtil.isContainsImportancePrint((int)sfid);
        int flag_Tl1 = -1;
        try {
            flag_Tl1 = Integer.parseInt(request.getParameter("flag"));
        }
        catch (Exception e) {
            flag_Tl1 = GET_DATA_FROM_NE;
        }
        String ilogflagStr = request.getParameter("ilogflag");
        int ilogflag = null == ilogflagStr ? 1 : Integer.parseInt(ilogflagStr);
        String inputDataStr = request.getParameter(INPUTDATA_PARAM);
        String submitstatus = request.getParameter(SUBMIT_STUTUS_PARAMNAME);
        if (submitstatus != null && !submitstatus.isEmpty()) {
            String sessionParamName;
            HttpSession session = request.getSession();
            String inputDataStrSession = (String)session.getAttribute(sessionParamName = "inputdata_" + sfid);
            if (null != inputDataStrSession && !inputDataStrSession.isEmpty()) {
                inputDataStr = inputDataStrSession + inputDataStr;
            }
            if (SUBMIT_STATUS_WAIT.equals(submitstatus)) {
                session.setAttribute(sessionParamName, (Object)inputDataStr);
                return;
            }
            if (null != inputDataStrSession) {
                session.removeAttribute(sessionParamName);
            }
            inputDataStr = URLDecoder.decode(inputDataStr, "UTF-8");
        }
        String ipAddress = this.getClientIPAddress(request);
        String nmUser = request.getParameter("nmUser");
        Datainterface inputData = null;
        Datainterface allData = null;
        SubFunc subFunc = null;
        try {
            if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
                if (!isDebugNeeded) {
                    TELogFactory.getInterfaceLogger().info("The sfid is \u00a3\u00ba" + sfid + "\nThe Page request XML is :\n" + inputDataStr);
                }
            } else if (isImportanceLog) {
                TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nThe Page request XML is :\n" + inputDataStr);
            }
            inputDataStr = new String(inputDataStr.getBytes("ISO-8859-1"), "UTF-8");
            inputData = TECreateObjectFactory.parseInputData((String)inputDataStr);
            neid = this.getNEID(inputData);
            TELogFactory.getNormalLogger().info("neid:" + neid + ", the sfid:" + sfid + ", start time:" + format.format(new Date()));
            if (neid == -1) {
                throw new Exception("Don't write neid!!");
            }
            if (!TENEListMgr.getInstance().isAddedNE(neid)) {
                out = new StringWriter();
                outputData = new Datainterface();
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
                outputData.marshal((Writer)out);
                print.println(((Object)out).toString());
                if (!TESysManagerBean.getInstance().isIntegratedStatus() && !isDebugNeeded) {
                    TELogFactory.getInterfaceLogger().info("The sfid is " + sfid + "\nReturn page's XML Data\u00a3\u00ba" + ((Object)out).toString());
                }
                ((Writer)out).close();
                return;
            }
            subFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
            if (null == subFunc && null == (subFunc = TECreateObjectFactory.getSubFunc((int)sfid))) {
                log.info("Don't found subfunction(sfid = " + sfid + ") description in Functions description file\u00a3\u00a1");
                throw new Exception();
            }
            if (flag_Tl1 == GET_DATA_FROM_MEMORY) {
                allData = (Datainterface)request.getSession().getAttribute(neid + "_" + sfid);
            }
            allData = TEWNEMgrBussinessProcess.performWNEMgrBussinessProcess(neid, subFunc, inputData, allData, nmUser, ipAddress, flag_Tl1);
            if (inputData.getPageParams() != null) {
                log.debug("Need split page!");
                if (WRITE_SERVER_INTERFACE_LOG == ilogflag) {
                    out = new StringWriter();
                    allData.marshal((Writer)out);
                    if (!isDebugNeeded) {
                        TELogFactory.getInterfaceLogger().info("Before split page Data\u00a3\u00ba" + ((Object)out).toString());
                    }
                    ((Writer)out).close();
                }
                if (flag_Tl1 == GET_DATA_FROM_NE) {
                    request.getSession().setAttribute(neid + "_" + sfid, (Object)allData);
                }
                outputData = TESplitPageBean.getSplitPageData((Datainterface)allData, (PageParams)inputData.getPageParams(), (SubFunc)subFunc);
            } else {
                log.debug("Don't need split page!");
                outputData = allData;
            }
            if (null == outputData) {
                throw new Exception("The Output Data is null!!!");
            }
            out = new StringWriter();
            outputData.marshal((Writer)out);
            print.println(((Object)out).toString());
            if (WRITE_SERVER_INTERFACE_LOG == ilogflag) {
                if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
                    if (!isDebugNeeded) {
                        TELogFactory.getInterfaceLogger().info("The sfid is " + sfid + "\nReturn page's XML Data\u00a3\u00ba" + ((Object)out).toString());
                    }
                } else if (isImportanceLog) {
                    TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nThe Page request XML is :\n" + inputDataStr);
                }
            }
            ((Writer)out).close();
        }
        catch (Throwable e) {
            log.error("program inner error\u00a3\u00ba\n", e);
            outputData = new Datainterface();
            out = new StringWriter();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            try {
                outputData.marshal((Writer)out);
                print.println(((Object)out).toString());
                if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
                    if (isDebugNeeded) {
                    } else {
                        TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nReturn page's XML Data is \u00a3\u00ba" + ((Object)out).toString());
                    }
                }
            }
            catch (Exception ex) {
                log.error("Parse fail\u00a3\u00ba", (Throwable)ex);
                return;
            }
        }
        finally {
            TELogFactory.getNormalLogger().info("neid:" + neid + ", the sfid:" + sfid + ", end time:" + format.format(new Date()));
            if (null != out) {
                ((Writer)out).close();
            }
            if (null != print) {
                print.close();
            }
        }
    }

    protected String getClientIPAddress(HttpServletRequest request) {
        String ipAddress_TL1 = null;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            ipAddress_TL1 = request.getHeader("X-Forwarded-For");
            if (null == ipAddress_TL1 || ipAddress_TL1.isEmpty()) {
                ipAddress_TL1 = request.getRemoteAddr();
            }
        } else {
            ipAddress_TL1 = request.getRemoteAddr();
        }
        return ipAddress_TL1;
    }

    protected int getNEID(Datainterface inputData) {
        Param[] paramArr_TL1 = inputData.getBussinessParams().getRowParams(0).getParam();
        int neid = -1;
        int size = paramArr_TL1.length;
        for (int i = 0; i < size; ++i) {
            if (!paramArr_TL1[i].getName().equalsIgnoreCase("neid")) continue;
            try {
                neid = Integer.parseInt(paramArr_TL1[i].getValue());
            }
            catch (NumberFormatException e) {
                log.error("Get neid fail:\n", (Throwable)e);
                return -1;
            }
            return neid;
        }
        return -1;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void destroy() {
        super.destroy();
    }
}

