/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.comservlets;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEFuncTreeInterface;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.pnp.boardmgr.TEPNPBDCfgDataMgr;
import com.huawei.nglct.nelist.pnp.boardmgr.TEPNPBDSupportFunObj;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class TETL1FuncTreeServlet
extends HttpServlet {
    private static final long serialVersionUID = -3867425896389675581L;
    private static final String NEID_PARAM = "neid";
    private static final String SLOT_ID = "slotid";
    private static final String NON_LEAF = "nonleaf";
    private static final String LINK_ATTRIBUTE = "link";
    private static final String BOARD_TYPE = "boardType";
    private static final String LEAF = "leaf";
    private static final String BOARD_TYPE_ATTR = "bdType";
    private static final String NM_USER_ATTR = "nmUser";
    private static final String FUNC_ID_ATTRIBUTE = "funID";
    private static final String SUPPORTED_BY_TAG = "supported_by";
    private static final String FUNCTION_ITEM_TAG = "functionItem";
    private static final String OBJ_IMPL_ATTR = "objsel_impl";
    private static final String IS_T2000_FLAG = "t2000Flag";
    private static final String NM_USER_NAME_ATTR = "nmUserName";
    private String BOARD_FUNC_TREE_FILE_NAME;
    private static final String ONLY_SINGLESTATUS_USE = "0";
    private DeploymentMode sysStatus;
    private String isT2000Flag = null;
    private boolean isNewPNPBoard = false;
    private transient TEPNPBDSupportFunObj bdSupportFunObj = null;

    public void init() throws ServletException {
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response_tl1) throws ServletException, IOException {
        this.BOARD_FUNC_TREE_FILE_NAME = "boardfunctiontree_" + TESysManagerBean.getInstance().getlanguage() + ".xml";
        this.sysStatus = TESysManagerBean.getInstance().getSysStauts();
        String urlPrefix = request.getRequestURL().toString();
        urlPrefix = urlPrefix.substring(0, urlPrefix.lastIndexOf("/") + 1);
        TELogFactory.getNormalLogger().info("The page request URL is\u00a3\u00ba" + urlPrefix);
        int neid = Integer.parseInt(request.getParameter(NEID_PARAM));
        String slotid = request.getParameter(SLOT_ID);
        String boardType = request.getParameter(BOARD_TYPE);
        String nmUser = request.getParameter(NM_USER_ATTR);
        String nmUserName = request.getParameter(NM_USER_NAME_ATTR);
        this.isT2000Flag = request.getParameter(IS_T2000_FLAG);
        this.isNewPNPBoard = TEPNPBDCfgDataMgr.getInstance().isNewPNPBoard(boardType);
        if (this.isNewPNPBoard) {
            this.bdSupportFunObj = TEPNPBDCfgDataMgr.getInstance().getBDSupportFun(Integer.parseInt(boardType));
            if (this.bdSupportFunObj == null) {
                TELogFactory.getNormalLogger().info("Get PNP Board Function Tree Error : slotId=" + slotid + ",boardType=" + boardType);
                return;
            }
        }
        TELogFactory.getNormalLogger().info("The System Running Status is :" + this.sysStatus);
        TELogFactory.getNormalLogger().info("slotid = " + slotid + " boardType = " + boardType + " boardType = " + nmUserName);
        TELogFactory.getNormalLogger().info("The Login neID=" + neid);
        if (null == nmUser) {
            nmUser = TESysManagerBean.getInstance().getSysUser();
        }
        if (null == nmUserName) {
            nmUserName = TESysManagerBean.getInstance().getSysUser();
        }
        Document doc = null;
        NodeList tmp_list_Tl1 = null;
        NodeList noleaf_leaf_list = null;
        NodeList leaf_list_Tl1 = null;
        Element element = null;
        Element noleaf = null;
        String linkValue = "";
        PrintWriter print = null;
        String neVersion = "";
        int neType = 0;
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj((int)neid);
        try {
            response_tl1.setContentType("text/xml;charset=UTF-8");
            response_tl1.setHeader("Cache-Control", "no-cache");
            response_tl1.setHeader("Pragma", "no-cache");
            print = response_tl1.getWriter();
            if (null != this.isT2000Flag && this.sysStatus == TESysManagerConstants.SYS_SINGLE_STATUS) {
                this.handleException(1090650129, print);
                return;
            }
            neType = ne.getNEType();
            neVersion = ne.getHostVersion();
            String domain = TEGetFilePath.getNEDomain((int)neType);
            urlPrefix = urlPrefix + "nemgr" + File.separator + domain + File.separator + "ne_" + neType + File.separator + TEGetFilePath.getFirstVersion((int)neType, (String)neVersion) + File.separator + TEPathManager.PAGE_PROFILE_PATH;
            if (null == slotid || slotid.equals("")) {
                TELogFactory.getNormalLogger().info("Get TL1NE function tree!");
                String NE_FUNC_TREE_FILE_NAME = "nefunctiontree_" + neType + "_" + TESysManagerBean.getInstance().getlanguage() + ".xml";
                String path = TEResourceManager.getPath() + File.separator + TEGetFilePath.getFilePath((int)neType, (String)neVersion, (String)(TEPathManager.CONFIG_PROFILE_PATH + NE_FUNC_TREE_FILE_NAME));
                TELogFactory.getNormalLogger().debug("TL1path=" + path);
                String bundleName = "com.huawei.weblct.tl1ngwdm";
                if (neType == 72 || neType == 113) {
                    bundleName = "com.huawei.weblct.marine_dev";
                }
                if (null == (doc = TEParseXMLFile.parseFile((String)bundleName, (String)path))) {
                    TELogFactory.getNormalLogger().error("Parse file fail\u00a3\u00a1");
                    throw new Exception();
                }
                linkValue = "?nmUser=" + nmUser + "&nmUserName=" + nmUserName + "&neid=" + neid + "&neversion=" + neVersion + "&neType=" + neType;
                TELogFactory.getNormalLogger().debug("Parse file success\u00a3\u00a1");
            } else {
                TELogFactory.getNormalLogger().info("Get board function tree!");
                String path = TEResourceManager.getPath() + File.separator + TEGetFilePath.getFilePath((int)neType, (String)neVersion, (String)(TEPathManager.CONFIG_PROFILE_PATH + this.BOARD_FUNC_TREE_FILE_NAME));
                String bundleName = "com.huawei.weblct.tl1ngwdm";
                if (neType == 72) {
                    bundleName = "com.huawei.weblct.marine_dev";
                }
                if (null == (doc = TEParseXMLFile.parseFile((String)bundleName, (String)path))) {
                    TELogFactory.getNormalLogger().error("Parse file fail\u00a3\u00a1");
                    throw new Exception();
                }
                linkValue = "?nmUser=" + nmUser + "&nmUserName=" + nmUserName + "&neid=" + neid + "&slotid=" + slotid + "&boardType=" + boardType + "&neversion=" + neVersion + "&neType=" + neType;
                TELogFactory.getNormalLogger().debug("Parse file success\u00a3\u00a1");
            }
            NodeList noleaf_list = doc.getElementsByTagName(NON_LEAF);
            for (int index = noleaf_list.getLength() - 1; index >= 0; --index) {
                int i;
                String adpterClass;
                noleaf = (Element)noleaf_list.item(index);
                if (noleaf.hasAttribute("runStatus") && TESysManagerBean.getInstance().isIntegratedStatus() && noleaf.getAttribute("runStatus").equals(ONLY_SINGLESTATUS_USE)) {
                    noleaf.getParentNode().removeChild(noleaf);
                    continue;
                }
                boolean isSupport = true;
                if (noleaf.hasAttribute(OBJ_IMPL_ATTR) && !(adpterClass = noleaf.getAttribute(OBJ_IMPL_ATTR).trim()).equals("")) {
                    try {
                        TEFuncTreeInterface funcTreeinterface = (TEFuncTreeInterface)Class.forName(adpterClass).newInstance();
                        isSupport = funcTreeinterface.isSupportFunc(neid, 0, null, noleaf);
                    }
                    catch (Exception e) {
                        TELogFactory.getNormalLogger().error("TETL1FuncTreeServlet  fail!", (Throwable)e);
                    }
                }
                if (!isSupport) {
                    noleaf.getParentNode().removeChild(noleaf);
                    continue;
                }
                leaf_list_Tl1 = noleaf.getElementsByTagName(LEAF);
                for (i = leaf_list_Tl1.getLength() - 1; i >= 0; --i) {
                    element = (Element)leaf_list_Tl1.item(i);
                    if (element.getParentNode().equals(noleaf)) {
                        this.processLeafNode(neid, slotid, element, boardType, urlPrefix, linkValue);
                        continue;
                    }
                    NodeList nodelist = element.getElementsByTagName(FUNCTION_ITEM_TAG);
                    if (null != nodelist && nodelist.getLength() != 0) continue;
                    element.getParentNode().removeChild(element);
                }
                tmp_list_Tl1 = noleaf.getElementsByTagName(NON_LEAF);
                for (i = tmp_list_Tl1.getLength() - 1; i >= 0; --i) {
                    element = (Element)tmp_list_Tl1.item(i);
                    noleaf_leaf_list = element.getElementsByTagName(LEAF);
                    if (null != noleaf_leaf_list && noleaf_leaf_list.getLength() != 0) continue;
                    element.getParentNode().removeChild(element);
                }
                leaf_list_Tl1 = noleaf.getElementsByTagName(LEAF);
                tmp_list_Tl1 = noleaf.getElementsByTagName(NON_LEAF);
                if (index == 0 || null != leaf_list_Tl1 && leaf_list_Tl1.getLength() != 0 || null != tmp_list_Tl1 && tmp_list_Tl1.getLength() != 0) continue;
                noleaf.getParentNode().removeChild(noleaf);
            }
            String out_TL1 = this.serializeDom(doc);
            print.println(out_TL1);
            TELogFactory.getInterfaceLogger().info("The function tree is\u00a3\u00ba\n" + out_TL1);
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().info("Don't found file\u00a3\u00ba");
            this.handleException(3840, print);
            return;
        }
        catch (Exception e) {
            this.handleException(1090646019, print);
            TELogFactory.getNormalLogger().error("Get function tree fail\u00a3\u00ba\n", (Throwable)e);
            return;
        }
        finally {
            if (null != print) {
                print.close();
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void destroy() {
        super.destroy();
    }

    public void processLeafNode(int neid, String slotid, Element element, String boardType, String urlPrefix, String linkValue) {
        NodeList nodelist = element.getElementsByTagName(FUNCTION_ITEM_TAG);
        Element tmpElement = null;
        if (null == nodelist || nodelist.getLength() == 0) {
            element.getParentNode().removeChild(element);
        } else {
            String adpterClass;
            if (element.hasAttribute("runStatus") && TESysManagerBean.getInstance().isIntegratedStatus() && element.getAttribute("runStatus").equals(ONLY_SINGLESTATUS_USE)) {
                element.getParentNode().removeChild(element);
                return;
            }
            boolean isSupport = true;
            if (element.hasAttribute(OBJ_IMPL_ATTR) && !(adpterClass = element.getAttribute(OBJ_IMPL_ATTR).trim()).equals("")) {
                try {
                    TEFuncTreeInterface funcTreeinterface = (TEFuncTreeInterface)Class.forName(adpterClass).newInstance();
                    isSupport = funcTreeinterface.isSupportFunc(neid, 0, null, element);
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("TETL1FuncTreeServlet  fail!", (Throwable)e);
                }
            }
            if (element.hasAttribute("neversion")) {
                isSupport = this.checkNeVersion(neid, element.getAttribute("neversion"));
            }
            if (!isSupport) {
                element.getParentNode().removeChild(element);
                return;
            }
            for (int i = nodelist.getLength() - 1; i >= 0; --i) {
                tmpElement = (Element)nodelist.item(i);
                String funId = tmpElement.getAttribute(FUNC_ID_ATTRIBUTE);
                if (this.isNewPNPBoard) {
                    if (!this.bdSupportFunObj.isSupportFunId(funId)) {
                        tmpElement.getParentNode().removeChild(tmpElement);
                        continue;
                    }
                    String flag = tmpElement.getAttribute("flag");
                    String pnpflag = this.bdSupportFunObj.getSpecialFlag(funId);
                    if (flag != null && !flag.equals("") && pnpflag == null || pnpflag != null && !pnpflag.equals(flag)) {
                        tmpElement.getParentNode().removeChild(tmpElement);
                        continue;
                    }
                }
                this.processFunctionItemNode(neid, slotid, tmpElement, boardType, urlPrefix, linkValue);
            }
            nodelist = element.getElementsByTagName(FUNCTION_ITEM_TAG);
            if (null == nodelist || nodelist.getLength() == 0) {
                element.getParentNode().removeChild(element);
            }
        }
    }

    public void processFunctionItemNode(int neid, String slotid, Element element_tl1, String boardtype, String urlPrefix, String linkValue) {
        boolean verSupport;
        int funcid = Integer.valueOf(element_tl1.getAttribute(FUNC_ID_ATTRIBUTE));
        if (element_tl1.hasAttribute("neversion") && !(verSupport = this.checkNeVersion(neid, element_tl1.getAttribute("neversion")))) {
            element_tl1.getParentNode().removeChild(element_tl1);
            return;
        }
        NodeList nodelist_TL1 = element_tl1.getElementsByTagName(SUPPORTED_BY_TAG);
        Element childElement = null;
        boolean isSupport = false;
        if (element_tl1.hasAttribute("runStatus") && TESysManagerBean.getInstance().isIntegratedStatus() && element_tl1.getAttribute("runStatus").equals(ONLY_SINGLESTATUS_USE)) {
            element_tl1.getParentNode().removeChild(element_tl1);
            return;
        }
        if (null == nodelist_TL1 || nodelist_TL1.getLength() == 0) {
            isSupport = true;
        }
        if (null != nodelist_TL1) {
            for (int i = nodelist_TL1.getLength() - 1; i >= 0; --i) {
                String adpterClass;
                childElement = (Element)nodelist_TL1.item(i);
                if (isSupport) {
                    element_tl1.removeChild(childElement);
                    continue;
                }
                if (childElement.hasAttribute(BOARD_TYPE_ATTR)) {
                    String bdType = childElement.getAttribute(BOARD_TYPE_ATTR).trim();
                    if (!bdType.equals("")) {
                        bdType = bdType.substring(1, bdType.length() - 1);
                        Vector boardlist = null;
                        if (null == boardtype || boardtype.equals("")) {
                            boardlist = TENEListUtils.getNEObj((int)neid).getClonedBoardList();
                        }
                        isSupport = this.isSupportFunc(neid, bdType, boardlist, boardtype, childElement.getAttribute("neversion"));
                    }
                } else {
                    isSupport = true;
                }
                if (isSupport && childElement.hasAttribute(OBJ_IMPL_ATTR) && !(adpterClass = childElement.getAttribute(OBJ_IMPL_ATTR).trim()).equals("")) {
                    try {
                        TEFuncTreeInterface funcTreeinterface = (TEFuncTreeInterface)Class.forName(adpterClass).newInstance();
                        isSupport = funcTreeinterface.isSupportFunc(neid, funcid, boardtype, childElement);
                    }
                    catch (Exception e) {
                        TELogFactory.getNormalLogger().error("TETL1FuncTreeServlet  fail!", (Throwable)e);
                    }
                }
                if (!isSupport && i == 0) {
                    element_tl1.getParentNode().removeChild(element_tl1);
                    break;
                }
                element_tl1.removeChild(childElement);
            }
        }
        if (isSupport) {
            String link = element_tl1.getAttribute(LINK_ATTRIBUTE);
            if (null != this.isT2000Flag) {
                link = urlPrefix + link;
            }
            link = link + linkValue + "&funnodeid=" + element_tl1.getAttribute(FUNC_ID_ATTRIBUTE);
            link = link.replace('\\', '/');
            element_tl1.setAttribute(LINK_ATTRIBUTE, link);
        }
    }

    private boolean isSupportFunc(int neid, String supportbdType, Vector boardList, String boardtypeStr, String suppVersions) {
        int boardType = 0;
        try {
            boardType = Integer.parseInt(boardtypeStr);
        }
        catch (NumberFormatException e) {
            boardType = 0;
        }
        if (null == boardList) {
            boardList = new Vector();
        }
        if (this.isNewPNPBoard) {
            return this.checkNeVersion(neid, suppVersions);
        }
        String[] bdTypeArr = supportbdType.split(",");
        TEBoard board = null;
        for (int i = bdTypeArr.length - 1; i >= 0; --i) {
            if (bdTypeArr[i].indexOf("-") > 0) {
                int minBoardType = Integer.parseInt(bdTypeArr[i].split("-")[0]);
                int maxBoardType = Integer.parseInt(bdTypeArr[i].split("-")[1]);
                if (boardType >= minBoardType && boardType <= maxBoardType) {
                    return this.checkNeVersion(neid, suppVersions);
                }
                for (int len = boardList.size() - 1; len >= 0; --len) {
                    board = (TEBoard)boardList.get(len);
                    if (board.getBoardType() < minBoardType || board.getBoardType() > maxBoardType) continue;
                    return this.checkNeVersion(neid, suppVersions);
                }
                continue;
            }
            if (boardType == Integer.parseInt(bdTypeArr[i])) {
                return this.checkNeVersion(neid, suppVersions);
            }
            for (int len = boardList.size() - 1; len >= 0; --len) {
                board = (TEBoard)boardList.get(len);
                if (Integer.parseInt(bdTypeArr[i]) != board.getBoardType()) continue;
                return this.checkNeVersion(neid, suppVersions);
            }
        }
        return false;
    }

    private String serializeDom(Document doc_TL1) {
        try {
            DOMImplementationRegistry registry_Tl1 = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domImplLS_TL1 = (DOMImplementationLS)((Object)registry_Tl1.getDOMImplementation("LS"));
            LSSerializer ser = domImplLS_TL1.createLSSerializer();
            LSOutput out = domImplLS_TL1.createLSOutput();
            StringWriter stringOut = new StringWriter();
            out.setCharacterStream(stringOut);
            ser.write(doc_TL1, out);
            return stringOut.toString();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("serialize document fail\u00a3\u00ba", (Throwable)e);
            return null;
        }
    }

    public void handleException(int code_TL1, PrintWriter print_TL1) {
        ErrorMessage error = TEErrorResourceUtil.getErrorMessage((int)code_TL1);
        StringWriter stringout_Tl1 = null;
        try {
            stringout_Tl1 = new StringWriter();
            error.marshal((Writer)stringout_Tl1);
        }
        catch (Exception marshalException) {
            TELogFactory.getNormalLogger().error("Parse file fail\u00a3\u00ba", (Throwable)marshalException);
        }
        TELogFactory.getInterfaceLogger().info("The function tree is\u00a3\u00ba\n" + stringout_Tl1.toString());
        print_TL1.println(stringout_Tl1.toString());
    }

    private boolean checkNeVersion(int neid, String suppVersions) {
        String[] versions;
        if (suppVersions == null || suppVersions.equals("")) {
            return true;
        }
        String hostVersion = TENEListUtils.getNEObj((int)neid).getHostVersion();
        return hostVersion.compareToIgnoreCase((versions = suppVersions.substring(1, suppVersions.length() - 1).split("-"))[0]) >= 0 && hostVersion.compareToIgnoreCase(versions[1]) <= 0;
    }
}

