/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.teneexplorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class TEUploadExplorerServlet
extends HttpServlet {
    private static final long serialVersionUID = 123456789L;
    private static final String SFID_PARAM = "sfid";
    private static final String NEID_PARAM = "neid";
    private static final String INPUTDATA_PARAM = "inputdata";

    public void doGet(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        this.doPost(req, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        PrintWriter print;
        block12: {
            int sfid = Integer.parseInt(req.getParameter(SFID_PARAM));
            int neid = Integer.parseInt(req.getParameter(NEID_PARAM));
            String nmUser = req.getParameter("nmUser");
            rsp.setContentType("text/xml;charset=UTF-8");
            print = rsp.getWriter();
            StringWriter out = new StringWriter();
            String ipAddress = req.getRemoteAddr();
            Datainterface inputData = null;
            Datainterface outputData = null;
            SubFunc subFuncFile = null;
            try {
                String inputDataStr = URLDecoder.decode(req.getParameter(INPUTDATA_PARAM), "UTF-8");
                inputData = TECreateObjectFactory.parseInputData((String)inputDataStr);
                int result = this.uploadFile(neid, inputData, req, rsp);
                if (result == 0) {
                    subFuncFile = TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
                    String classMapping = subFuncFile.getClassMapping();
                    TENEMgrInterface neMgrBean = null;
                    neMgrBean = classMapping == null ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(classMapping).newInstance();
                    outputData = neMgrBean.performBussinessProcess(neid, subFuncFile, inputData, null, nmUser, ipAddress);
                } else {
                    outputData = new Datainterface();
                    outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                }
                outputData.marshal((Writer)out);
                print.println(((Object)out).toString());
                ((Writer)out).close();
                this.deleteInputRowParams(inputData);
                if (null == out) break block12;
            }
            catch (Exception e) {
                block13: {
                    try {
                        TELogFactory.getNormalLogger().error("TEUploadExplorerServlet fail!", (Throwable)e);
                        outputData = new Datainterface();
                        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)43138));
                        try {
                            outputData.marshal((Writer)out);
                        }
                        catch (Exception e1) {
                            TELogFactory.getNormalLogger().error("outputData marshal fail!", (Throwable)e1);
                        }
                        print.println(((Object)out).toString());
                        ((Writer)out).close();
                        this.deleteInputRowParams(inputData);
                        if (null == out) break block13;
                    }
                    catch (Throwable throwable) {
                        this.deleteInputRowParams(inputData);
                        if (null != out) {
                            ((Writer)out).close();
                        }
                        if (null != print) {
                            print.close();
                        }
                        throw throwable;
                    }
                    ((Writer)out).close();
                }
                if (null != print) {
                    print.close();
                }
            }
            ((Writer)out).close();
        }
        if (null != print) {
            print.close();
        }
    }

    private int uploadFile(int neid, Datainterface inputData, HttpServletRequest req, HttpServletResponse rsp) {
        String cfgFileRootPath = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, (String)"");
        String tmppath = new StringBuffer(cfgFileRootPath).append(File.separator).append("temp").toString();
        this.makeFileDir(tmppath);
        int result = 0;
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(0x100000);
            factory.setRepository(new File(tmppath));
            ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)factory);
            sfu.setFileSizeMax(0x500000L);
            sfu.setSizeMax(0xA00000L);
            sfu.setHeaderEncoding("UTF-8");
            List list = sfu.parseRequest(req);
            for (FileItem item : list) {
                if (item.isFormField()) continue;
                String realfilename = this.uploadFile(item);
                this.refreshInputRowParams(inputData, item.getFieldName(), realfilename);
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("uploadFile fail!", (Throwable)ex);
            result = 43138;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadFile(FileItem item) {
        String filename = item.getName();
        int pos = filename.lastIndexOf("\\");
        if (pos > 0) {
            filename = filename.substring(pos + 1);
        }
        String cfgFileRootPath = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, (String)"");
        String uploadpath = new StringBuffer(cfgFileRootPath).append(File.separator).append("upload").toString();
        String realfilename = this.makeFileDir(uploadpath) + File.separator + UUID.randomUUID().toString() + "_" + filename;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = item.getInputStream();
            out = new FileOutputStream(realfilename);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("uploadFile fail!", (Throwable)ex);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
                if (null != out) {
                    out.close();
                }
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("uploadFile->CloseIO fail!", (Throwable)e);
            }
            item.delete();
        }
        return realfilename;
    }

    private void deleteInputRowParams(Datainterface inputData) {
        if (inputData != null) {
            int len = inputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                File file;
                RowParams row = inputData.getBussinessParams().getRowParams(i);
                Param param = row.getParam("realfilename");
                if (param == null || param.getValue() == null || !(file = new File(param.getValue())).exists()) continue;
                file.delete();
            }
        }
    }

    private void refreshInputRowParams(Datainterface inputData, String fieldname, String realfilename) {
        int len = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowParams row = inputData.getBussinessParams().getRowParams(i);
            Param param = row.getParam("fieldname");
            if (param != null && !fieldname.equals(param.getValue())) continue;
            row.addParam("realfilename", realfilename);
        }
    }

    private String makeFileDir(String path) {
        File tmpDir = new File(path);
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        return path;
    }
}

