/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.teneexplorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.system.TESystemUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class TEStrReportServlet
extends HttpServlet {
    private static final long serialVersionUID = 1866668182305232948L;
    private static final String SFID_PARAM = "sfid";
    private static final String FLAG_PARAM = "flag";
    private static final String INPUTDATA_PARAM = "inputdata";
    private static final String NEID_PARAM = "neid";
    private static final String FILENAME_PARAM = "filename";
    private static int GET_DATA_FROM_NE = 1;
    private static int GET_DATA_FROM_MEMORY = 0;
    private String fileName = "";
    private static Logger log = TELogFactory.getNormalLogger();
    private String encode = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block23: {
            this.encode = System.getProperty("file.encoding");
            String browse_StrReport = request.getHeader("User-Agent");
            if ((browse_StrReport = browse_StrReport.substring(browse_StrReport.indexOf("("), browse_StrReport.length())).indexOf("IE") >= 0) {
                String Language_strReport = request.getHeader("Accept-Language");
                if (Language_strReport.indexOf("zh") >= 0) {
                    this.encode = "GBK";
                } else if (Language_strReport.indexOf("en") >= 0) {
                    this.encode = "ISO-8859-1";
                }
            } else {
                this.encode = browse_StrReport.indexOf("Gecko") >= 0 ? "unicode" : System.getProperty("file.encoding");
            }
            int neid = -1;
            int sfid = -1;
            int funcid = -1;
            int flag = -1;
            String dateFormat = TimeZoneDateBean.getTimeConvertFormat();
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            sfid = Integer.parseInt(request.getParameter(SFID_PARAM));
            TELogFactory.getNormalLogger().info("The function(TEStrReportServlet- sfid:" + sfid + ") start time is " + format.format(new Date()));
            try {
                flag = Integer.parseInt(request.getParameter(FLAG_PARAM));
            }
            catch (Exception e) {
                flag = GET_DATA_FROM_NE;
            }
            String inputDataStr = request.getParameter(INPUTDATA_PARAM);
            inputDataStr = new String(inputDataStr.getBytes("ISO-8859-1"), "UTF-8");
            String ipAddress = request.getRemoteAddr();
            String nmUser = request.getParameter("nmUser");
            if (null == nmUser || "".equals(nmUser)) {
                nmUser = TESysManagerBean.getInstance().getSysUser();
            }
            Datainterface inputData = null;
            Datainterface allData = null;
            SubFunc subFunc = null;
            try {
                TELogFactory.getInterfaceLogger().info("The sfid is \u00a3\u00ba" + sfid + "\nThe Page request XML is :\n" + inputDataStr);
                inputData = TECreateObjectFactory.parseInputData((String)inputDataStr);
                neid = this.getNEID(inputData);
                subFunc = -1 == neid ? TECreateObjectFactory.getSubFunc((int)sfid) : TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
                if (null == subFunc) {
                    subFunc = TECreateObjectFactory.getSubFunc((int)sfid);
                }
                String classMapping = subFunc.getClassMapping();
                TENEMgrInterface neMgrBean = null;
                if (flag == GET_DATA_FROM_NE) {
                    if (classMapping == null) {
                        log.debug("The Bussiness Process program is com.huawei.nglct.explorer.TENEExplorerBean");
                        neMgrBean = (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance();
                    } else {
                        log.debug("The BussinessProcess program is " + classMapping);
                        neMgrBean = (TENEMgrInterface)Class.forName(classMapping).newInstance();
                    }
                    allData = neMgrBean.performBussinessProcess(neid, subFunc, inputData, null, nmUser, ipAddress);
                } else if (flag == GET_DATA_FROM_MEMORY) {
                    allData = (Datainterface)request.getSession().getAttribute(neid + "_" + funcid);
                    if (null != classMapping) {
                        neMgrBean = (TENEMgrInterface)Class.forName(classMapping).newInstance();
                        allData = neMgrBean.performBussinessProcess(neid, subFunc, inputData, allData, nmUser, ipAddress);
                    }
                }
                if (null == allData) break block23;
                this.fileName = this.getFileName(inputData);
                byte[] result = this.getSaveText(allData);
                response.reset();
                ServletOutputStream out = response.getOutputStream();
                response.setHeader("Content-Type", "application/force-download");
                response.setHeader("Content-disposition", "attachment;filename=" + this.fileName + ".txt");
                response.setHeader("Expires", "0");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                response.setHeader("Cache-Control", "public");
                BufferedOutputStream bos = null;
                try {
                    bos = new BufferedOutputStream((OutputStream)out);
                    bos.write(result, 0, result.length);
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("TEDownLoadLsReport fail!", (Throwable)e);
                }
                finally {
                    if (bos != null) {
                        bos.close();
                    }
                }
            }
            catch (Exception e) {
                log.info("print or save fail:", (Throwable)e);
                TESystemUtil.sendRedirect((String)"/weblct/page/printerror.html?message=0", (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
    }

    private byte[] getSaveText(Datainterface outputData) {
        byte[] result = new byte[]{};
        try {
            String lineSep = System.getProperty("line.separator");
            RowParams[] rowParams = outputData.getBussinessParams().getRowParams();
            ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
            for (int k = 0; k < rowParams.length; ++k) {
                RowParams row = rowParams[k];
                outputBuffer.write(row.getParam(0).getValue().getBytes(this.encode));
                outputBuffer.write(lineSep.getBytes(this.encode));
            }
            result = outputBuffer.toByteArray();
            outputBuffer.close();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Save all txt Record", (Throwable)e);
        }
        return result;
    }

    private String getFileName(Datainterface inputData) {
        String filename = "";
        Param[] paramArr = inputData.getBussinessParams().getRowParams(0).getParam();
        int size = paramArr.length;
        for (int i = 0; i < size; ++i) {
            String pName = paramArr[i].getName();
            String pvalue = paramArr[i].getValue();
            if (!pName.equalsIgnoreCase(FILENAME_PARAM)) continue;
            filename = pvalue;
            break;
        }
        return filename;
    }

    private int getNEID(Datainterface inputData) {
        Param[] paramArr_strReport = inputData.getBussinessParams().getRowParams(0).getParam();
        int neid = -1;
        int size = paramArr_strReport.length;
        for (int i = 0; i < size; ++i) {
            if (!paramArr_strReport[i].getName().equalsIgnoreCase(NEID_PARAM)) continue;
            try {
                neid = Integer.parseInt(paramArr_strReport[i].getValue());
            }
            catch (NumberFormatException e) {
                log.error("Get neid fail:\n", (Throwable)e);
                return -1;
            }
            return neid;
        }
        return -1;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

