/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.teneexplorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TEServerFileServlet
extends HttpServlet {
    private static final long serialVersionUID = -7617698418739243848L;
    private Calendar createCalen;
    private static final String SUBMIT_STATUS_WAIT = "wait";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse res) throws ServletException, IOException {
        this.createCalen = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        String fileContent = request.getParameter("fileContent");
        if (fileContent == null || fileContent.equals("")) {
            TELogFactory.getNormalLogger().error("TEServerFileServlet fileContent is null!");
            return;
        }
        String fileContentSession = (String)request.getSession(true).getAttribute("fileContent");
        String submitstatus = request.getParameter("submitstatus");
        if (SUBMIT_STATUS_WAIT.equals(submitstatus)) {
            if (null != fileContentSession && !fileContentSession.isEmpty()) {
                fileContent = fileContentSession + fileContent;
            }
            request.getSession(true).setAttribute("fileContent", (Object)fileContent);
        } else {
            String username = request.getParameter("user");
            String fileName = this.getFileName(request.getParameter("fileName"));
            fileContent = URLDecoder.decode(fileContent, "UTF-8");
            if (null != fileContentSession && !fileContentSession.isEmpty()) {
                fileContent = fileContentSession + fileContent;
            }
            String content = this.appenPrefixToContent(fileContent, request.getParameter("fileName"), username);
            request.getSession(true).removeAttribute("fileContent");
            ServletOutputStream out = res.getOutputStream();
            res.setHeader("Content-Type", "application/force-download");
            res.setHeader("Content-disposition", "attachment;filename=" + fileName);
            res.setHeader("Content-disposition", "attachment;filename=" + fileName);
            res.setHeader("Expires", "0");
            res.setHeader("Pragma", "public");
            res.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            res.setHeader("Cache-Control", "public");
            BufferedOutputStream bos = null;
            try {
                bos = new BufferedOutputStream((OutputStream)out);
                byte[] buff = content.getBytes("UTF-8");
                bos.write(buff, 0, buff.length);
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("TEDownLoadLsReport fail!", (Throwable)e);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
            }
        }
    }

    private String appenPrefixToContent(String content, String fileName, String username) throws UnsupportedEncodingException {
        if (fileName == null || fileName.equals("")) {
            fileName = "fileName";
        }
        StringBuffer tempContent = new StringBuffer();
        tempContent.append("                                                 ");
        tempContent.append(fileName);
        tempContent.append("\r\n");
        tempContent.append("\r\n");
        String time = TEDateUtils.calendarToStr((Calendar)this.createCalen);
        TEResourceUtil resUtil = TEResourceUtil.getInstance((String)("res" + File.separator + "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini"));
        tempContent.append("                              ");
        tempContent.append(resUtil.getString("savetime"));
        tempContent.append(time);
        tempContent.append("    ");
        tempContent.append(resUtil.getString("username"));
        if (username != null) {
            tempContent.append(username);
        }
        tempContent.append("\r\n");
        tempContent.append("\r\n");
        tempContent.append("\r\n");
        tempContent.append(content);
        return tempContent.toString();
    }

    public String getFileName(String fileName) throws UnsupportedEncodingException {
        String tempStr = null;
        tempStr = fileName == null || fileName.equals("") ? "fileName" : (TESysManagerBean.getInstance().getlanguage().equals("zh") ? new String(fileName.getBytes("GBK"), "ISO8859_1") : fileName);
        tempStr = tempStr.replace(" ", "_");
        StringBuffer name = new StringBuffer();
        name.append(tempStr).append("_");
        String time = TEDateUtils.calendarToStr((Calendar)this.createCalen);
        time = time.replaceAll(" ", "_");
        time = time.replaceAll(":", "_");
        time = time.replaceAll("/", "_");
        name.append(time);
        name.append(".txt");
        return name.toString();
    }

    protected void doPost(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.doGet(arg0, arg1);
    }
}

